/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.include;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.preferences.PreferencesUtils;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;

public class IncludeFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public IncludeFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "IncludeUsageIncludeLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.INCLUDE, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Include");
        this.addResourceColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IncludeUsageProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        this.addProgramColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IncludeUsageStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addStatementTypeColumns(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.VARIABLE, defaultPatterns, null);
        e.put("Fixed.position", Boolean.toString(true));
        this.entries.add(e);
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        super.makeFilterEntrySettings(e, type);
        if (ResultElementType.VARIABLE.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            IPreferenceStore store = PreferencesUtils.getPreferenceStore();
            boolean considerVar = store.getBoolean("display defined var in include");
            e.put(FilterEntry.ATTR_USE, Boolean.toString(considerVar));
            e.put("incontext", "defined in include");
        }
    }

    private void addProgramColumns(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_START_ROW.getName(), DatabaseMetadata.PRG_ANCESTOR_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_END_ROW.getName(), DatabaseMetadata.PRG_ANCESTOR_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_START_COL.getName(), DatabaseMetadata.PRG_ANCESTOR_START_COL.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_END_COL.getName(), DatabaseMetadata.PRG_ANCESTOR_END_COL.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        this.addCommonColumns(e);
    }

    private void addStatementTypeColumns(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_TYPE_ID.getName(), DatabaseMetadata.STMT_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_TYPE_NAME.getName(), DatabaseMetadata.STMT_TYPE_NAME.getName());
        e.put("DynamicProcParamName", "@StatementType");
        this.addCommonColumns(e);
    }

    private void addResourceColumns(FilterEntry e) {
        e.put(DatabaseMetadata.INCLUDE_ID.getName(), DatabaseMetadata.INCLUDE_ID.getName());
        e.put(DatabaseMetadata.INCLUDE_NAME.getName(), DatabaseMetadata.INCLUDE_NAME.getName());
        e.put(DatabaseMetadata.INCLUDE_START_ROW.getName(), DatabaseMetadata.INCLUDE_START_ROW.getName());
        e.put(DatabaseMetadata.INCLUDE_START_COL.getName(), DatabaseMetadata.INCLUDE_START_COL.getName());
        e.put(DatabaseMetadata.INCLUDE_END_ROW.getName(), DatabaseMetadata.INCLUDE_END_ROW.getName());
        e.put(DatabaseMetadata.INCLUDE_END_COL.getName(), DatabaseMetadata.INCLUDE_END_COL.getName());
        e.put(DatabaseMetadata.INCLUDE_PATH_ID.getName(), DatabaseMetadata.INCLUDE_PATH_ID.getName());
        e.put(DatabaseMetadata.INCLUDE_PATH.getName(), DatabaseMetadata.INCLUDE_PATH.getName());
        this.addCommonColumns(e);
    }

    private void addCommonColumns(FilterEntry e) {
        e.put(DatabaseMetadata.RESOURCE_TYPE.getName(), DatabaseMetadata.RESOURCE_TYPE.getName());
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), DatabaseMetadata.STMT_PATH_STR.getName());
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), DatabaseMetadata.STMT_START_ROW.getName());
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), DatabaseMetadata.STMT_END_ROW.getName());
        e.put(DatabaseMetadata.STMT_START_COL.getName(), DatabaseMetadata.STMT_START_COL.getName());
        e.put(DatabaseMetadata.STMT_END_COL.getName(), DatabaseMetadata.STMT_END_COL.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_OCCUR_ID.getName(), DatabaseMetadata.STMT_OCCUR_ID.getName());
    }
}

