/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.include;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.include.IncludeFilter;
import com.ez.analysis.mainframe.usage.include.IncludeTreeProvider;
import com.ez.analysis.mainframe.usage.include.IncludeUsageAnalysis;
import com.ez.analysis.mainframe.usage.include.State;
import com.ez.analysis.mainframe.usage.preferences.PreferencesUtils;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.queries.StoredProcDetail;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IncludeDescriptor.class);
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String INCLUDE_NAME_PARAM_LIMIT = "@IncludeLimit";
    private static final String INCLUDE_NAME_COLUMN = DatabaseMetadata.INCLUDE_NAME.getName();
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_TYPE_NAME.getName();
    private static final String STATEMENT_PARAM_LIMIT = "@StartRowLimit";
    private static final String RESOURCE_TYPE = "ResourceType";
    public static final String MAINFRAME_INCLUDE_SCHEMA_USAGE = "com.ez.analysis.mainframe.usage.include";
    private static final String INCLUDE_USAGE_FILTERS_NAME = "IncludeUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> INCLUDE_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        private static final long serialVersionUID = 1L;
        {
            ArrayList<ColumnInfo> projectList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), projectList);
            projectList.add(DatabaseMetadata.PROJECT_NAME);
            ArrayList<ColumnInfo> programList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROGRAM.name(), programList);
            programList.add(DatabaseMetadata.PRG_ID);
            programList.add(DatabaseMetadata.PRG_NAME);
            programList.add(DatabaseMetadata.PRG_TYPE_ID);
            programList.add(DatabaseMetadata.PRG_PATH);
            ArrayList<ColumnInfo> resourceList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.INCLUDE.name(), resourceList);
            resourceList.add(DatabaseMetadata.INCLUDE_NAME);
            resourceList.add(DatabaseMetadata.INCLUDE_PATH);
            ArrayList<ColumnInfo> statementTypeList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.STMT_TYPE.name(), statementTypeList);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_ID);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_NAME);
            statementTypeList.add(DatabaseMetadata.RESOURCE_TYPE);
            statementTypeList.add(DatabaseMetadata.STMT_PATH_STR);
            statementTypeList.add(DatabaseMetadata.STMT_START_ROW);
            statementTypeList.add(DatabaseMetadata.STMT_START_COL);
            statementTypeList.add(DatabaseMetadata.STMT_END_ROW);
            statementTypeList.add(DatabaseMetadata.STMT_END_COL);
            ArrayList<ColumnInfo> vlist = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.VARIABLE.name(), vlist);
            vlist.add(DatabaseMetadata.VAR_ID);
            vlist.add(DatabaseMetadata.VAR_NAME);
            vlist.add(DatabaseMetadata.VAR_TYPE_ID);
            vlist.add(DatabaseMetadata.VAR_TYPE_DESCRIPTION);
            vlist.add(DatabaseMetadata.VAR_IsField);
            vlist.add(DatabaseMetadata.VAR_IsFiller);
            vlist.add(DatabaseMetadata.VAR_PATH_STR);
            vlist.add(DatabaseMetadata.VAR_START_ROW);
            vlist.add(DatabaseMetadata.VAR_START_COL);
            vlist.add(DatabaseMetadata.VAR_END_ROW);
            vlist.add(DatabaseMetadata.VAR_END_COL);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    public static final String VAR_DEFINED_IN_INCLUDE_KEY = "VariableFromInclude";
    private static Map<String, StoredProcDetail> localSPMap;

    static {
        localSPMap = new HashMap<String, StoredProcDetail>(){
            {
                this.put(IncludeDescriptor.VAR_DEFINED_IN_INCLUDE_KEY, new StoredProcDetail("EZViewer_Usage_VarDefInIncl_Selective", DatabaseMetadata.STMT_OCCUR_ID, DatabaseMetadata.VAR_DEFINED_IN_INCLUDE_HEADER_INFO, (List<Pair<ResultElementType, Integer>>)new ArrayList<Pair<ResultElementType, Integer>>(){
                    {
                        this.add(new Pair((Object)ResultElementType.VARIABLE, (Object)2));
                    }
                }));
            }
        };
    }

    public IncludeDescriptor(IncludeUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_INCLUDE_SCHEMA_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public Map<String, StoredProcDetail> getAdditionalSpMap() {
        return localSPMap;
    }

    @Override
    public boolean mustRunAdditionalSP() {
        boolean ok = super.mustRunAdditionalSP();
        if (ok) {
            FilterData fd;
            FilterData filterData = fd = this.state != null ? (FilterData)this.state.getData().get("FilterData") : null;
            if (fd != null) {
                ok = this.getEntryInUseNames(fd).contains(ResultElementType.VARIABLE.name());
            } else {
                IPreferenceStore store = PreferencesUtils.getPreferenceStore();
                boolean considerVar = store.getBoolean("display defined var in include");
                L.debug("use setting from preferences for Variable filter entry {} ", (Object)considerVar);
                ok = considerVar;
            }
        }
        return ok;
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IncludeTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IncludeFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.INCLUDE_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_Includes";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.INCLUDE.name(), " @IncludeLimit INT, @Include VARCHAR(64)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64)");
            spParam.put(ResultElementType.VARIABLE.name(), " @VarName VARCHAR(250)");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.PROGRAM.name(), "((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ") AND (" + "@Ancestor" + " = ''%'' or UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.INCLUDE.name(), "(@Include = ''%'' or UPPER(" + INCLUDE_NAME_COLUMN + ") " + INCLUDE_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), "(@StatementType = ''%'' or UPPER(" + STATEMENT_TYPE_COLUMN + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.VARIABLE.name(), "( @VarName  = ''%'' OR EXISTS\r\n\t(Select " + DatabaseMetadata.VAR_NAME.getName() + " from Occurrences o INNER JOIN Variables ON Variables.OccurID = o.OccurID and o.SourceType = StmtOccurId WHERE UPPER(" + DatabaseMetadata.VAR_NAME.getName() + ") LIKE @VarName " + AbstractQueryBuilder.getEscapeDBClause('\\') + "))");
        }
        return spWhereClause;
    }

    @Override
    public String getFileName() {
        return INCLUDE_USAGE_FILTERS_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.INCLUDE, DatabaseMetadata.INCLUDE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_TYPE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.STMT_START_ROW.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
        this.elemTypeToElemNameColumns.put(ResultElementType.VARIABLE, DatabaseMetadata.VAR_NAME.getName());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return INCLUDE_TABLE_CSV_HEADER;
    }

    @Override
    public int getDefaultExpandLevel() {
        return 6;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PRG_NAME.getName()).limitParamName(IncludeDescriptor.PROGRAM_PARAM_LIMIT).create());
                this.put(ResultElementType.INCLUDE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.INCLUDE_NAME.getName()).limitParamName(IncludeDescriptor.INCLUDE_NAME_PARAM_LIMIT).create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_TYPE_NAME.getName()).limitParamName(IncludeDescriptor.STATEMENT_TYPE_PARAM_LIMIT).create());
                this.put(ResultElementType.STMT_SOURCE_INFO.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_START_ROW.getName()).limitParamName(IncludeDescriptor.STATEMENT_PARAM_LIMIT).create());
            }
        };
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "Include";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

