/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.include;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.VariableUsageNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InclVarCallback
extends AbstractProcessRowCallback {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Logger L = LoggerFactory.getLogger(InclVarCallback.class);
    private Map<String, ResultElement> variablesMap = new HashMap<String, ResultElement>();

    public InclVarCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
        super(root, levelsOrder, elemTypeToElemNameColumnsMap);
    }

    @Override
    public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
        ResultElement parent = this.root;
        ProjectInfo projectInfo = r.getProjectInfo();
        int levelIndex = 0;
        while (levelIndex <= this.levelsOrder.size()) {
            if (levelIndex < this.levelsOrder.size()) {
                ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                if (!name.isEmpty()) {
                    String key = name;
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        String projectName = projectInfo.getName();
                        Integer prgID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        key = Utils.getKeyForVariable(key, Utils.getKeyForVariable(projectName, prgID));
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    } else if (levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                        Map children = parent.getChildren();
                        for (String ckey : children.keySet()) {
                            ResultElement re = (ResultElement)((Object)children.get(ckey));
                            Integer stmtOccur = (Integer)re.getProperty("STMT_OCCUR_ID_KEY");
                            if (stmtOccur == null || !stmtOccur.equals(r.getColumnValue(DatabaseMetadata.STMT_OCCUR_ID.getName()))) continue;
                            parent = re;
                            break;
                        }
                    } else if (levelElementType.equals((Object)ResultElementType.ASSEMBLER_CSECT) || levelElementType.equals((Object)ResultElementType.ASSEMBLER_ENTRY)) {
                        parent = Utils.getCategory(levelElementType, parent, null);
                    }
                    ResultElement resultElement = null;
                    if (levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                        resultElement = this.processVariable(this.variablesMap, r, parent, name, projectInfo);
                    } else {
                        resultElement = parent.getChild(key);
                        if (resultElement == null) {
                            this.L.error("result element not found for {} with parent {}", (Object)key, (Object)parent);
                        }
                    }
                    parent = resultElement;
                }
            }
            ++levelIndex;
        }
        return true;
    }

    protected ResultElement processVariable(Map<String, ResultElement> variablesMap, Row r, ResultElement parent, String name, ProjectInfo projectInfo) {
        Integer varID;
        String projectName = projectInfo.getName();
        String varKey = Utils.getKeyForVariable(projectName, varID = (Integer)r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
        ResultElement resultElement = variablesMap.get(varKey);
        if (resultElement == null) {
            Integer varLevel = (Integer)r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName());
            Integer headFather = (Integer)r.getColumnValue(DatabaseMetadata.VAR_Father.getName());
            ResultElement varParent = variablesMap.get(Utils.getKeyForVariable(projectName, headFather));
            if (varParent != null && headFather != 0) {
                parent = varParent;
            }
            resultElement = new ResultElement(name, ResultElementType.VARIABLE, parent);
            variablesMap.put(varKey, resultElement);
            resultElement.addProperty(DatabaseMetadata.VAR_iLevel.getName(), varLevel);
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), varID);
            String key = varID.toString().concat(name);
            parent.addChild(key, resultElement);
            this.addElementInfo(resultElement, r);
            Utils.completeProjectInfo(resultElement, projectInfo);
        }
        return resultElement;
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
        String varPath = (String)r.getColumnValue(DatabaseMetadata.VAR_PATH_STR.getName());
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName());
        Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_COL.getName());
        Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_ROW.getName());
        Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.VAR_END_COL.getName());
        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
        resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
        resultElement.addProperty("Program Type Id", programTypeId);
        String prgName = (String)r.getColumnValue(DatabaseMetadata.PRG_NAME.getName());
        resultElement.addProperty("Program name", prgName);
        Integer varIsCopy = (Integer)r.getColumnValue(DatabaseMetadata.VAR_IS_COPY.getName());
        resultElement.addProperty("VarIsInclude", varIsCopy != 0);
        resultElement.addProperty(DatabaseMetadata.PRG_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_IsField.getName(), r.getColumnValue(DatabaseMetadata.VAR_IsField.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_IsFiller.getName(), r.getColumnValue(DatabaseMetadata.VAR_IsFiller.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_PIC.getName(), r.getColumnValue(DatabaseMetadata.VAR_PIC.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_START_ROW.getName(), r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_ANCESTOR.getName(), r.getColumnValue(DatabaseMetadata.VAR_ANCESTOR.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_PRG_REF_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_PRG_REF_ID.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.VAR_TYPE_ID.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_Father.getName(), r.getColumnValue(DatabaseMetadata.VAR_Father.getName()));
        resultElement.addProperty(DatabaseMetadata.VAR_IS_COPY.getName(), varIsCopy);
        VariableUsageNode prgNodeQueue = new VariableUsageNode(resultElement.getName(), r.getColumnValue(DatabaseMetadata.VAR_PIC.getName()), r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName()), r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName()), r.getColumnValue(DatabaseMetadata.VAR_Ancestor_Name.getName()), r.getColumnValue(DatabaseMetadata.VAR_Father_Name.getName()), r.getColumnValue(DatabaseMetadata.VAR_IsFiller.getName()));
        resultElement.addProperty("Node_Mainframe", prgNodeQueue);
        if (r.hasColumn(DatabaseMetadata.VAR_VISIBILITY.getName())) {
            Integer globalVal = (Integer)r.getColumnValue(DatabaseMetadata.VAR_VISIBILITY.getName());
            boolean isGlobal = globalVal != null && globalVal == 1;
            prgNodeQueue.setGlobal(isGlobal);
        }
        Utils.setFileAttribute(resultElement, String.valueOf(programTypeId), varPath, startRow, startCol, endRow, endCol);
    }
}

