/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.structure;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.IMSDBUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IMSDBStructureTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public IMSDBStructureTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        Map<Integer, ResultElement> segmentsMap;

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.segmentsMap = new HashMap<Integer, ResultElement>();
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (!name.isEmpty()) {
                        ResultElementType currentElemType = levelElementType;
                        if (levelElementType.equals((Object)ResultElementType.IMSDB_DATABASE)) {
                            Integer type = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
                            levelElementType = IMSDBUtils.getIMSDBType(type);
                            parent = Utils.getCategory(levelElementType, parent, null);
                        }
                        ResultElement resultElement = null;
                        if (levelElementType.equals((Object)ResultElementType.IMSDB_SEGMENT)) {
                            Integer sgParentrID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_PARRENT_ID.getName());
                            Integer sgID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
                            if (sgParentrID == null) {
                                resultElement = this.getOrCretateChild(r, parent, projectInfo, levelElementType, name);
                            } else {
                                ResultElement parentElem = this.segmentsMap.get(sgParentrID) != null ? this.segmentsMap.get(sgParentrID) : parent;
                                resultElement = this.getOrCretateChild(r, parentElem, projectInfo, levelElementType, name);
                            }
                            this.segmentsMap.put(sgID, resultElement);
                        } else {
                            resultElement = this.getOrCretateChild(r, parent, projectInfo, levelElementType, name);
                        }
                        IMSDBStructureTreeProvider.this.checkLimitReached(currentElemType, this.root, parent);
                        parent = resultElement;
                    }
                }
                ++levelIndex;
            }
            return true;
        }

        private ResultElement getOrCretateChild(Row r, ResultElement parent, ProjectInfo projectInfo, ResultElementType levelElementType, String name) {
            ResultElement resultElement = parent.getChild(name);
            if (resultElement == null) {
                resultElement = new ResultElement(name, levelElementType, parent);
                this.addElementInfo(resultElement, r);
                Utils.completeProjectInfo(resultElement, projectInfo);
                parent.addChild(name, resultElement);
            }
            return resultElement;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case IMSDB_FULL_FUNCTION: 
                case IMSDB_FAST_PATH: 
                case IMSDB_FILE_ACCESS: 
                case IMSDB_LOGICAL: {
                    Integer dbID = (Integer)r.getColumnValue(DatabaseMetadata.IMS_DB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_ID.getName(), dbID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    Integer type = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName(), type);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_SEGMENT: {
                    Integer segID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEGMENT_ID.getName(), segID);
                    String dbdName = (String)r.getColumnValue(DatabaseMetadata.IMS_DB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_NAME.getName(), dbdName);
                    Integer sourceSegID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName(), sourceSegID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_SEG_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName());
                    if (!pPath.isEmpty() && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_FIELD: {
                    Integer fieldID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_FIELD_ID.getName(), fieldID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String dbdName = (String)r.getColumnValue(DatabaseMetadata.IMS_DB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_NAME.getName(), dbdName);
                    String segName = (String)r.getColumnValue(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName(), segName);
                    Integer sourceSegID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
                    if (sourceSegID != null && sourceSegID > 0) {
                        resultElement.addProperty("IS_LOGICAL_CONTEXT", Boolean.TRUE);
                    }
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty(DatabaseMetadata.IMSDB_FIELD_SEQ.getName(), r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_SEQ.getName()));
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

