/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.structure;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IMSDBStructureFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;
    private static final String MATCHING_ALL_FILTERS_BELOW = Messages.getString(IMSDBStructureFilter.class, "matchingAllFilters.label");

    public IMSDBStructureFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.addFilterEntries(defaultPatterns);
    }

    private void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "IMSDBStructureIMSDBLimit", 0);
        this.entries = new ArrayList();
        if (defaultPatterns != null) {
            this.resolveLogicalElemAsFilterInput(defaultPatterns);
        }
        FilterEntry e = this.makeFilterEntry(ResultElementType.IMSDB_DATABASE, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Imsdb");
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        e.setValidator(3, limitValidator);
        this.addColumnsForIMSDB(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.IMSDB_SEGMENT, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@ImsdbSegment");
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IMSDBStructureSegmentLimit", 0);
        e.setValidator(3, limitValidator);
        this.addColumnsForSegments(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.IMSDB_FIELD, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@ImsdbField");
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IMSDBStructureFieldLimit", 0);
        e.setValidator(3, limitValidator);
        this.addColumnsForField(e);
        this.entries.add(e);
    }

    private void resolveLogicalElemAsFilterInput(Map<ResultElementType, StringBuilder> defaultPatterns) {
        HashMap<ResultElementType, ResultElementType> inputKeyTypes = new HashMap<ResultElementType, ResultElementType>();
        inputKeyTypes.put(ResultElementType.IMSDB_LOGICAL, ResultElementType.IMSDB_DATABASE);
        inputKeyTypes.put(ResultElementType.IMSDB_LOGICAL_SEGMENT, ResultElementType.IMSDB_SEGMENT);
        for (ResultElementType logicalKey : inputKeyTypes.keySet()) {
            StringBuilder value = defaultPatterns.get(logicalKey);
            if (value == null) continue;
            defaultPatterns.remove(logicalKey);
            ResultElementType inputType = (ResultElementType)inputKeyTypes.get(logicalKey);
            StringBuilder sb = defaultPatterns.get(inputType);
            if (sb == null) {
                sb = value;
            } else {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(value.toString());
            }
            defaultPatterns.put(inputType, sb);
        }
    }

    private void addColumnsForIMSDB(FilterEntry e) {
        e.put(DatabaseMetadata.IMS_DB_ID.getName(), DatabaseMetadata.IMS_DB_ID.getName());
        e.put(DatabaseMetadata.IMS_DB_NAME.getName(), DatabaseMetadata.IMS_DB_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName(), DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_STMT_END_COL.getName());
        e.put(DatabaseMetadata.IMSDB_PATH.getName(), DatabaseMetadata.IMSDB_PATH.getName());
    }

    private void addColumnsForSegments(FilterEntry e) {
        e.put(DatabaseMetadata.IMSDB_SEGMENT_ID.getName(), DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
        e.put(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName(), DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_PARRENT_ID.getName(), DatabaseMetadata.IMSDB_SEG_PARRENT_ID.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_PATH.getName(), DatabaseMetadata.IMSDB_SEG_PATH.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName(), DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
    }

    private void addColumnsForField(FilterEntry e) {
        e.put(DatabaseMetadata.IMSDB_FIELD_ID.getName(), DatabaseMetadata.IMSDB_FIELD_ID.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_NAME.getName(), DatabaseMetadata.IMSDB_FIELD_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_PATH.getName(), DatabaseMetadata.IMSDB_FIELD_PATH.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_SEQ.getName(), DatabaseMetadata.IMSDB_FIELD_SEQ.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName(), DatabaseMetadata.IMSDB_SEG_SOURCE_ID.getName());
    }
}

