/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.structure;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.imsdb.structure.IMSDBStructureAnalysis;
import com.ez.analysis.mainframe.usage.imsdb.structure.IMSDBStructureFilter;
import com.ez.analysis.mainframe.usage.imsdb.structure.IMSDBStructureTreeProvider;
import com.ez.analysis.mainframe.usage.imsdb.structure.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSDBStructureDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IMSDBStructureDescriptor.class);
    private static final String IMSDB_COLUMN = DatabaseMetadata.IMS_DB_NAME.getName();
    private static final String IMSDB_SEGMENT_COLUMN = DatabaseMetadata.IMSDB_SEGMENT_NAME.getName();
    private static final String IMSDB_FIELD_COLUMN = DatabaseMetadata.IMSDB_FIELD_NAME.getName();
    protected static final String IMSDB_PARAMETER_NAME = "@Imsdb";
    protected static final String IMSDB_SEGMENT_PARAMETER_NAME = "@ImsdbSegment";
    protected static final String IMSDB_FIELD_PARAMETER_NAME = "@ImsdbField";
    public static final String MAINFRAME_IMSDB_STRUCTURE = "com.ez.analysis.mainframe.imsdb.structure";
    private static final String IMSDB_USAGE_FILTERS_FILE_NAME = "IMSDBStructureFilters.properties";
    public static final Map<String, List<ColumnInfo>> IMSDB_STRUCTURE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_DATABASE.name(), list);
            list.add(DatabaseMetadata.IMS_DB_ID);
            list.add(DatabaseMetadata.IMS_DB_NAME);
            list.add(DatabaseMetadata.IMSDB_ACCESS_TYPE);
            list.add(DatabaseMetadata.IMSDB_STMT_START_ROW);
            list.add(DatabaseMetadata.IMSDB_STMT_START_COL);
            list.add(DatabaseMetadata.IMSDB_STMT_END_ROW);
            list.add(DatabaseMetadata.IMSDB_STMT_END_COL);
            list.add(DatabaseMetadata.IMSDB_PATH);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_SEGMENT.name(), list);
            list.add(DatabaseMetadata.IMSDB_SEGMENT_ID);
            list.add(DatabaseMetadata.IMSDB_SEGMENT_NAME);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_START_COL);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_END_COL);
            list.add(DatabaseMetadata.IMSDB_SEG_PATH);
            list.add(DatabaseMetadata.IMSDB_SEG_SOURCE_ID);
            list.add(DatabaseMetadata.IMSDB_SEG_PARRENT_ID);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_FIELD.name(), list);
            list.add(DatabaseMetadata.IMSDB_FIELD_ID);
            list.add(DatabaseMetadata.IMSDB_FIELD_NAME);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL);
            list.add(DatabaseMetadata.IMSDB_FIELD_PATH);
            list.add(DatabaseMetadata.IMSDB_FIELD_SEQ);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public IMSDBStructureDescriptor(IMSDBStructureAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_IMSDB_STRUCTURE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IMSDBStructureTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IMSDBStructureFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.IMSDB_STRUCTURE_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_IMSDB_Structure";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            L.debug("adding filter parameters");
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.IMSDB_DATABASE.name(), " @ImsdbLimit INT, @Imsdb VARCHAR(64)");
            spParam.put(ResultElementType.IMSDB_SEGMENT.name(), " @SegmentLimit INT, @ImsdbSegment VARCHAR(64)");
            spParam.put(ResultElementType.IMSDB_FIELD.name(), " @FieldLimit INT, @ImsdbField VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            String imsdbClause = " (@Imsdb= ''%'' or UPPER(" + IMSDB_COLUMN + ") " + IMSDB_DATABASE_LIKE_OR_IN_MARKER + ")";
            spWhereClause.put(ResultElementType.IMSDB_DATABASE.name(), imsdbClause);
            spWhereClause.put(ResultElementType.IMSDB_SEGMENT.name(), " (@ImsdbSegment = ''%'' or UPPER(" + IMSDB_SEGMENT_COLUMN + ") " + IMSDB_SEGMENT_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.IMSDB_FIELD.name(), " (@ImsdbField = ''%'' or UPPER(" + IMSDB_FIELD_COLUMN + ") " + IMSDB_FIELD_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.IMSDB_DATABASE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(IMSDB_COLUMN).limitParamName(" @ImsdbLimit ").create());
                this.put(ResultElementType.IMSDB_SEGMENT.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IMSDB_SEG_PARRENT_ID.getName()).orderByExpr("COALESCE(" + DatabaseMetadata.IMSDB_SEG_PARRENT_ID.getName() + ",-1)").limitParamName(" @SegmentLimit ").create());
                this.put(ResultElementType.IMSDB_FIELD.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(IMSDB_FIELD_COLUMN).limitParamName(" @FieldLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return IMSDB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_DATABASE, IMSDB_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_SEGMENT, IMSDB_SEGMENT_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_FIELD, IMSDB_FIELD_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return IMSDB_STRUCTURE_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "IMSDB_Structure";
    }

    @Override
    public boolean hasReorderResultsAction() {
        return false;
    }
}

