/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.physical;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.imsdb.common.IMSDBBasicUsageDescriptor;
import com.ez.analysis.mainframe.usage.imsdb.physical.IMSDBPhysicalUsageFilter;
import com.ez.analysis.mainframe.usage.imsdb.physical.IMSDBPhysicalUsageTreeProvider;
import com.ez.analysis.mainframe.usage.imsdb.physical.State;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.List;
import java.util.Map;

public class IMSDBPhysicalUsageDescriptor
extends IMSDBBasicUsageDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String IMSDB_PHISICAL_USAGE = "com.ez.analysis.mainframe.usage.imsdb.physical";
    private static final String IMSDB_USAGE_FILTERS_FILE_NAME = "IMSDBPhysicalUsageFilters.properties";

    public IMSDBPhysicalUsageDescriptor(AbstractAnalysis analysis) {
        super(analysis);
    }

    public String getId() {
        return IMSDB_PHISICAL_USAGE;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_IMSDB_Physical";
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IMSDBPhysicalUsageTreeProvider(this);
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IMSDBPhysicalUsageFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.IMSDB_PHYSICAL_HEADER_INFO;
    }

    @Override
    public String getFileName() {
        return IMSDB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        boolean mustAddWhereClause = this.storedProcedureWhereClause == null;
        this.storedProcedureWhereClause = super.getStoredProcedureWhereClause();
        if (mustAddWhereClause) {
            String imsdbClause = " (@Imsdb= ''%'' or UPPER(" + DatabaseMetadata.IMS_DB_NAME.getName() + ") " + IMSDB_DATABASE_LIKE_OR_IN_MARKER + ")";
            this.storedProcedureWhereClause.put(ResultElementType.IMSDB_DATABASE.name(), imsdbClause);
            this.storedProcedureWhereClause.put(ResultElementType.IMSDB_SEGMENT.name(), " (@ImsdbSegment = ''%'' or UPPER(" + DatabaseMetadata.IMSDB_SEGMENT_NAME.getName() + ") " + IMSDB_SEGMENT_LIKE_OR_IN_MARKER + ")");
        }
        return this.storedProcedureWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        boolean mustAddParams = this.storedProcedureParameters == null;
        this.storedProcedureParameters = super.getStoredProcedureParam();
        if (mustAddParams) {
            this.storedProcedureParameters.put(ResultElementType.IMSDB_DATABASE.name(), " @ImsdbLimit INT, @Imsdb VARCHAR(64)");
            this.storedProcedureParameters.put(ResultElementType.IMSDB_SEGMENT.name(), " @SegmentLimit INT, @ImsdbSegment VARCHAR(64)");
        }
        return this.storedProcedureParameters;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        super.initElemTypeToElemNameColumnsMap();
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_DATABASE, DatabaseMetadata.IMS_DB_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_SEGMENT, DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        Map<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStmts = super.getStoredProcedureDenseRankStatements();
        spDenseRankStmts.put(ResultElementType.IMSDB_DATABASE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IMS_DB_NAME.getName()).limitParamName(" @ImsdbLimit ").create());
        spDenseRankStmts.put(ResultElementType.IMSDB_SEGMENT.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName()).limitParamName(" @SegmentLimit ").create());
        return spDenseRankStmts;
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        List list = (List)IMSDB_USAGE_CSV_HEADER.get(ResultElementType.IMSDB_SEGMENT.name());
        list.add(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_NAME);
        list.add(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_DB_NAME);
        IMSDB_USAGE_CSV_HEADER.put(ResultElementType.IMSDB_SEGMENT.name(), list);
        return IMSDB_USAGE_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "IMSDB_Usage";
    }
}

