/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.physical;

import com.ez.analysis.mainframe.usage.UsageAnalysisFilter;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDBField;
import com.ez.internal.analysis.config.inputs.EZSourceIMSDBSegment;
import com.ez.mainframe.data.utils.IMSDBAccessType;
import java.util.Collection;

public class IMSDBPhysicalUsageAnalysisFilter
extends UsageAnalysisFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    protected boolean isAcceptedInput(Object inpObj, Collection<Object> inputs) {
        Boolean isLogical;
        boolean isAccepted = true;
        Integer accessType = (Integer)((EZObjectType)inpObj).getProperty("IMSDB_DATABASE_TYPE");
        if (accessType != null && accessType == IMSDBAccessType.LOGICAL.ordinal() + 1) {
            isAccepted = false;
        }
        if (inpObj instanceof EZSourceIMSDBSegment && (isLogical = (Boolean)((EZObjectType)inpObj).getProperty("LOGICAL_SEGMENT_TYPE")) != null && isLogical.booleanValue()) {
            isAccepted = false;
        }
        if (inpObj instanceof EZSourceIMSDBField && (isLogical = (Boolean)((EZObjectType)inpObj).getProperty("IS_LOGICAL_CONTEXT")) != null && isLogical.booleanValue()) {
            isAccepted = false;
        }
        return isAccepted || this.isPrgInProject(inpObj, inputs);
    }
}

