/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.logical;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.IMSDBUtils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.IMSDBAccessType;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IMSDBLogicalUsageTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public IMSDBLogicalUsageTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement parent, RecordsetProvider rs, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        if (levelsOrder.contains(ResultElementType.IMSDB_LOGICAL_SEGMENT)) {
            elemTypeToElemNameColumnsMap.put(ResultElementType.IMSDB_DATABASE, DatabaseMetadata.IMS_DB_NAME.getName());
            elemTypeToElemNameColumnsMap.put(ResultElementType.IMSDB_SEGMENT, DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
        }
        IMSDBLogicalUsageProcessRowCallback callback = new IMSDBLogicalUsageProcessRowCallback(parent, levelsOrder, elemTypeToElemNameColumnsMap);
        rs.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    @Override
    protected List<ResultElementType> getLevelsOrder() {
        List<ResultElementType> levelsOrder = super.getLevelsOrder();
        ArrayList<ResultElementType> levelsOrderWithPhysicalIMSDB = new ArrayList<ResultElementType>();
        if (levelsOrder.contains(ResultElementType.IMSDB_LOGICAL_SEGMENT) && !levelsOrder.contains(ResultElementType.IMSDB_DATABASE)) {
            for (ResultElementType level : levelsOrder) {
                levelsOrderWithPhysicalIMSDB.add(level);
                if (!level.equals((Object)ResultElementType.IMSDB_LOGICAL_SEGMENT)) continue;
                levelsOrderWithPhysicalIMSDB.add(ResultElementType.IMSDB_DATABASE);
                levelsOrderWithPhysicalIMSDB.add(ResultElementType.IMSDB_SEGMENT);
            }
            return levelsOrderWithPhysicalIMSDB;
        }
        return levelsOrder;
    }

    class IMSDBLogicalUsageProcessRowCallback
    extends AbstractProcessRowCallback {
        public IMSDBLogicalUsageProcessRowCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex < this.levelsOrder.size()) {
                ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                if (levelElementType.equals((Object)ResultElementType.IMSDB_DATABASE)) {
                    Integer type = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
                    levelElementType = IMSDBUtils.getIMSDBType(type);
                }
                if (!name.isEmpty()) {
                    ResultElement resultElement;
                    ResultElementType currentElemType = levelElementType;
                    if (levelElementType.name().equals(ResultElementType.STMT_SOURCE_INFO.name())) {
                        ResultElement tempResultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(tempResultElement, r);
                        name = tempResultElement.getDisplayName();
                    }
                    if ((resultElement = parent.getChild(name)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(name, resultElement);
                    }
                    IMSDBLogicalUsageTreeProvider.this.checkLimitReached(currentElemType, this.root, parent);
                    parent = resultElement;
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case IMSDB_LOGICAL: {
                    Integer dbID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_DB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_ID.getName(), dbID);
                    resultElement.addProperty(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName(), IMSDBAccessType.LOGICAL.ordinal() + 1);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_END_COL.getName());
                    if (!pPath.isEmpty() && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_FULL_FUNCTION: 
                case IMSDB_FAST_PATH: 
                case IMSDB_FILE_ACCESS: 
                case IMSDB_NOT_AVAILABLE: {
                    Integer dbID = (Integer)r.getColumnValue(DatabaseMetadata.IMS_DB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_ID.getName(), dbID);
                    Integer type = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName(), type);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_STMT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_SEGMENT: {
                    Integer segID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEGMENT_ID.getName(), segID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String dbdName = (String)r.getColumnValue(DatabaseMetadata.IMS_DB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_NAME.getName(), dbdName);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_LOGICAL_SEGMENT: {
                    Integer segID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEGMENT_ID.getName(), segID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String dbdName = (String)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_DB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_NAME.getName(), dbdName);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_DB_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case IMSDB_SEARCH_FIELD: {
                    Integer fieldID = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_FIELD_ID.getName(), fieldID);
                    resultElement.addProperty("element of IMS/DB", Boolean.TRUE);
                    String dbdName = (String)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_DB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMS_DB_NAME.getName(), dbdName);
                    String segName = (String)r.getColumnValue(DatabaseMetadata.IMSDB_LOGICAL_SEGMENT_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName(), segName);
                    resultElement.addProperty("IS_LOGICAL_CONTEXT", Boolean.TRUE);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName());
                    if (pPath != null && eStartRow != null && eStartCol != null && eEndRow != null && eEndCol != null) {
                        Utils.setFileAttribute(resultElement, null, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    }
                    resultElement.addProperty(DatabaseMetadata.IMSDB_FIELD_SEQ.getName(), r.getColumnValue(DatabaseMetadata.IMSDB_FIELD_SEQ.getName()));
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case PROGRAM: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                    String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                    ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                    String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                    if (ancestorName != null && !ancestorName.isEmpty()) {
                        resultElement.addProperty("Ancestor Name", ancestorName);
                        Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                        resultElement.addProperty("Ancestor Id", ancestorId);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case STMT_SOURCE_INFO: {
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                    resultElement.addProperty("Stmt Start Row", startRow);
                    String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
                    String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
                    resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                    Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                    Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                    Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

