/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.common;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class IMSDBBasicUsageFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final int DEFAULT_LIMIT_VALUE = 50;
    protected Map<ResultElementType, StringBuilder> defaultPatterns;
    boolean isLogicalUsage;

    public IMSDBBasicUsageFilter(Map<ResultElementType, StringBuilder> defaultPatterns, boolean isLogical) {
        this.defaultPatterns = defaultPatterns;
        this.entries = new ArrayList();
        this.isLogicalUsage = isLogical;
        this.addFilterEntries();
    }

    private void addFilterEntries() {
        this.addDatabaseNameFilter();
        this.addSegmentNameFilter();
        this.addProgramFilter();
        this.addStatementTypeFilter();
        this.addFieldNameFilter();
    }

    private void addDatabaseNameFilter() {
        String limitTypeAsString = this.isLogicalUsage ? "IMSDBLogicalUsageIMSDBDatabaseNameLimit" : "IMSDBPhysicalUsageDatabaseLimit";
        FilterEntry e = this.getFilterEntry(limitTypeAsString, this.isLogicalUsage ? ResultElementType.IMSDB_LOGICAL : ResultElementType.IMSDB_DATABASE, "@Imsdb");
        this.addColumnsForIMSDB(e);
        this.entries.add(e);
    }

    private void addSegmentNameFilter() {
        String limitTypeAsString = this.isLogicalUsage ? "IMSDBLogicalUsageSegmentLimit" : "IMSDBPhysicalUsageSegmentLimit";
        FilterEntry e = this.getFilterEntry(limitTypeAsString, this.isLogicalUsage ? ResultElementType.IMSDB_LOGICAL_SEGMENT : ResultElementType.IMSDB_SEGMENT, "@ImsdbSegment");
        this.addColumnsForSegments(e);
        this.entries.add(e);
    }

    private void addFieldNameFilter() {
        String limitTypeAsString = this.isLogicalUsage ? "IMSDBLogicalUsageFieldLimit" : "IMSDBPhysicalUsageFieldLimit";
        FilterEntry e = this.getFilterEntry(limitTypeAsString, ResultElementType.IMSDB_SEARCH_FIELD, "@ImsdbField");
        if (this.defaultPatterns == null || !this.defaultPatterns.containsKey(ResultElementType.IMSDB_SEARCH_FIELD)) {
            e.put(FilterEntry.ATTR_USE, Boolean.toString(false));
        }
        this.addColumnsForField(e);
        this.entries.add(e);
    }

    private void addProgramFilter() {
        String limitTypeAsString = this.isLogicalUsage ? "IMSDBLogicalUsageProgramLimit" : "IMSDBPhysicalUsageProgramLimit";
        FilterEntry e = this.getFilterEntry(limitTypeAsString, ResultElementType.PROGRAM, "@Program");
        e.put("must search aliases", Boolean.toString(true));
        this.addColumnsForProgram(e);
        this.entries.add(e);
    }

    private void addStatementTypeFilter() {
        String limitTypeAsString = this.isLogicalUsage ? "IMSDBLogicalUsageStmtTypeLimit" : "IMSDBUsageStmtTypeLimit";
        FilterEntry e = this.getFilterEntry(limitTypeAsString, ResultElementType.STMT_TYPE, "@StatementType");
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        this.addColumnsForStatement(e);
        this.entries.add(e);
    }

    private FilterEntry getFilterEntry(String highestLimitKey, ResultElementType resultElementType, String filterParameterKey) {
        return this.getFilterEntry(highestLimitKey, resultElementType, filterParameterKey, null);
    }

    private FilterEntry getFilterEntry(String highestLimitKey, ResultElementType resultElementType, String filterParameterKey, String filterParameterSecondKey) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, highestLimitKey, 0);
        FilterEntry e = this.makeFilterEntry(resultElementType, this.defaultPatterns, 50);
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", filterParameterKey);
        if (filterParameterSecondKey != null) {
            e.put("DynamicProcParamNameSecond", filterParameterSecondKey);
        }
        return e;
    }

    protected void addColumnsForIMSDB(FilterEntry e) {
        e.put(DatabaseMetadata.IMS_DB_ID.getName(), DatabaseMetadata.IMS_DB_ID.getName());
        e.put(DatabaseMetadata.IMS_DB_NAME.getName(), DatabaseMetadata.IMS_DB_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_ACCESS_TYPE.getName(), DatabaseMetadata.IMSDB_ACCESS_TYPE.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_STMT_END_COL.getName());
        e.put(DatabaseMetadata.IMSDB_PATH.getName(), DatabaseMetadata.IMSDB_PATH.getName());
        this.addMandatoryColumns(e);
    }

    protected void addColumnsForSegments(FilterEntry e) {
        e.put(DatabaseMetadata.IMSDB_SEGMENT_ID.getName(), DatabaseMetadata.IMSDB_SEGMENT_ID.getName());
        e.put(DatabaseMetadata.IMSDB_SEGMENT_NAME.getName(), DatabaseMetadata.IMSDB_SEGMENT_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_SEG_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_SEG_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_SEG_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_SEG_STMT_END_COL.getName());
        this.addMandatoryColumns(e);
    }

    protected void addColumnsForStatement(FilterEntry e) {
        this.addMandatoryColumns(e);
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
    }

    private void addColumnsForProgram(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        this.addColumnsForStatement(e);
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName());
    }

    protected void addColumnsForField(FilterEntry e) {
        e.put(DatabaseMetadata.IMSDB_FIELD_ID.getName(), DatabaseMetadata.IMSDB_FIELD_ID.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_NAME.getName(), DatabaseMetadata.IMSDB_FIELD_NAME.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_START_COL.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName(), DatabaseMetadata.IMSDB_FIELD_STMT_END_COL.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_PATH.getName(), DatabaseMetadata.IMSDB_FIELD_PATH.getName());
        e.put(DatabaseMetadata.IMSDB_FIELD_SEQ.getName(), DatabaseMetadata.IMSDB_FIELD_SEQ.getName());
        this.addMandatoryColumns(e);
    }

    @Override
    protected void addMandatoryColumns(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), DatabaseMetadata.STMT_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), DatabaseMetadata.STMT_PATH_STR.getName());
        e.put(DatabaseMetadata.STMT_START_COL.getName(), DatabaseMetadata.STMT_START_COL.getName());
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), DatabaseMetadata.STMT_END_ROW.getName());
        e.put(DatabaseMetadata.STMT_END_COL.getName(), DatabaseMetadata.STMT_END_COL.getName());
    }
}

