/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb.common;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.imsdb.physical.IMSDBPhysicalUsageFilter;
import com.ez.analysis.mainframe.usage.imsdb.physical.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSDBBasicUsageDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String IMSDB_USAGE_FILTERS_FILE_NAME = "IMSDBPhysicalUsageFilters.properties";
    protected Map<String, String> storedProcedureParameters;
    protected Map<String, String> storedProcedureWhereClause;
    private static final Logger L = LoggerFactory.getLogger(IMSDBBasicUsageDescriptor.class);
    public static final Map<String, List<ColumnInfo>> IMSDB_USAGE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_DATABASE.name(), list);
            list.add(DatabaseMetadata.IMS_DB_ID);
            list.add(DatabaseMetadata.IMS_DB_NAME);
            list.add(DatabaseMetadata.IMSDB_PATH);
            list.add(DatabaseMetadata.IMSDB_ACCESS_TYPE);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_SEGMENT.name(), list);
            list.add(DatabaseMetadata.IMSDB_SEGMENT_NAME);
            list.add(DatabaseMetadata.IMSDB_SEG_PATH);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_START_ROW);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_START_COL);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_END_ROW);
            list.add(DatabaseMetadata.IMSDB_SEG_STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB_SEARCH_FIELD.name(), list);
            list.add(DatabaseMetadata.IMSDB_FIELD_ID);
            list.add(DatabaseMetadata.IMSDB_FIELD_NAME);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_START_ROW);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_START_COL);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_END_ROW);
            list.add(DatabaseMetadata.IMSDB_FIELD_STMT_END_COL);
            list.add(DatabaseMetadata.IMSDB_FIELD_PATH);
            list.add(DatabaseMetadata.IMSDB_FIELD_SEQ);
        }
    };

    public IMSDBBasicUsageDescriptor(AbstractAnalysis analysis) {
        super(analysis.getType());
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_DESC.getName()).limitParamName(" @StatementLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PRG_NAME.getName()).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.IMSDB_SEARCH_FIELD.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IMSDB_FIELD_NAME.getName()).limitParamName(" @FieldLimit ").create());
            }
        };
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB_SEARCH_FIELD, DatabaseMetadata.IMSDB_FIELD_NAME.getName());
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IMSDBPhysicalUsageFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.storedProcedureWhereClause == null) {
            this.storedProcedureWhereClause = new HashMap<String, String>();
            this.storedProcedureWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER(" + DatabaseMetadata.STMT_DESC.getName() + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
            this.storedProcedureWhereClause.put(ResultElementType.PROGRAM.name(), " (@Program = ''%'' or UPPER(" + DatabaseMetadata.PRG_NAME.getName() + ") " + PROGRAM_LIKE_OR_IN_MARKER + ")");
            this.storedProcedureWhereClause.put(ResultElementType.IMSDB_SEARCH_FIELD.name(), " (@ImsdbField = ''%'' or UPPER(" + DatabaseMetadata.IMSDB_FIELD_NAME.getName() + ") " + IMSDB_SEARCH_FIELD_LIKE_OR_IN_MARKER + ")");
        }
        L.debug("storedProcedureWhereClause = " + this.storedProcedureWhereClause);
        return this.storedProcedureWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.storedProcedureParameters == null) {
            this.storedProcedureParameters = new HashMap<String, String>();
            this.storedProcedureParameters.put(ResultElementType.IMSDB_SEARCH_FIELD.name(), " @FieldLimit INT, @ImsdbField VARCHAR(64) ");
            this.storedProcedureParameters.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255) ");
            this.storedProcedureParameters.put(ResultElementType.STMT_TYPE.name(), " @StatementLimit INT, @StatementType VARCHAR(64) ");
        }
        L.debug("storedProcedureParameters = " + this.storedProcedureParameters);
        return this.storedProcedureParameters;
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return IMSDB_USAGE_CSV_HEADER;
    }

    @Override
    public String getFileName() {
        return IMSDB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initTreeProvider() {
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return null;
    }

    @Override
    protected void addLevelNotInFilter(List<ResultElementType> list) {
        list.add(ResultElementType.STMT_SOURCE_INFO);
    }
}

