/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.imsdb;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.IMSDBFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.imsdb.IMSDBFilter;
import com.ez.analysis.mainframe.usage.imsdb.IMSDBTreeProvider;
import com.ez.analysis.mainframe.usage.imsdb.IMSDBUsageAnalysis;
import com.ez.analysis.mainframe.usage.imsdb.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.IMSDBQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IMSDBDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IMSDBDescriptor.class);
    private static final String IMSDB_COLUMN = DatabaseMetadata.IMSDB_NAME.getName();
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_DESC_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    public static final String IMSDB_PARAMETER_NAME = "@Imsdb";
    public static final String MAINFRAME_IMSDB_USAGE = "com.ez.analysis.mainframe.usage.imsdb";
    private static final String IMSDB_USAGE_FILTERS_FILE_NAME = "IMSDBUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> IMSDB_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.IMSDB.name(), list);
            list.add(DatabaseMetadata.IMSDB_ID);
            list.add(DatabaseMetadata.IMSDB_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public IMSDBDescriptor(IMSDBUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_IMSDB_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IMSDBTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IMSDBFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.IMSDB_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_IMSDB";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.IMSDB.name(), " @ImsdbLimit INT, @Imsdb VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementDescLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            String imsdbClause = " (@Imsdb = ''%'' or " + IMSDB_COLUMN + " " + IMSDB_LIKE_OR_IN_MARKER + ")";
            spWhereClause.put(ResultElementType.IMSDB.name(), imsdbClause);
            spWhereClause.put(ResultElementType.PROGRAM.name(), " (( @Program = ''%'' or " + PROGRAM_COLUMN + " " + PROGRAM_LIKE_OR_IN_MARKER + ")" + " AND (" + "@Ancestor" + " = ''%'' or " + ANCESTOR_NAME_COLUMN + " " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or " + STATEMENT_DESC_COLUMN + " like @StatementType)");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.IMSDB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(IMSDB_COLUMN).limitParamName(" @ImsdbLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_DESC_COLUMN).limitParamName(" @StatementDescLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return IMSDB_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.IMSDB, IMSDB_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_DESC_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new IMSDBQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return IMSDB_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "IMSDB";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.IMSDB.name(), new IMSDBFilterEntryParameterGenerator());
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

