/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.idmsx;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IDMSXTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected List<ResultElementType> elementTypes = null;

    public IDMSXTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case PROGRAM: {
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                if (programTypeId != 14) {
                    String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                    String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                    ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                }
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case IDMSX_SCHEMA: {
                resultElement.addProperty(DatabaseMetadata.IDMS_SCHEMA_NAME.getName(), resultElement.getName());
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), 6);
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), r.getColumnValue(DatabaseMetadata.IDMS_SCHEMA_ID.getName()));
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), resultElement.getName());
                GenericProgramRelatedNode prgNodeSchema = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.IDMSX_SCHEMA.getDisplayName());
                resultElement.addProperty("Node_Mainframe", prgNodeSchema);
                break;
            }
            case IDMSX_SUBSCHEMA: {
                resultElement.addProperty(DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName(), resultElement.getName());
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), 9);
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), r.getColumnValue(DatabaseMetadata.IDMS_SUBSCHEMA_ID.getName()));
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), resultElement.getName());
                GenericProgramRelatedNode prgNodeSubschema = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.IDMSX_SUBSCHEMA.getDisplayName());
                resultElement.addProperty("Node_Mainframe", prgNodeSubschema);
                break;
            }
            case DDCL_ELEMENT: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                Integer categoryNr = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_CATEGORY.getName());
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), categoryNr);
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), r.getColumnValue(DatabaseMetadata.DDCL_ELEM_ID.getName()));
                resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), resultElement.getName());
                Integer elemStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                Integer elemStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                Integer elemEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                Integer elemEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                String elemPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                Utils.setFileAttribute(resultElement, programTypeId.toString(), elemPath, elemStartRow, elemStartCol, elemEndRow, elemEndCol);
                GenericProgramRelatedNode prgNodeDDCL = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DDCL_ELEMENT.getDisplayName());
                resultElement.addProperty("Node_Mainframe", prgNodeDDCL);
                break;
            }
            case IDMS_SET: 
            case IDMS_RECORD: {
                int type = (Integer)r.getColumnValue(DatabaseMetadata.RESOURCE_TYPE.getName());
                Integer idmsTypeId = null;
                if (type == 77) {
                    idmsTypeId = 3;
                } else if (type == 78) {
                    idmsTypeId = 10;
                } else if (type == 3 || type == 75) {
                    idmsTypeId = 3;
                } else if (type == 10 || type == 76) {
                    idmsTypeId = 10;
                }
                resultElement.addProperty(DatabaseMetadata.SET_OR_RECORD_IN_DDCL_ID.getName(), r.getColumnValue(DatabaseMetadata.SET_OR_RECORD_IN_DDCL_ID.getName()));
                if (idmsTypeId != null) {
                    resultElement.addProperty("Resource Type", idmsTypeId);
                }
                Integer recOrSetStartRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_START_ROW.getName());
                Integer recOrSetStartCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_START_COL.getName());
                if (recOrSetStartRow != null && recOrSetStartCol != null) {
                    String ddclPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_PATH.getName()));
                    Integer recOrSetEndRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_END_ROW.getName());
                    Integer recOrSetEndCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, String.valueOf(14), ddclPath, recOrSetStartRow, recOrSetStartCol, recOrSetEndRow, recOrSetEndCol);
                }
                String category = resultElement.getType().equals((Object)ResultElementType.IDMS_SET) ? ResultElementType.IDMS_SET.getDisplayName() : ResultElementType.IDMS_RECORD.getDisplayName();
                GenericProgramRelatedNode prgNode = new GenericProgramRelatedNode(resultElement.getName(), category);
                resultElement.addProperty("Node_Mainframe", prgNode);
                break;
            }
            case STMT_SOURCE_INFO: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
                String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_TYPE_NAME.getName());
                resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                resultElement.addProperty("Stmt Start Row", startRow);
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
            }
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                block13: {
                    block11: {
                        String key;
                        String name;
                        ResultElementType levelElementType;
                        block14: {
                            block15: {
                                ResultElement categoryResultElement;
                                block12: {
                                    Integer progrTypeID;
                                    if (levelIndex >= this.levelsOrder.size()) break block11;
                                    levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                                    categoryResultElement = null;
                                    key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                                    if (!levelElementType.equals((Object)ResultElementType.PROGRAM)) break block12;
                                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                                    if (id != null) {
                                        key = id.toString().concat(name);
                                    }
                                    if ((progrTypeID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName())) == 14) break block13;
                                    parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                                    break block14;
                                }
                                if (!levelElementType.equals((Object)ResultElementType.IDMS_SET) && !levelElementType.equals((Object)ResultElementType.IDMS_RECORD)) break block15;
                                Integer setOrRecordTypeId = (Integer)r.getColumnValue(DatabaseMetadata.RESOURCE_TYPE.getName());
                                if (setOrRecordTypeId == 77 || setOrRecordTypeId == 3) {
                                    levelElementType = ResultElementType.IDMS_RECORD;
                                } else if (setOrRecordTypeId == 78 || setOrRecordTypeId == 10) {
                                    levelElementType = ResultElementType.IDMS_SET;
                                }
                                parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
                                while (levelIndex < this.levelsOrder.size() - 1 && (((ResultElementType)this.levelsOrder.get(levelIndex + 1)).equals((Object)ResultElementType.IDMS_SET) || ((ResultElementType)this.levelsOrder.get(levelIndex + 1)).equals((Object)ResultElementType.IDMS_RECORD))) {
                                    ++levelIndex;
                                }
                                break block14;
                            }
                            if (!levelElementType.equals((Object)ResultElementType.DDCL_ELEMENT)) break block14;
                            Integer progrTypeID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                            if (progrTypeID != 14) break block13;
                            Integer elemType = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_CATEGORY.getName());
                            if (elemType != null) {
                                String elemTypeName = com.ez.mainframe.data.utils.Utils.getExternalizedType4DDCLComponent((Integer)elemType);
                                parent = Utils.getCategory(levelElementType, parent, elemTypeName);
                            }
                        }
                        ResultElement resultElement = parent.getChild(key);
                        if (resultElement == null) {
                            resultElement = new ResultElement(name, levelElementType, parent);
                            IDMSXTreeProvider.this.addElementInfo(resultElement, r);
                            Utils.completeProjectInfo(resultElement, projectInfo);
                            parent.addChild(key, resultElement);
                        }
                        IDMSXTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                        break block13;
                    }
                    if (levelIndex == this.levelsOrder.size()) {
                        String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.PROGRAM);
                        String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                        ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        IDMSXTreeProvider.this.addElementInfo(resultElement, r);
                        parent.addChild(resultElement.getDisplayName(), resultElement);
                    }
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

