/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.idmsx;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.idmsx.IDMSXFilter;
import com.ez.analysis.mainframe.usage.idmsx.IDMSXTreeProvider;
import com.ez.analysis.mainframe.usage.idmsx.IDMSXUsageAnalysis;
import com.ez.analysis.mainframe.usage.idmsx.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZDDCLSchema;
import com.ez.internal.analysis.config.inputs.EZDDCLSubschema;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSRecord;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSSet;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IDMSXDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String SCHEMA_PARAM = "@Schema";
    private static final String SCHEMA_PARAM_LIMIT = "@SchemaLimit";
    private static final String SCHEMA_COLUMN = DatabaseMetadata.IDMS_SCHEMA_NAME.getName();
    private static final String SCHEMA_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IDMSX_SCHEMA, new String[0]);
    public static final String SUBSCHEMA_PARAM = "@Subschema";
    private static final String SUBSCHEMA_PARAM_LIMIT = "@SubschemaLimit";
    private static final String SUBSCHEMA_COLUMN = DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName();
    private static final String SUBSCHEMA_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.IDMSX_SUBSCHEMA, new String[0]);
    private static final String SET_CACHE_TABLE = "#temporarySets";
    private static final String SET_PARAM = "@Set";
    private static final String SET_PARAM_LIMIT = "@SetLimit";
    private static final String RECORD_CACHE_TABLE = "#temporaryRecords";
    private static final String RECORD_PARAM = "@Record";
    private static final String RECORD_PARAM_LIMIT = "@RecordLimit";
    private static final String SET_OR_RECORD_COLUMN = DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName();
    private static final String PROGRAM_CACHE_TABLE = "#temporaryPrograms";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String DDCL_CACHE_TABLE = "#temporaryDdcls";
    private static final String DDCL_ELEM_COLUMN = DatabaseMetadata.DDCL_ELEMENT.getName();
    private static final String DDCL_ELEM_PARAM_LIMIT = "@DDCLElemLimit";
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM = "@StatementType";
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_TYPE_NAME.getName();
    private static final String STATEMENT_PARAM_LIMIT = "@StartRowLimit";
    private static final String RESOURCE_TYPE = "ResourceType";
    private static final String RESOURCE_TYPE_GROUP_1 = "ResourceTypeGroup1";
    private static final String RESOURCE_TYPE_GROUP_2 = "ResourceTypeGroup2";
    public static final String MAINFRAME_IDMSX_SCHEMA_USAGE = "com.ez.analysis.mainframe.usage.idmsx";
    private static final String SET_CONDITIONS = String.valueOf(SET_OR_RECORD_COLUMN) + " " + IDMS_SET_LIKE_OR_IN_MARKER;
    private static final String SET_RESOURCE_CONDITIONS = "(ResourceType=78 OR ResourceType=10)";
    private static final String RECORD_CONDITIONS = String.valueOf(SET_OR_RECORD_COLUMN) + " " + IDMS_RECORD_LIKE_OR_IN_MARKER;
    private static final String RECORD_RESOURCE_CONDITIONS = "(ResourceType=77 OR ResourceType=3)";
    private static final String PROGRAM_CONDITIONS = String.valueOf(PROGRAM_COLUMN) + " " + PROGRAM_LIKE_OR_IN_MARKER + " AND " + ANCESTOR_NAME_COLUMN + " " + ANCESTOR_LIKE_OR_IN_MARKER;
    private static final String PROGRAM_RESOURCE_CONDITIONS = "(ResourceType=77 OR ResourceType=78)";
    private static final String DDCL_ELEMENT_CONDITIONS = String.valueOf(DDCL_ELEM_COLUMN) + " " + DDCL_ELEM_LIKE_OR_IN_MARKER;
    private static final String DDCL_ELEMENT_RESOURCE_CONDITIONS = "(ResourceType=10 OR ResourceType=3)";
    private static final String IDMSX_USAGE_FILTERS_FILE_NAME = "IDMSXUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> IDMSX_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        private static final long serialVersionUID = 1L;
        {
            ArrayList<ColumnInfo> projectList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), projectList);
            projectList.add(DatabaseMetadata.PROJECT_NAME);
            ArrayList<ColumnInfo> programList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROGRAM.name(), programList);
            programList.add(DatabaseMetadata.PRG_ID);
            programList.add(DatabaseMetadata.PRG_NAME);
            programList.add(DatabaseMetadata.PRG_TYPE_ID);
            programList.add(DatabaseMetadata.PRG_PATH);
            ArrayList<ColumnInfo> idmsSchemaList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMSX_SCHEMA.name(), idmsSchemaList);
            idmsSchemaList.add(DatabaseMetadata.IDMS_SCHEMA_ID);
            idmsSchemaList.add(DatabaseMetadata.IDMS_SCHEMA_NAME);
            ArrayList<ColumnInfo> idmsSubschemaList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMSX_SUBSCHEMA.name(), idmsSubschemaList);
            idmsSubschemaList.add(DatabaseMetadata.IDMS_SUBSCHEMA_ID);
            idmsSubschemaList.add(DatabaseMetadata.IDMS_SUBSCHEMA_NAME);
            ArrayList<ColumnInfo> idmsSetOrRecordList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMS_SET.name(), idmsSetOrRecordList);
            this.put(ResultElementType.IDMS_RECORD.name(), idmsSetOrRecordList);
            idmsSetOrRecordList.add(DatabaseMetadata.RESOURCE_TYPE_NAME);
            idmsSetOrRecordList.add(DatabaseMetadata.IDMS_SET_OR_RECORD_ID);
            idmsSetOrRecordList.add(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME);
            ArrayList<ColumnInfo> statementTypeList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMS_FUNCTION.name(), statementTypeList);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_ID);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_NAME);
            statementTypeList.add(DatabaseMetadata.STMT_PATH_STR);
            statementTypeList.add(DatabaseMetadata.STMT_START_ROW);
            statementTypeList.add(DatabaseMetadata.STMT_END_ROW);
            ArrayList<ColumnInfo> ddclElemList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.DDCL_ELEMENT.name(), ddclElemList);
            ddclElemList.add(DatabaseMetadata.DDCL_ELEMENT_PATH);
            ddclElemList.add(DatabaseMetadata.DDCL_ELEMENT_CATEGORY);
            ddclElemList.add(DatabaseMetadata.DDCL_ELEM_ID);
            ddclElemList.add(DatabaseMetadata.DDCL_ELEMENT_START_ROW);
            ddclElemList.add(DatabaseMetadata.DDCL_ELEMENT_END_ROW);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    private HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement> spDenseRankStatements;

    public IDMSXDescriptor(IDMSXUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_IDMSX_SCHEMA_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IDMSXTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        ResultElementType ret = ResultElementType.DDCL_ELEMENT;
        boolean isParticularDDCl = false;
        Iterator<EZObjectType> iterator = objTypes.iterator();
        if (iterator.hasNext()) {
            EZObjectType objType = iterator.next();
            if (objType instanceof EZDDCLSchema) {
                ret = ResultElementType.IDMSX_SCHEMA;
                isParticularDDCl = true;
            } else if (objType instanceof EZDDCLSubschema) {
                ret = ResultElementType.IDMSX_SUBSCHEMA;
                isParticularDDCl = true;
            } else if (objType instanceof EZSourceIDMSRecord) {
                ret = ResultElementType.IDMS_RECORD;
                isParticularDDCl = true;
            } else if (objType instanceof EZSourceIDMSSet) {
                ret = ResultElementType.IDMS_SET;
                isParticularDDCl = true;
            }
        }
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, ret);
        if (!isParticularDDCl && defaultPatterns.containsKey(ResultElementType.DDCL_ELEMENT_NAME)) {
            defaultPatterns.put(ResultElementType.DDCL_ELEMENT, defaultPatterns.get(ResultElementType.DDCL_ELEMENT_NAME));
            defaultPatterns.remove(ResultElementType.DDCL_ELEMENT_NAME);
        }
        return new IDMSXFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.IDMSX_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_IDMSX";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.DDCL_ELEMENT.name(), " @DDCLElemLimit INT, @ddclElemName VARCHAR(64)");
            spParam.put(ResultElementType.IDMSX_SCHEMA.name(), " @SchemaLimit INT, @Schema VARCHAR(64)");
            spParam.put(ResultElementType.IDMSX_SUBSCHEMA.name(), " @SubschemaLimit INT, @Subschema VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_SET.name(), " @SetLimit INT, @Set VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_RECORD.name(), " @RecordLimit INT, @Record VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_FUNCTION.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64)");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.IDMSX_SCHEMA.name(), "(@Schema = ''%'' or " + SCHEMA_COLUMN + " " + SCHEMA_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.IDMSX_SUBSCHEMA.name(), "(@Subschema = ''%'' or " + SUBSCHEMA_COLUMN + " " + SUBSCHEMA_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.IDMS_SET.name(), "(" + SET_CONDITIONS + " AND " + SET_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.IDMS_RECORD.name(), "(" + RECORD_CONDITIONS + " AND " + RECORD_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), "(" + PROGRAM_CONDITIONS + " AND " + PROGRAM_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.DDCL_ELEMENT.name(), "(" + DDCL_ELEMENT_CONDITIONS + " AND " + DDCL_ELEMENT_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.IDMS_FUNCTION.name(), "(@StatementType = ''%'' or " + STATEMENT_TYPE_COLUMN + " like " + STATEMENT_TYPE_PARAM + ")");
        }
        return spWhereClause;
    }

    @Override
    public String getFileName() {
        return IDMSX_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMSX_SCHEMA, DatabaseMetadata.IDMS_SCHEMA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMSX_SUBSCHEMA, DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_SET, DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_RECORD, DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_ELEMENT, DatabaseMetadata.DDCL_ELEMENT.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_FUNCTION, DatabaseMetadata.STMT_TYPE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.STMT_START_ROW.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return IDMSX_TABLE_CSV_HEADER;
    }

    @Override
    public int getDefaultExpandLevel() {
        return 6;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        if (this.spDenseRankStatements == null) {
            this.spDenseRankStatements = new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
                private static final long serialVersionUID = 1L;
                {
                    String recordCountTest = " AND ((@Record=''%'') OR EXISTS (SELECT * FROM #temporaryRecords WHERE " + RECORD_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                    String setCountTest = " AND ((@Set=''%'') OR EXISTS (SELECT * FROM #temporarySets WHERE " + SET_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                    String ddclElementCountTest = " AND (@ddclElemName=''%'' OR EXISTS (SELECT * FROM #temporaryDdcls WHERE " + DDCL_ELEMENT_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                    String programCountTest = " AND ((@Program=''%'' AND @Ancestor=''%'' ) OR EXISTS (SELECT * FROM #temporaryPrograms WHERE " + PROGRAM_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                    this.put(ResultElementType.IDMSX_SCHEMA.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SCHEMA_NAME.getName()).limitParamName(IDMSXDescriptor.SCHEMA_PARAM_LIMIT).create());
                    this.put(ResultElementType.IDMSX_SUBSCHEMA.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName()).limitParamName(IDMSXDescriptor.SUBSCHEMA_PARAM_LIMIT).create());
                    DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName()).tempTableName(IDMSXDescriptor.SET_CACHE_TABLE).limitParamName(IDMSXDescriptor.SET_PARAM_LIMIT).additionalCondition(IDMSXDescriptor.SET_RESOURCE_CONDITIONS).additionalCacheTableCondition(IDMSXDescriptor.SET_RESOURCE_CONDITIONS).additionalParseByElements(Arrays.asList(IDMSXDescriptor.RESOURCE_TYPE_GROUP_1)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(recordCountTest){
                        {
                            this.put(ResultElementType.IDMS_RECORD.name(), string);
                        }
                    }).create();
                    this.put(ResultElementType.IDMS_SET.name(), denseRankStatement);
                    denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName()).tempTableName(IDMSXDescriptor.RECORD_CACHE_TABLE).limitParamName(IDMSXDescriptor.RECORD_PARAM_LIMIT).additionalCondition(IDMSXDescriptor.RECORD_RESOURCE_CONDITIONS).additionalCacheTableCondition(IDMSXDescriptor.RECORD_RESOURCE_CONDITIONS).additionalParseByElements(Arrays.asList(IDMSXDescriptor.RESOURCE_TYPE_GROUP_1)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(setCountTest){
                        {
                            this.put(ResultElementType.IDMS_SET.name(), string);
                        }
                    }).create();
                    this.put(ResultElementType.IDMS_RECORD.name(), denseRankStatement);
                    denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PRG_NAME.getName()).tempTableName(IDMSXDescriptor.PROGRAM_CACHE_TABLE).limitParamName(IDMSXDescriptor.PROGRAM_PARAM_LIMIT).additionalCondition("(ResourceType=78 OR ResourceType=77)").additionalCacheTableCondition("(ResourceType=78 OR ResourceType=77)").additionalParseByElements(Arrays.asList(IDMSXDescriptor.RESOURCE_TYPE_GROUP_2)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(ddclElementCountTest){
                        {
                            this.put(ResultElementType.DDCL_ELEMENT.name(), string);
                        }
                    }).additionalColumns((Set<String>)new HashSet<String>(){
                        {
                            this.add(ANCESTOR_NAME_COLUMN);
                        }
                    }).create();
                    this.put(ResultElementType.PROGRAM.name(), denseRankStatement);
                    denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.DDCL_ELEMENT.getName()).tempTableName(IDMSXDescriptor.DDCL_CACHE_TABLE).limitParamName(IDMSXDescriptor.DDCL_ELEM_PARAM_LIMIT).additionalCondition("(ResourceType=3 OR ResourceType=10)").additionalCacheTableCondition("(ResourceType=3 OR ResourceType=10)").additionalParseByElements(Arrays.asList(IDMSXDescriptor.RESOURCE_TYPE_GROUP_2)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(programCountTest){
                        {
                            this.put(ResultElementType.PROGRAM.name(), string);
                        }
                    }).create();
                    this.put(ResultElementType.DDCL_ELEMENT.name(), denseRankStatement);
                    this.put(ResultElementType.IDMS_FUNCTION.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_TYPE_NAME.getName()).limitParamName(IDMSXDescriptor.STATEMENT_TYPE_PARAM_LIMIT).create());
                    this.put(ResultElementType.STMT_SOURCE_INFO.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_START_ROW.getName()).limitParamName(IDMSXDescriptor.STATEMENT_PARAM_LIMIT).create());
                }
            };
        }
        return this.spDenseRankStatements;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "IDMSX";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

