/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.idms;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class IDMSTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected List<ResultElementType> elementTypes = null;

    public IDMSTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case PROGRAM: {
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                if (ancestorName != null && !ancestorName.isEmpty()) {
                    resultElement.addProperty("Ancestor Name", ancestorName);
                    Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                    resultElement.addProperty("Ancestor Id", ancestorId);
                }
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case IDMS_SET: 
            case IDMS_RECORD: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.IDMS_SET_OR_RECORD_ID.getName());
                int type = (Integer)r.getColumnValue(DatabaseMetadata.RESOURCE_TYPE.getName());
                Integer idmsTypeId = null;
                if (type == 77) {
                    idmsTypeId = 75;
                } else if (type == 78) {
                    idmsTypeId = 76;
                }
                if (idmsTypeId != null) {
                    resultElement.addProperty("Resource Type", idmsTypeId);
                }
                String category = resultElement.getType().equals((Object)ResultElementType.IDMS_SET) ? ResultElementType.IDMS_SET.getDisplayName() : ResultElementType.IDMS_RECORD.getDisplayName();
                GenericProgramRelatedNode prgNodeIDMS = new GenericProgramRelatedNode(resultElement.getName(), category);
                resultElement.addProperty("Node_Mainframe", prgNodeIDMS);
                break;
            }
            case STMT_SOURCE_INFO: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                resultElement.addProperty("Program Type Id", programTypeId);
                String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                String stmtDescr = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_TYPE_NAME.getName()));
                String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtDescr, prgType));
                resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                resultElement.addProperty("Stmt Start Row", startRow);
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case IDMS_SCHEMA: 
            case IDMS_SUBSCHEMA: {
                String category = resultElement.getType().equals((Object)ResultElementType.IDMS_SCHEMA) ? ResultElementType.IDMS_SCHEMA.getDisplayName() : ResultElementType.IDMS_SUBSCHEMA.getDisplayName();
                GenericProgramRelatedNode prgNodeIDMS = new GenericProgramRelatedNode(resultElement.getName(), category);
                resultElement.addProperty("Node_Mainframe", prgNodeIDMS);
            }
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    ResultElement categoryResultElement = null;
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        if (id != null) {
                            key = id.toString().concat(name);
                        }
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    } else if (levelElementType.equals((Object)ResultElementType.IDMS_SET) || levelElementType.equals((Object)ResultElementType.IDMS_RECORD)) {
                        Integer setOrRecordTypeId = (Integer)r.getColumnValue(DatabaseMetadata.RESOURCE_TYPE.getName());
                        if (setOrRecordTypeId == 77) {
                            levelElementType = ResultElementType.IDMS_RECORD;
                        } else if (setOrRecordTypeId == 78) {
                            levelElementType = ResultElementType.IDMS_SET;
                        }
                        parent = categoryResultElement = Utils.getCategory(levelElementType, parent, null);
                        while (levelIndex < this.levelsOrder.size() - 1 && (((ResultElementType)this.levelsOrder.get(levelIndex + 1)).equals((Object)ResultElementType.IDMS_SET) || ((ResultElementType)this.levelsOrder.get(levelIndex + 1)).equals((Object)ResultElementType.IDMS_RECORD))) {
                            ++levelIndex;
                        }
                    }
                    ResultElement resultElement = parent.getChild(key);
                    if (resultElement == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        IDMSTreeProvider.this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    IDMSTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.PROGRAM);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    IDMSTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

