/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.idms;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class IDMSFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public IDMSFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageIDMSSchemaLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.IDMS_SCHEMA, defaultPatterns, limit);
        this.addIdmsSchemaColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageIDMSSubschemaLimit", 0);
        e = this.makeFilterEntry(ResultElementType.IDMS_SUBSCHEMA, defaultPatterns, limit);
        this.addIdmsSubschemaColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        GroupFilterEntry idmsSetOrRecordGroupFilterEntry = new GroupFilterEntry();
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageRecordLimit", 0);
        e = this.makeFilterEntry(ResultElementType.IDMS_RECORD, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Record");
        this.addSetOrRecordColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        idmsSetOrRecordGroupFilterEntry.addFilterEntry(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageSetLimit", 0);
        e = this.makeFilterEntry(ResultElementType.IDMS_SET, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Set");
        this.addSetOrRecordColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        idmsSetOrRecordGroupFilterEntry.addFilterEntry(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        this.addProgramColumns(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "IDMSUsageStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addFunctionColumns(e);
        this.entries.add(e);
    }

    private void addIdmsSchemaColumns(FilterEntry e) {
        e.put(DatabaseMetadata.IDMS_SCHEMA_NAME.getName(), DatabaseMetadata.IDMS_SCHEMA_NAME.getName());
        e.put(DatabaseMetadata.IDMS_SCHEMA_ID.getName(), DatabaseMetadata.IDMS_SCHEMA_ID.getName());
        this.addCommonColumns(e);
    }

    private void addIdmsSubschemaColumns(FilterEntry e) {
        e.put(DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName(), DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName());
        e.put(DatabaseMetadata.IDMS_SUBSCHEMA_ID.getName(), DatabaseMetadata.IDMS_SUBSCHEMA_ID.getName());
        this.addCommonColumns(e);
    }

    private void addSetOrRecordColumns(FilterEntry e) {
        e.put(DatabaseMetadata.IDMS_SET_OR_RECORD_ID.getName(), DatabaseMetadata.IDMS_SET_OR_RECORD_ID.getName());
        e.put(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName(), DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName());
        e.put(DatabaseMetadata.RESOURCE_TYPE.getName(), DatabaseMetadata.RESOURCE_TYPE.getName());
        e.put(DatabaseMetadata.RESOURCE_TYPE_NAME.getName(), DatabaseMetadata.RESOURCE_TYPE_NAME.getName());
        this.addCommonColumns(e);
    }

    private void addProgramColumns(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_START_ROW.getName(), DatabaseMetadata.PRG_ANCESTOR_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_END_ROW.getName(), DatabaseMetadata.PRG_ANCESTOR_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_START_COL.getName(), DatabaseMetadata.PRG_ANCESTOR_START_COL.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_END_COL.getName(), DatabaseMetadata.PRG_ANCESTOR_END_COL.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        this.addCommonColumns(e);
    }

    private void addFunctionColumns(FilterEntry e) {
        e.put("DynamicProcParamName", "@StatementType");
        e.put(DatabaseMetadata.STMT_TYPE_ID.getName(), DatabaseMetadata.STMT_TYPE_ID.getName());
        e.put(DatabaseMetadata.STMT_TYPE_NAME.getName(), DatabaseMetadata.STMT_TYPE_NAME.getName());
        this.addCommonColumns(e);
    }

    private void addCommonColumns(FilterEntry e) {
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), DatabaseMetadata.STMT_PATH_STR.getName());
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), DatabaseMetadata.STMT_START_ROW.getName());
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), DatabaseMetadata.STMT_END_ROW.getName());
        e.put(DatabaseMetadata.STMT_START_COL.getName(), DatabaseMetadata.STMT_START_COL.getName());
        e.put(DatabaseMetadata.STMT_END_COL.getName(), DatabaseMetadata.STMT_END_COL.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
    }
}

