/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.idms;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.idms.IDMSFilter;
import com.ez.analysis.mainframe.usage.idms.IDMSTreeProvider;
import com.ez.analysis.mainframe.usage.idms.IDMSUsageAnalysis;
import com.ez.analysis.mainframe.usage.idms.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDMSDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(IDMSDescriptor.class);
    private static final String SCHEMA_PARAM = "@Schema";
    private static final String SCHEMA_PARAM_LIMIT = "@SchemaLimit";
    private static final String SCHEMA_COLUMN = DatabaseMetadata.IDMS_SCHEMA_NAME.getName();
    private static final String SUBSCHEMA_PARAM = "@Subschema";
    private static final String SUBSCHEMA_PARAM_LIMIT = "@SubschemaLimit";
    private static final String SUBSCHEMA_COLUMN = DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName();
    private static final String SET_CACHE_TABLE = "#temporarySets";
    private static final String SET_PARAM_LIMIT = "@SetLimit";
    private static final String RECORD_CACHE_TABLE = "#temporaryRecords";
    private static final String RECORD_PARAM_LIMIT = "@RecordLimit";
    private static final String SET_OR_RECORD_COLUMN = DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName();
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_TYPE_NAME.getName();
    private static final String STATEMENT_PARAM_LIMIT = "@StartRowLimit";
    private static final String RESOURCE_TYPE = "ResourceType";
    public static final String MAINFRAME_IDMS_SCHEMA_USAGE = "com.ez.analysis.mainframe.usage.idms";
    private static final String IDMS_USAGE_FILTERS_FILE_NAME = "IDMSUsageFilters.properties";
    private static final String SET_CONDITIONS = "UPPER(" + SET_OR_RECORD_COLUMN + ") " + IDMS_SET_LIKE_OR_IN_MARKER;
    private static final String SET_RESOURCE_CONDITIONS = "ResourceType=78";
    private static final String RECORD_CONDITIONS = "UPPER(" + SET_OR_RECORD_COLUMN + ") " + IDMS_RECORD_LIKE_OR_IN_MARKER;
    private static final String RECORD_RESOURCE_CONDITIONS = "ResourceType=77";
    public static final Map<String, List<ColumnInfo>> IDMS_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        private static final long serialVersionUID = 1L;
        {
            ArrayList<ColumnInfo> projectList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), projectList);
            projectList.add(DatabaseMetadata.PROJECT_NAME);
            ArrayList<ColumnInfo> programList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROGRAM.name(), programList);
            programList.add(DatabaseMetadata.PRG_ID);
            programList.add(DatabaseMetadata.PRG_NAME);
            programList.add(DatabaseMetadata.PRG_TYPE_ID);
            programList.add(DatabaseMetadata.PRG_PATH);
            ArrayList<ColumnInfo> idmsSchemaList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMS_SCHEMA.name(), idmsSchemaList);
            idmsSchemaList.add(DatabaseMetadata.IDMS_SCHEMA_ID);
            idmsSchemaList.add(DatabaseMetadata.IDMS_SCHEMA_NAME);
            ArrayList<ColumnInfo> idmsSubschemaList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMS_SUBSCHEMA.name(), idmsSubschemaList);
            idmsSubschemaList.add(DatabaseMetadata.IDMS_SUBSCHEMA_ID);
            idmsSubschemaList.add(DatabaseMetadata.IDMS_SUBSCHEMA_NAME);
            ArrayList<ColumnInfo> idmsSetOrRecordList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.IDMS_SET.name(), idmsSetOrRecordList);
            this.put(ResultElementType.IDMS_RECORD.name(), idmsSetOrRecordList);
            idmsSetOrRecordList.add(DatabaseMetadata.RESOURCE_TYPE_NAME);
            idmsSetOrRecordList.add(DatabaseMetadata.IDMS_SET_OR_RECORD_ID);
            idmsSetOrRecordList.add(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME);
            ArrayList<ColumnInfo> statementTypeList = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.STMT_TYPE.name(), statementTypeList);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_ID);
            statementTypeList.add(DatabaseMetadata.STMT_TYPE_NAME);
            statementTypeList.add(DatabaseMetadata.STMT_PATH_STR);
            statementTypeList.add(DatabaseMetadata.STMT_START_ROW);
            statementTypeList.add(DatabaseMetadata.STMT_START_COL);
            statementTypeList.add(DatabaseMetadata.STMT_END_ROW);
            statementTypeList.add(DatabaseMetadata.STMT_END_COL);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public IDMSDescriptor(IDMSUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_IDMS_SCHEMA_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new IDMSTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new IDMSFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.IDMS_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_IDMS";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.IDMS_SCHEMA.name(), " @SchemaLimit INT, @Schema VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_SUBSCHEMA.name(), " @SubschemaLimit INT, @Subschema VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_SET.name(), " @SetLimit INT, @Set VARCHAR(64)");
            spParam.put(ResultElementType.IDMS_RECORD.name(), " @RecordLimit INT, @Record VARCHAR(64)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64)");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.IDMS_SCHEMA.name(), "(@Schema = ''%'' or UPPER(" + SCHEMA_COLUMN + ") like " + SCHEMA_PARAM + ")");
            spWhereClause.put(ResultElementType.IDMS_SUBSCHEMA.name(), "(@Subschema = ''%'' or UPPER(" + SUBSCHEMA_COLUMN + ") like " + SUBSCHEMA_PARAM + ")");
            spWhereClause.put(ResultElementType.IDMS_SET.name(), "(" + SET_CONDITIONS + " AND " + SET_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.IDMS_RECORD.name(), "(" + RECORD_CONDITIONS + " AND " + RECORD_RESOURCE_CONDITIONS + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), "((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ") AND (" + "@Ancestor" + " = ''%'' or UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), "(@StatementType = ''%'' or UPPER(" + STATEMENT_TYPE_COLUMN + ") " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public String getFileName() {
        return IDMS_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_SCHEMA, DatabaseMetadata.IDMS_SCHEMA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_SUBSCHEMA, DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_SET, DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.IDMS_RECORD, DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_TYPE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.STMT_START_ROW.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.STMT_bREAD.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return IDMS_TABLE_CSV_HEADER;
    }

    @Override
    public int getDefaultExpandLevel() {
        return 6;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                String recordCountTest = " AND ((@Record=''%'') OR EXISTS (SELECT * FROM #temporaryRecords WHERE " + RECORD_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                String setCountTest = " AND ((@Set=''%'') OR EXISTS (SELECT * FROM #temporarySets WHERE " + SET_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                this.put(ResultElementType.IDMS_SCHEMA.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SCHEMA_NAME.getName()).limitParamName(IDMSDescriptor.SCHEMA_PARAM_LIMIT).create());
                this.put(ResultElementType.IDMS_SUBSCHEMA.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SUBSCHEMA_NAME.getName()).limitParamName(IDMSDescriptor.SUBSCHEMA_PARAM_LIMIT).create());
                this.put(ResultElementType.IDMS_SET.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName()).tempTableName(IDMSDescriptor.SET_CACHE_TABLE).limitParamName(IDMSDescriptor.SET_PARAM_LIMIT).additionalCondition("ResourceType=78\n").additionalCacheTableCondition("ResourceType=78\n").additionalParseByElements(Arrays.asList(IDMSDescriptor.RESOURCE_TYPE)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(recordCountTest){
                    {
                        this.put(ResultElementType.IDMS_RECORD.name(), string);
                    }
                }).create());
                this.put(ResultElementType.IDMS_RECORD.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.IDMS_SET_OR_RECORD_NAME.getName()).tempTableName(IDMSDescriptor.RECORD_CACHE_TABLE).limitParamName(IDMSDescriptor.RECORD_PARAM_LIMIT).additionalCondition("ResourceType=77\n").additionalCacheTableCondition("ResourceType=77\n").additionalParseByElements(Arrays.asList(IDMSDescriptor.RESOURCE_TYPE)).additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(setCountTest){
                    {
                        this.put(ResultElementType.IDMS_SET.name(), string);
                    }
                }).create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PRG_NAME.getName()).limitParamName(IDMSDescriptor.PROGRAM_PARAM_LIMIT).additionalColumns((Set<String>)new HashSet<String>(){
                    {
                        this.add("@Ancestor");
                    }
                }).create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_TYPE_NAME.getName()).limitParamName(IDMSDescriptor.STATEMENT_TYPE_PARAM_LIMIT).create());
                this.put(ResultElementType.STMT_SOURCE_INFO.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.STMT_START_ROW.getName()).limitParamName(IDMSDescriptor.STATEMENT_PARAM_LIMIT).create());
            }
        };
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "IDMS";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

