/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.fileInPrg;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInPrgTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileInPrgTreeProvider.class);
    private static final String NOT_AVAILABLE_LBL = "N/A";
    protected List<ResultElementType> elementTypes = null;

    public FileInPrgTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case FILE: {
                String fileName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.FILE_NAME.getName()));
                resultElement.addProperty(DatabaseMetadata.FILE_NAME.getName(), fileName);
                Integer fileId = (Integer)r.getColumnValue(DatabaseMetadata.FILE_ID.getName());
                resultElement.addProperty(DatabaseMetadata.FILE_ID.getName(), fileId);
                resultElement.addProperty("isPhysicalFile attribute", fileName);
                GenericProgramRelatedNode prgNodeElem = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.FILE.getDisplayName());
                resultElement.addProperty("Node_Mainframe", prgNodeElem);
                break;
            }
            case PROGRAM: {
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                if (programTypeId == 0) {
                    String name = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                    ProgramUtils.setFakeProgTypeID(resultElement, name);
                } else {
                    resultElement.addProperty("Program Type Id", programTypeId);
                }
                String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                if (!programPath.isEmpty()) {
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                }
                ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                if (ancestorName == null || ancestorName.isEmpty()) break;
                resultElement.addProperty("Ancestor Name", ancestorName);
                Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                resultElement.addProperty("Ancestor Id", ancestorId);
                break;
            }
            case STMT_SOURCE_INFO: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
                String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
                resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                resultElement.addProperty("Stmt Start Row", startRow);
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                if (startRow != null && startCol != null && endRow != null && endCol != null) {
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                    break;
                }
                L.warn("display a usage statement without row/column information");
                Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, new Integer[0]);
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case LOGICAL_NAME: {
                GenericProgramRelatedNode prgNodeTable = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.LOGICAL_NAME.getDisplayName());
                resultElement.addProperty("Node_Mainframe", prgNodeTable);
            }
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            boolean isPrgOnDisk = true;
            String stmtNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_TYPE);
            String stmtDescription = Utils.null2empty(r.getColumnValue(stmtNameColumn));
            if (stmtDescription.equals(FileInPrgTreeProvider.NOT_AVAILABLE_LBL)) {
                isPrgOnDisk = false;
            }
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        if (id != null) {
                            key = id.toString().concat(name);
                        }
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    }
                    if (ResultElementType.LOGICAL_NAME.equals((Object)levelElementType) && ((name = (String)r.getColumnValue(DatabaseMetadata.LOGICAL_NAME.getName())) == null || name.isEmpty()) && ((name = (String)r.getColumnValue(DatabaseMetadata.FILE_NAME.getName())) == null || name.isEmpty())) {
                        name = Messages.getString(FileInPrgTreeProvider.class, "no.file.lbl");
                    }
                    if (ResultElementType.FILE.equals((Object)levelElementType) && (name = (String)r.getColumnValue(DatabaseMetadata.FILE_NAME.getName())) == null) {
                        name = (String)r.getColumnValue(DatabaseMetadata.LOGICAL_NAME.getName());
                    }
                    if ((resultElement = parent.getChild(key)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    FileInPrgTreeProvider.this.addElementInfo(resultElement, r);
                    FileInPrgTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    if (isPrgOnDisk) {
                        String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                        String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                        ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        FileInPrgTreeProvider.this.addElementInfo(resultElement, r);
                        parent.addChild(resultElement.getDisplayName(), resultElement);
                    }
                    isPrgOnDisk = true;
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

