/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.fileInPrg;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.ResultsLabelProvider;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.Utils;
import org.eclipse.jface.resource.ImageRegistry;

public class FileInPrgLabelProvider
extends ResultsLabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static String SCL_Property = System.getProperty("display.scl.ancestor");

    public FileInPrgLabelProvider(ImageRegistry registry) {
        super(registry);
    }

    @Override
    public String getToolTipText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        String displayName = re.getDisplayName();
        ResultElementType type = re.getType();
        String ret = type == null ? "" : type.getDisplayName();
        Integer prgType = (Integer)re.getProperty("Program Type Id");
        if (!ret.isEmpty() && type.isCategory()) {
            String categoryText = Messages.getString(FileInPrgLabelProvider.class, "tooltip.category.text");
            ret = String.valueOf(ret) + " " + categoryText;
            if (ResultElementType.PROGRAM_CATEGORY.equals((Object)type)) {
                if (prgType != null && 19 == prgType) {
                    displayName = Utils.getPrgType((String)String.valueOf(13));
                }
                ret = String.valueOf(ret) + " - " + (re == null ? "" : displayName);
            }
        } else if (ResultElementType.PROGRAM.equals((Object)type)) {
            if (prgType != null && 19 == prgType) {
                ret = Utils.getPrgType((String)String.valueOf(19));
                String ancestor = (String)re.getProperty("Ancestor Name");
                displayName = String.valueOf(ancestor) + ":" + displayName;
            }
        } else if (ResultElementType.FILE.equals((Object)type)) {
            displayName = (String)re.getProperty(DatabaseMetadata.FILE_NAME.getName());
        }
        if (!ret.isEmpty() && !type.isCategory()) {
            ret = String.valueOf(ret) + " - " + (re == null ? "" : displayName);
        }
        if (ret.isEmpty()) {
            ret = Messages.getString(((Object)((Object)this)).getClass(), "no.results.tooltip.text");
        }
        return FileInPrgLabelProvider.escapeText(ret);
    }

    @Override
    public String getText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        String displayName = re.getDisplayName();
        ResultElementType type = re.getType();
        Integer prgType = (Integer)re.getProperty("Program Type Id");
        if (ResultElementType.PROGRAM_CATEGORY.equals((Object)type)) {
            if (prgType != null && 19 == prgType) {
                displayName = Utils.getPrgType((String)String.valueOf(13));
            }
        } else if (ResultElementType.PROGRAM.equals((Object)type)) {
            if (prgType != null && 19 == prgType && SCL_Property != null) {
                String ancestor = (String)re.getProperty("Ancestor Name");
                displayName = String.valueOf(ancestor) + ":" + displayName;
            }
        } else if (ResultElementType.FILE.equals((Object)type)) {
            displayName = (String)re.getProperty(DatabaseMetadata.FILE_NAME.getName());
        }
        return displayName;
    }
}

