/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.fileInPrg;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.fileInPrg.FileInPrgFilter;
import com.ez.analysis.mainframe.usage.fileInPrg.FileInPrgLabelProvider;
import com.ez.analysis.mainframe.usage.fileInPrg.FileInPrgTreeProvider;
import com.ez.analysis.mainframe.usage.fileInPrg.FileInPrgUsageAnalysis;
import com.ez.analysis.mainframe.usage.fileInPrg.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInPrgDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileInPrgDescriptor.class);
    private static final String FILE_PARAM_LIMIT = "@FileLimit";
    private static final String FILE_COLUMN = DatabaseMetadata.FILE_NAME.getName();
    private static final String LOGICAL_NAME_PARAM = "@LogicalName";
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM = "@StatementType";
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    private static final String FILE_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.FILE, new String[0]);
    public static final String MAINFRAME_FILE_USAGE = "com.ez.analysis.mainframe.usage.files";
    private static final String FILE_USAGE_FILTERS_FILE_NAME = "FilesUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> FILES_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.FILE.name(), list);
            list.add(DatabaseMetadata.FILE_NAME);
            list.add(DatabaseMetadata.FILE_ID);
            list = new ArrayList();
            this.put(ResultElementType.LOGICAL_NAME.name(), list);
            list.add(DatabaseMetadata.LOGICAL_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_PATH_STR);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
            list.add(DatabaseMetadata.PRG_ANCESTOR_ID);
            list.add(DatabaseMetadata.PRG_ANCESTOR);
            list.add(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public FileInPrgDescriptor(FileInPrgUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_FILE_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new FileInPrgTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new FileInPrgFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.FILE_IN_PRG_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_FileInPrg";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.FILE.name(), " @FileLimit INT, @File VARCHAR(64)");
            spParam.put(ResultElementType.LOGICAL_NAME.name(), " @LogicalName VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.FILE.name(), " ((FileName is null AND @File = ''%'') OR (@File = ''%'' or FileName " + FILE_LIKE_OR_IN_MARKER + " or FileName = " + "@File" + "))");
            spWhereClause.put(ResultElementType.LOGICAL_NAME.name(), " ((LogicalName is null AND @LogicalName=''%'') or (@LogicalName = ''%'' or LogicalName like @LogicalName or LogicalName = @LogicalName))");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " (( @Program = ''%'' or " + PROGRAM_COLUMN + " " + PROGRAM_LIKE_OR_IN_MARKER + ") AND (" + "@Ancestor" + " = ''%'' or " + ANCESTOR_NAME_COLUMN + " " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType= ''%'' or Description like @StatementType)");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.FILE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(FILE_COLUMN).limitParamName(" @FileLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_TYPE_COLUMN).limitParamName(" @StatementTypeLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return FILE_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.FILE, FILE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.LOGICAL_NAME, DatabaseMetadata.LOGICAL_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_TYPE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return FILES_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "FileInPrg";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }

    @Override
    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new FileInPrgLabelProvider(imgRegistry);
    }
}

