/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInPrg;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.DDNameNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSInPrgTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSInPrgTreeProvider.class);
    private static final String NOT_AVAILABLE_LBL = "N/A";
    protected static final String QUERY1_DESCRIPTION_TEXT = "#EZ1#";
    protected static final String QUERY2_DESCRIPTION_TEXT = "#EZ2#";
    protected List<ResultElementType> elementTypes = null;

    public DSInPrgTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    private void addElementInfo(ResultElement resultElement, Row r) {
        switch (resultElement.getType()) {
            case DATASET: {
                String dataset = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()));
                resultElement.addProperty(DatabaseMetadata.DATASET_NAME.getName(), dataset);
                String datasetMemberName = (String)r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), datasetMemberName);
                String ddname = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                resultElement.addProperty(DatabaseMetadata.DD_NAME.getName(), ddname);
                Integer dsId = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_ID.getName());
                resultElement.addProperty(DatabaseMetadata.DATASET_ID.getName(), dsId);
                Integer dsGenerationnNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
                if (dsGenerationnNo != null) {
                    resultElement.addProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), dsGenerationnNo);
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)dsGenerationnNo, ResultElementType.DATASET.getDisplayName()));
                } else {
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)"", ResultElementType.DATASET.getDisplayName()));
                }
                DatasetUtils.setDDPath(resultElement, r);
                break;
            }
            case DDNAME: {
                DatasetUtils.setDDPath(resultElement, r);
                String name = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                DDNameNode ddNode = new DDNameNode(name);
                resultElement.addProperty("Node_Mainframe", ddNode);
                break;
            }
            case PROGRAM: {
                String ancestorName;
                Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                if (programTypeId == 0) {
                    ProgramUtils.setFakeProgTypeID(resultElement, resultElement.getName());
                } else {
                    resultElement.addProperty("Program Type Id", programTypeId);
                }
                String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                String programType = ProgramUtils.getProgramTypeAsString(resultElement);
                ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                if (!programPath.isEmpty()) {
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                }
                if ((ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()))) == null || ancestorName.isEmpty()) break;
                resultElement.addProperty("Ancestor Name", ancestorName);
                Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR_ID.getName());
                resultElement.addProperty("Ancestor Id", ancestorId);
                break;
            }
            case STMT_SOURCE_INFO: {
                Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
                String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                resultElement.addProperty("Stmt Start Row", startRow);
                Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                if (startRow != null && startCol != null && endRow != null && endCol != null) {
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                } else {
                    L.warn("display a usage statement without row/column information");
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, new Integer[0]);
                }
                resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, prgType));
                break;
            }
            case PROJECT_INFO: {
                resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                break;
            }
            case LOGICAL_NAME: {
                String name = (String)r.getColumnValue(DatabaseMetadata.LOGICAL_NAME.getName());
                resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(name, ResultElementType.LOGICAL_NAME.getDisplayName()));
            }
        }
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            boolean isPrgOnDisk = true;
            String stmtNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_TYPE);
            String stmtDescription = Utils.null2empty(r.getColumnValue(stmtNameColumn));
            if (stmtDescription.equals(DSInPrgTreeProvider.NOT_AVAILABLE_LBL)) {
                isPrgOnDisk = false;
            }
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                        Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                        if (id != null) {
                            key = id.toString().concat(name);
                        }
                        parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                    }
                    if (ResultElementType.DATASET.equals((Object)levelElementType)) {
                        key = DatasetUtils.getFullDSName(r, name);
                    }
                    if ((resultElement = parent.getChild(key)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    DSInPrgTreeProvider.this.addElementInfo(resultElement, r);
                    DSInPrgTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    if (isPrgOnDisk) {
                        String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                        String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                        ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        DSInPrgTreeProvider.this.addElementInfo(resultElement, r);
                        parent.addChild(resultElement.getDisplayName(), resultElement);
                    }
                    isPrgOnDisk = true;
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

