/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInPrg;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class DSInPrgFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public DSInPrgFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInProgramsDatasetLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.DATASET, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DSName");
        e.put("DynamicProcParamNameSecond", "@DSMemberName");
        this.addColumnsForDataset(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInProgramsDDNameLimit", 0);
        e = this.makeFilterEntry(ResultElementType.DDNAME, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DDName");
        this.addColumnsForDDName(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.LOGICAL_NAME, defaultPatterns, limit);
        e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
        e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
        this.addColumnsForLogicalName(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInProgramsProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        e.put("DynamicProcParamName", "@Program");
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        this.addColumnsForProgram(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInProgramsStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addColumnsForStmt(e);
        this.entries.add(e);
    }

    @Override
    protected void addColumnsForStmt(FilterEntry e) {
        e.put("DynamicProcParamName", "@StatementType");
        this.addMandatoryColumns(e);
    }

    @Override
    protected void addMandatoryColumns(FilterEntry e) {
        super.addMandatoryColumns(e);
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        e.put(DatabaseMetadata.DD_NAME.getName(), DatabaseMetadata.DD_NAME.getName());
    }

    private void addColumnsForProgram(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        this.addMandatoryColumns(e);
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_ID.getName());
        e.put(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName(), DatabaseMetadata.PRG_ANCESTOR_TYPE_ID.getName());
    }

    private void addColumnsForLogicalName(FilterEntry e) {
        e.put(DatabaseMetadata.LOGICAL_NAME.getName(), DatabaseMetadata.LOGICAL_NAME.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForDataset(FilterEntry e) {
        e.put(DatabaseMetadata.DATASET_NAME.getName(), DatabaseMetadata.DATASET_NAME.getName());
        e.put(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), DatabaseMetadata.DATASET_MEMBER_NAME.getName());
        e.put(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
        e.put(DatabaseMetadata.DATASET_ID.getName(), DatabaseMetadata.DATASET_ID.getName());
        this.addMandatoryColumns(e);
    }

    private void addColumnsForDDName(FilterEntry e) {
        e.put(DatabaseMetadata.DD_NAME.getName(), DatabaseMetadata.DD_NAME.getName());
        e.put(DatabaseMetadata.DD_PATH.getName(), DatabaseMetadata.DD_PATH.getName());
        e.put(DatabaseMetadata.DD_START_ROW.getName(), DatabaseMetadata.DD_START_ROW.getName());
        this.addMandatoryColumns(e);
    }
}

