/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInPrg;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.DatasetFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.dsInPrg.DSInPrgFilter;
import com.ez.analysis.mainframe.usage.dsInPrg.DSInPrgTreeProvider;
import com.ez.analysis.mainframe.usage.dsInPrg.DSInPrgUsageAnalysis;
import com.ez.analysis.mainframe.usage.dsInPrg.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.ResultsLabelProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSInPrgDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSInPrgDescriptor.class);
    private static final String DATASET_DISPLAY_TEMP_PARAM = "@DisplayTempDatasets";
    private static final String DATASET_PARAM_NAME = "@DSName";
    private static final String DATASET_PARAM_LIMIT = "@DSLimit";
    private static final String DATASET_COLUMN = DatabaseMetadata.DATASET_NAME.getName();
    private static final String DATASET_MEMBER_PARAM_NAME = "@DSMemberName";
    private static final String DATASET_MEMBER_COLUMN = DatabaseMetadata.DATASET_MEMBER_NAME.getName();
    private static final String DATASET_GENERATION_NUMBER_COLUMN = DatabaseMetadata.DATASET_GENERATION_NUMBER.getName();
    private static final String DD_NAME_PARAM = "@DDName";
    private static final String DD_NAME_PARAM_LIMIT = "@DDNameLimit";
    private static final String DD_NAME_COLUMN = DatabaseMetadata.DD_NAME.getName();
    private static final String LOGICAL_NAME_PARAM = "@LogicalName";
    private static final String LOGICAL_NAME_COLUMN = DatabaseMetadata.LOGICAL_NAME.getName();
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    public static final String MAINFRAME_DATASET_USAGE = "com.ez.analysis.mainframe.usage.datasets";
    private static final String DATASET_USAGE_FILTERS_FILE_NAME = "DatasetsUsageFilters.properties";
    public static final Map<String, List<ColumnInfo>> DATASET_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.DATASET.name(), list);
            list.addAll(DatasetUtils.getCsvColumns());
            list = new ArrayList();
            this.put(ResultElementType.DDNAME.name(), list);
            list.add(DatabaseMetadata.DD_NAME);
            list.add(DatabaseMetadata.DD_PATH);
            list.add(DatabaseMetadata.DD_START_ROW);
            list = new ArrayList();
            this.put(ResultElementType.LOGICAL_NAME.name(), list);
            list.add(DatabaseMetadata.LOGICAL_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_PATH_STR);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
            list.add(DatabaseMetadata.PRG_ANCESTOR_ID);
            list.add(DatabaseMetadata.PRG_ANCESTOR);
            list.add(DatabaseMetadata.PRG_ANCESTOR_TYPE_ID);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public DSInPrgDescriptor(DSInPrgUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_DATASET_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DSInPrgTreeProvider(this);
    }

    @Override
    protected void initializeCsvExportDescriptor() {
        HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler> handlerMap = new HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler>();
        handlerMap.put(DatabaseMetadata.DATASET_NAME, DatasetUtils.getDatasetNameCsvHandler());
        this.csvExportDescriptor = new CsvExportDescriptor(null, handlerMap);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new DSInPrgFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.DS_IN_PRG_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DSInPrg";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DATASET.name(), " @DisplayTempDatasets INT, @DSLimit INT, @DSName VARCHAR(64), @DSMemberName VARCHAR(64)");
            spParam.put(ResultElementType.DDNAME.name(), " @DDNameLimit INT, @DDName VARCHAR(64)");
            spParam.put(ResultElementType.LOGICAL_NAME.name(), " @LogicalName VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DATASET.name(), " ((DataSetName is null AND @DSName=''%'' AND DataSetMemberName is null AND @DSMemberName =''%'') OR (((@DisplayTempDatasets=0 AND (IsTemp IS NULL OR IsTemp<>1)) OR (@DisplayTempDatasets=1)) AND (@DSName = ''%'' or UPPER(DataSetName) " + DS_LIKE_OR_IN_MARKER + ")" + " AND (" + DATASET_MEMBER_PARAM_NAME + " = ''%'' or UPPER(DataSetMemberName) " + DS_MEMBER_LIKE_OR_IN_MARKER + ")))");
            spWhereClause.put(ResultElementType.DDNAME.name(), " (@DDName = ''%'' or UPPER(DDName) " + DD_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.LOGICAL_NAME.name(), " ((LogicalName is null AND @LogicalName=''%'') or ( @LogicalName = ''%'' or UPPER(LogicalName) like @LogicalName))");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " (( @Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ") AND (" + "@Ancestor" + " = ''%'' or UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER(Description) " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.DATASET.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DATASET_COLUMN).additionalOrderByElements(new HashSet<String>(Arrays.asList(DATASET_MEMBER_COLUMN, DATASET_GENERATION_NUMBER_COLUMN))).limitParamName(" @DSLimit ").create());
                this.put(ResultElementType.DDNAME.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DD_NAME_COLUMN).limitParamName(" @DDNameLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_TYPE_COLUMN).limitParamName(" @StatementTypeLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return DATASET_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DATASET, DATASET_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.DDNAME, DD_NAME_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.LOGICAL_NAME, LOGICAL_NAME_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_TYPE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DATASET_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DSInPrg";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        getFilterEntryParameterGeneratorMap.put(ResultElementType.DATASET.name(), new DatasetFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }

    @Override
    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new ResultsLabelProvider(imgRegistry);
    }
}

