/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInJob;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.ElementActionWithJob;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class DSInJobTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String STEP_IN_JOB_PATH = "StepPath";
    private static final String stmtTypelbl = Messages.getString(DSInJobTreeProvider.class, "stmt.type");
    private static final String accesTypelbl = Messages.getString(DSInJobTreeProvider.class, "access.type");
    private final String SHOW_STEP_SOURCE = Messages.getString(DSInJobTreeProvider.class, "step.goToSource.button");

    public DSInJobTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    @Override
    public List<ElementActionWithJob> contributeToContextMenu(ResultElement resultElem) {
        ElementActionWithJob linkEditor = this.makeViewStepAction(resultElem);
        if (linkEditor != null) {
            ArrayList<ElementActionWithJob> list = new ArrayList<ElementActionWithJob>();
            list.add(linkEditor);
            return list;
        }
        return null;
    }

    @Override
    public ElementActionWithJob contributeToDoubleClick(ResultElement resultElem) {
        ElementActionWithJob action = this.makeViewStepAction(resultElem);
        return action;
    }

    private ElementActionWithJob makeViewStepAction(final ResultElement resultElem) {
        ElementActionWithJob linkEditor = null;
        if (resultElem != null && resultElem.getProperty(STEP_IN_JOB_PATH) != null) {
            linkEditor = new ElementActionWithJob(){

                @Override
                public void execute(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString(DSInJobTreeProvider.class, "goToSource.task.text"), -1);
                    TextSelectionInFile path = (TextSelectionInFile)resultElem.getProperty(DSInJobTreeProvider.STEP_IN_JOB_PATH);
                    HashSet<TextSelectionInFile> options = new HashSet<TextSelectionInFile>();
                    options.add(path);
                    ProjectInfo pi = (ProjectInfo)resultElem.getProperty("ProjectInfo");
                    String prjName = pi != null ? pi.getName() : null;
                    com.ez.cobol.callgraph.utils.Utils.openEditor(options, (String)prjName);
                    monitor.done();
                }
            };
            linkEditor.setText(this.SHOW_STEP_SOURCE);
            linkEditor.setResultElem(resultElem);
        }
        return linkEditor;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    String procOrPgmInStep;
                    ResultElement resultElement;
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    if (ResultElementType.DDNAME.equals((Object)levelElementType) && this.isAMSStatement(r)) {
                        levelElementType = ResultElementType.IDCAMS_AMS_STMT;
                    }
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (ResultElementType.DATASET.equals((Object)levelElementType)) {
                        key = DatasetUtils.getFullDSName(r, name);
                    } else if (ResultElementType.JCL_JOB.equals((Object)levelElementType)) {
                        String memberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName()));
                        key = String.valueOf(key) + memberName;
                    } else if (ResultElementType.DDNAME.equals((Object)levelElementType)) {
                        parent = Utils.getCategory(levelElementType, parent, null);
                    } else if (ResultElementType.IDCAMS_AMS_STMT.equals((Object)levelElementType)) {
                        resultElement = (parent = Utils.getCategory(levelElementType, parent, null)).getChild(key);
                        if (resultElement == null) {
                            resultElement = new ResultElement(name, levelElementType, parent);
                            parent.addChild(key, resultElement);
                        }
                        parent = resultElement;
                        levelElementType = ResultElementType.STMT_SOURCE_INFO;
                        name = Utils.null2empty(r.getColumnValue((String)this.elemTypeToElemNameColumnsMap.get(levelElementType)));
                        key = null;
                    } else if (ResultElementType.JCL_STEP.equals((Object)levelElementType) && (procOrPgmInStep = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STEP_PROC_OR_PGM.getName()))) != null) {
                        key = String.valueOf(key) + procOrPgmInStep;
                    }
                    ResultElement resultElement2 = resultElement = key != null ? parent.getChild(key) : null;
                    if (resultElement == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        if (key == null) {
                            key = resultElement.getDisplayName();
                        }
                        parent.addChild(key, resultElement);
                    }
                    DSInJobTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                }
                ++levelIndex;
            }
            return true;
        }

        private boolean isAMSStatement(Row r) {
            Object amsStmt = r.getColumnValue(DatabaseMetadata.AMS_STMT_DESC_COL.getName());
            return amsStmt != null;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case DATASET: {
                    String dataset = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.DATASET_NAME.getName(), dataset);
                    String datasetMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DATASET_MEMBER_NAME.getName()));
                    resultElement.addProperty(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), datasetMemberName);
                    String ddname = (String)r.getColumnValue(DatabaseMetadata.DD_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.DD_NAME.getName(), ddname);
                    Integer dsId = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DATASET_ID.getName(), dsId);
                    Integer dsGenerationnNo = (Integer)r.getColumnValue(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
                    if (dsGenerationnNo != null) {
                        resultElement.addProperty(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), dsGenerationnNo);
                        resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)dsGenerationnNo, ResultElementType.DATASET.getDisplayName()));
                        break;
                    }
                    resultElement.addProperty("Node_Mainframe", new DatasetNode(dataset, datasetMemberName, (Object)"", ResultElementType.DATASET.getDisplayName()));
                    break;
                }
                case JCL_JOB: {
                    String jobName = (String)r.getColumnValue(DatabaseMetadata.JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_NAME.getName(), jobName);
                    String memberName = (String)r.getColumnValue(DatabaseMetadata.JOB_MEMBER_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_MEMBER_NAME.getName(), memberName);
                    Integer jobId = (Integer)r.getColumnValue(DatabaseMetadata.JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.JOB_ID.getName(), jobId);
                    String ca7jobName = (String)r.getColumnValue(DatabaseMetadata.CA7_JOB_NAME.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_NAME.getName(), ca7jobName);
                    Integer ca7jobId = (Integer)r.getColumnValue(DatabaseMetadata.CA7_JOB_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.CA7_JOB_ID.getName(), ca7jobId);
                    String jobPath = (String)r.getColumnValue(DatabaseMetadata.JOB_PATH.getName());
                    Utils.setFileAttribute(resultElement, "22", jobPath, new Integer[0]);
                    resultElement.addProperty("Node_Mainframe", new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), jobPath));
                    break;
                }
                case JCL_STEP: {
                    Boolean isProcInStep = "1".equals(r.getColumnValue(DatabaseMetadata.STEP_IS_EXEC_PROC.getName()));
                    String procOrPgmInStep = (String)r.getColumnValue(DatabaseMetadata.STEP_PROC_OR_PGM.getName());
                    resultElement.addProperty(DatabaseMetadata.STEP_PROC_OR_PGM.getName(), procOrPgmInStep);
                    String stepPath = (String)r.getColumnValue(DatabaseMetadata.STEP_PATH.getName());
                    Integer jobStartRow = (Integer)r.getColumnValue(DatabaseMetadata.STEP_START_ROW.getName());
                    TextSelectionInFile infoSel = new TextSelectionInFile(stepPath, "22", new Integer[]{jobStartRow});
                    resultElement.addProperty(DSInJobTreeProvider.STEP_IN_JOB_PATH, infoSel);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    String pgmOrProcPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PGM_OR_PROC_PATH.getName()));
                    String programType = ResultElementType.JCL_PROCEDURE.getDisplayName();
                    if (!pgmOrProcPath.isEmpty()) {
                        String editorId = "22";
                        if (!isProcInStep.booleanValue()) {
                            resultElement.addProperty("Program name", procOrPgmInStep);
                            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                            programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), pgmOrProcPath);
                            resultElement.addProperty("Program Type Id", programTypeId);
                            editorId = programTypeId.toString();
                        } else {
                            resultElement.addProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName(), procOrPgmInStep);
                        }
                        Integer pgmOrProcStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PGM_OR_PROC_START_ROW.getName());
                        Integer pgmOrProcStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PGM_OR_PROC_START_COL.getName());
                        Integer pgmOrProcEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PGM_OR_PROC_END_ROW.getName());
                        Integer pgmOrProcEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PGM_OR_PROC_END_COL.getName());
                        Utils.setFileAttribute(resultElement, editorId, pgmOrProcPath, pgmOrProcStartRow, pgmOrProcStartCol, pgmOrProcEndRow, pgmOrProcEndCol);
                    } else if (!isProcInStep.booleanValue()) {
                        String pgmName = (String)r.getColumnValue(DatabaseMetadata.STEP_PROC_OR_PGM.getName());
                        ProgramUtils.setFakeProgTypeID(resultElement, pgmName);
                    } else {
                        resultElement.addProperty(DatabaseMetadata.PROC_EXEC_IN_STEP.getName(), procOrPgmInStep);
                    }
                    if (!isProcInStep.booleanValue()) {
                        programType = ProgramUtils.getProgramTypeAsString(resultElement);
                        ProgramUtils.setPropertiesViewer(resultElement, procOrPgmInStep, stepPath, programType);
                        break;
                    }
                    MainframeSourceNode prgNode = new MainframeSourceNode(programType, pgmOrProcPath);
                    resultElement.addProperty("Node_Mainframe", prgNode);
                    break;
                }
                case STMT_SOURCE_INFO: {
                    String amsStmtName = (String)r.getColumnValue(DatabaseMetadata.AMS_STMT_DESC_COL.getName());
                    String amsUsageName = (String)r.getColumnValue(DatabaseMetadata.AMS_USAGE_DESC_COL.getName());
                    String stmtPath = (String)r.getColumnValue(DatabaseMetadata.AMS_STMT_PATH_COL.getName());
                    Integer stmtStartRow = (Integer)r.getColumnValue(DatabaseMetadata.AMS_START_ROW.getName());
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    resultElement.addProperty("Stmt Start Row", stmtStartRow);
                    MainframeSourceNode propObj = new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), stmtPath);
                    resultElement.addProperty("Node_Mainframe", propObj);
                    propObj.addEntry(stmtTypelbl, amsStmtName);
                    propObj.addEntry(accesTypelbl, amsUsageName);
                    Integer stmtStartCol = (Integer)r.getColumnValue(DatabaseMetadata.AMS_START_COL.getName());
                    Integer stmtEndRow = (Integer)r.getColumnValue(DatabaseMetadata.AMS_END_ROW.getName());
                    Integer stmtEndCol = (Integer)r.getColumnValue(DatabaseMetadata.AMS_END_COL.getName());
                    Utils.setFileAttribute(resultElement, "22", stmtPath, stmtStartRow, stmtStartCol, stmtEndRow, stmtEndCol);
                    break;
                }
                case DDNAME: {
                    DatasetUtils.setDDPath(resultElement, r);
                    DatasetUtils.setPropertiesInfoForDD(resultElement, r);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

