/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInJob;

import com.ez.analysis.mainframe.usage.Activator;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.JobWithMemberLabelProvider;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DSInJobLabelProvider
extends JobWithMemberLabelProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DSInJobLabelProvider(ImageRegistry registry) {
        super(registry);
    }

    @Override
    public String getToolTipText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String tooltip = null;
        if (ResultElementType.JCL_STEP.equals((Object)type)) {
            String prgType = ResultElementType.JCL_PROCEDURE.getDisplayName();
            if (re.getProperty("Program Type Id") != null) {
                prgType = ProgramUtils.getProgramTypeAsString(re);
            }
            String prgOrProcInStep = (String)re.getProperty(DatabaseMetadata.STEP_PROC_OR_PGM.getName());
            tooltip = Messages.getString(DSInJobLabelProvider.class, "step.tooltip", new String[]{prgType, prgOrProcInStep, re.getName()});
        } else {
            tooltip = super.getToolTipText(element);
        }
        return tooltip;
    }

    @Override
    public String getText(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        String text = null;
        if (ResultElementType.JCL_STEP.equals((Object)type)) {
            String prgOrProcInStep = (String)re.getProperty(DatabaseMetadata.STEP_PROC_OR_PGM.getName());
            text = Messages.getString(DSInJobLabelProvider.class, "step.text", new String[]{prgOrProcInStep, re.getName()});
        } else {
            text = super.getText(element);
        }
        return text;
    }

    @Override
    public Image getImage(Object element) {
        ResultElement re = (ResultElement)((Object)element);
        ResultElementType type = re.getType();
        Image img = null;
        if (type != null) {
            String reTypeString = type.name();
            if (type.equals((Object)ResultElementType.JCL_STEP)) {
                reTypeString = ResultElementType.JCL_PROCEDURE.getDisplayName();
                if (re.getProperty("Program Type Id") != null) {
                    reTypeString = ProgramUtils.getProgramTypeAsString(re);
                }
            }
            if ((img = this.registry.get(reTypeString)) == null && (img = this.createImage(re)) != null) {
                this.registry.put(reTypeString, img);
            }
        }
        return img;
    }

    @Override
    protected Image createImage(ResultElement element) {
        Image ret = null;
        ret = ResultElementType.JCL_STEP.equals((Object)element.getType()) ? (element.getProperty("Program Type Id") == null ? Activator.getImageDescriptor("icons/proc.png").createImage() : this.getImageByPrgTypeId(element)) : super.createImage(element);
        return ret;
    }
}

