/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInJob;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class DSInJobFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public DSInJobFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.canSkipFilterEntry = false;
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInJobsDatasetLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.DATASET, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DSName");
        e.put("DynamicProcParamNameSecond", "@DSMemberName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.DATASET_NAME.getName(), DatabaseMetadata.DATASET_NAME.getName());
        e.put(DatabaseMetadata.DATASET_MEMBER_NAME.getName(), DatabaseMetadata.DATASET_MEMBER_NAME.getName());
        e.put(DatabaseMetadata.DATASET_GENERATION_NUMBER.getName(), DatabaseMetadata.DATASET_GENERATION_NUMBER.getName());
        e.put(DatabaseMetadata.DATASET_ID.getName(), DatabaseMetadata.DATASET_ID.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInJobsJobLimit", 0);
        e = this.makeFilterEntry(ResultElementType.JCL_JOB, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@JCLName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.JOB_ID.getName(), DatabaseMetadata.JOB_ID.getName());
        e.put(DatabaseMetadata.JOB_NAME.getName(), DatabaseMetadata.JOB_NAME.getName());
        e.put(DatabaseMetadata.JOB_MEMBER_NAME.getName(), DatabaseMetadata.JOB_MEMBER_NAME.getName());
        e.put(DatabaseMetadata.CA7_JOB_NAME.getName(), DatabaseMetadata.CA7_JOB_NAME.getName());
        e.put(DatabaseMetadata.CA7_JOB_ID.getName(), DatabaseMetadata.CA7_JOB_ID.getName());
        e.put(DatabaseMetadata.JOB_PATH.getName(), DatabaseMetadata.JOB_PATH.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInJobsStepLimit", 0);
        e = this.makeFilterEntry(ResultElementType.JCL_STEP, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@StepName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.STEP_NAME.getName(), DatabaseMetadata.STEP_NAME.getName());
        e.put(DatabaseMetadata.STEP_START_ROW.getName(), DatabaseMetadata.STEP_START_ROW.getName());
        e.put(DatabaseMetadata.STEP_PATH.getName(), DatabaseMetadata.STEP_PATH.getName());
        e.put(DatabaseMetadata.STEP_PROC_OR_PGM.getName(), DatabaseMetadata.STEP_PROC_OR_PGM.getName());
        e.put(DatabaseMetadata.STEP_IS_EXEC_PROC.getName(), DatabaseMetadata.STEP_IS_EXEC_PROC.getName());
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.PGM_OR_PROC_PATH.getName(), DatabaseMetadata.PGM_OR_PROC_PATH.getName());
        e.put(DatabaseMetadata.PGM_OR_PROC_START_ROW.getName(), DatabaseMetadata.PGM_OR_PROC_START_ROW.getName());
        e.put(DatabaseMetadata.PGM_OR_PROC_START_COL.getName(), DatabaseMetadata.PGM_OR_PROC_START_COL.getName());
        e.put(DatabaseMetadata.PGM_OR_PROC_END_ROW.getName(), DatabaseMetadata.PGM_OR_PROC_END_ROW.getName());
        e.put(DatabaseMetadata.PGM_OR_PROC_END_COL.getName(), DatabaseMetadata.PGM_OR_PROC_END_COL.getName());
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DatasetUsageInJobsDDNameLimit", 0);
        e = this.makeFilterEntry(ResultElementType.DDNAME, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@DDName");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.DD_NAME.getName(), DatabaseMetadata.DD_NAME.getName());
        e.put(DatabaseMetadata.DD_PATH.getName(), DatabaseMetadata.DD_PATH.getName());
        e.put(DatabaseMetadata.DD_START_ROW.getName(), DatabaseMetadata.DD_START_ROW.getName());
        e.put(DatabaseMetadata.DD_STATUS.getName(), DatabaseMetadata.DD_STATUS.getName());
        e.put(DatabaseMetadata.DD_NORMAL_DISPOSITION.getName(), DatabaseMetadata.DD_NORMAL_DISPOSITION.getName());
        e.put(DatabaseMetadata.DD_ISDUMMY.getName(), DatabaseMetadata.DD_ISDUMMY.getName());
        e.put(DatabaseMetadata.DD_OVERRIDE_DDID.getName(), DatabaseMetadata.DD_OVERRIDE_DDID.getName());
        e.put(DatabaseMetadata.AMS_STMT_DESC_COL.getName(), DatabaseMetadata.AMS_STMT_DESC_COL.getName());
        e.put(DatabaseMetadata.AMS_USAGE_DESC_COL.getName(), DatabaseMetadata.AMS_USAGE_DESC_COL.getName());
        e.put(DatabaseMetadata.AMS_STMT_PATH_COL.getName(), DatabaseMetadata.AMS_STMT_PATH_COL.getName());
        e.put(DatabaseMetadata.AMS_START_ROW.getName(), DatabaseMetadata.AMS_START_ROW.getName());
        e.put(DatabaseMetadata.AMS_START_COL.getName(), DatabaseMetadata.AMS_START_COL.getName());
        e.put(DatabaseMetadata.AMS_END_ROW.getName(), DatabaseMetadata.AMS_END_ROW.getName());
        e.put(DatabaseMetadata.AMS_END_COL.getName(), DatabaseMetadata.AMS_END_COL.getName());
        this.entries.add(e);
    }
}

