/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dsInJob;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.DatasetFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.dsInJob.DSInJobFilter;
import com.ez.analysis.mainframe.usage.dsInJob.DSInJobLabelProvider;
import com.ez.analysis.mainframe.usage.dsInJob.DSInJobTreeProvider;
import com.ez.analysis.mainframe.usage.dsInJob.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.DatasetUtils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSInJobDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DSInJobDescriptor.class);
    private static final String DATASET_DISPLAY_TEMP_PARAM = "@DisplayTempDatasets";
    private static final String DATASET_PARAM = "@DSName";
    private static final String DATASET_PARAM_LIMIT = "@DSLimit";
    private static final String DATASET_COLUMN = DatabaseMetadata.DATASET_NAME.getName();
    private static final String DATASET_MEMBER_PARAM = "@DSMemberName";
    private static final String DATASET_MEMBER_COLUMN = DatabaseMetadata.DATASET_MEMBER_NAME.getName();
    private static final String DATASET_GENERATION_NUMBER_COLUMN = DatabaseMetadata.DATASET_GENERATION_NUMBER.getName();
    private static final String DD_NAME_PARAM = "@DDName";
    private static final String DD_NAME_PARAM_LIMIT = "@DDLimit";
    private static final String DD_NAME_COLUMN = DatabaseMetadata.DD_NAME.getName();
    private static final String JOB_PARAM = "@JCLName";
    private static final String JOB_PARAM_LIMIT = "@JCLLimit";
    private static final String JOB_COLUMN = DatabaseMetadata.JOB_NAME.getName();
    private static final String STEP_PARAM = "@StepName";
    private static final String STEP_PARAM_LIMIT = "@StepLimit";
    private static final String STEP_COLUMN = DatabaseMetadata.STEP_NAME.getName();
    private static final String AMS_DESC_COLUMN = DatabaseMetadata.AMS_STMT_DESC_COL.getName();
    private static final String AMS_STMT_COLUMN = DatabaseMetadata.AMS_STMT_PATH_COL.getName();
    public static final String MAINFRAME_BATCH_USAGE = "com.ez.analysis.mainframe.usage.batch";
    private static final String BATCH_USAGE_FILTERS_FILE_NAME = "BatchUsageFilters.properties";
    private static final Map<String, List<ColumnInfo>> DATASET_IN_JOB_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.DATASET.name(), list);
            list.addAll(DatasetUtils.getCsvColumns());
            list = new ArrayList();
            this.put(ResultElementType.JCL_JOB.name(), list);
            list.add(DatabaseMetadata.JOB_ID);
            list.add(DatabaseMetadata.JOB_NAME);
            list.add(DatabaseMetadata.JOB_MEMBER_NAME);
            list.add(DatabaseMetadata.JOB_PATH);
            list = new ArrayList();
            this.put(ResultElementType.JCL_STEP.name(), list);
            list.add(DatabaseMetadata.STEP_NAME);
            list.add(DatabaseMetadata.STEP_PATH);
            list.add(DatabaseMetadata.STEP_START_ROW);
            list.add(DatabaseMetadata.STEP_PROC_OR_PGM);
            list.add(DatabaseMetadata.PGM_OR_PROC_PATH);
            list = new ArrayList();
            this.put(ResultElementType.DDNAME.name(), list);
            list.add(DatabaseMetadata.DD_NAME);
            list.add(DatabaseMetadata.DD_PATH);
            list.add(DatabaseMetadata.DD_START_ROW);
            list.add(DatabaseMetadata.DD_STATUS);
            list.add(DatabaseMetadata.DD_NORMAL_DISPOSITION);
            list.add(DatabaseMetadata.DD_ISDUMMY);
            list.add(DatabaseMetadata.DD_OVERRIDE_DDID);
            list.add(DatabaseMetadata.AMS_STMT_DESC_COL);
            list.add(DatabaseMetadata.AMS_USAGE_DESC_COL);
            list.add(DatabaseMetadata.AMS_STMT_PATH_COL);
            list.add(DatabaseMetadata.AMS_START_ROW);
            list.add(DatabaseMetadata.AMS_START_COL);
            list.add(DatabaseMetadata.AMS_END_ROW);
            list.add(DatabaseMetadata.AMS_END_COL);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    private static Map<String, String> spOrderBy;

    public DSInJobDescriptor(AbstractAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_BATCH_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DSInJobTreeProvider(this);
    }

    @Override
    protected void initializeCsvExportDescriptor() {
        HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler> handlerMap = new HashMap<ColumnInfo, CsvExportDescriptor.CsvHandler>();
        handlerMap.put(DatabaseMetadata.DATASET_NAME, DatasetUtils.getDatasetNameCsvHandler());
        this.csvExportDescriptor = new CsvExportDescriptor(null, handlerMap);
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new DSInJobFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DSInJob";
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.DS_IN_JOB_HEADER_INFO;
    }

    @Override
    public String getFileName() {
        return BATCH_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DATASET_IN_JOB_CSV_HEADER;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DATASET.name(), "@DisplayTempDatasets INT, @DSLimit INT, @DSName VARCHAR(64), @DSMemberName VARCHAR(64)");
            spParam.put(ResultElementType.JCL_JOB.name(), "@JCLLimit INT, @JCLName VARCHAR(64)");
            spParam.put(ResultElementType.JCL_STEP.name(), "@StepLimit INT, @StepName VARCHAR(64) ");
            spParam.put(ResultElementType.DDNAME.name(), "@DDLimit INT, @DDName VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DATASET.name(), " ((@DisplayTempDatasets=0 AND IsTemp<>1) OR (@DisplayTempDatasets=1)) AND (@DSName = ''%'' or UPPER(DataSetName) " + DS_LIKE_OR_IN_MARKER + ")" + " AND (" + DATASET_MEMBER_PARAM + " = ''%'' or UPPER(DataSetMemberName) " + DS_MEMBER_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.JCL_JOB.name(), " (@JCLName = ''%'' or UPPER(JobName) " + JOB_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.JCL_STEP.name(), " (@StepName = ''%'' or UPPER(StepName) " + STEP_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.DDNAME.name(), " (@DDName = ''%'' or UPPER(DDName) " + DD_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.DATASET.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DATASET_COLUMN).additionalOrderByElements(new HashSet<String>(Arrays.asList(DATASET_MEMBER_COLUMN, DATASET_GENERATION_NUMBER_COLUMN))).limitParamName(DSInJobDescriptor.DATASET_PARAM_LIMIT).create());
                this.put(ResultElementType.JCL_JOB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(JOB_COLUMN).limitParamName(DSInJobDescriptor.JOB_PARAM_LIMIT).create());
                this.put(ResultElementType.JCL_STEP.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STEP_COLUMN).limitParamName(DSInJobDescriptor.STEP_PARAM_LIMIT).create());
                this.put(ResultElementType.DDNAME.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DD_NAME_COLUMN).limitParamName(DSInJobDescriptor.DD_NAME_PARAM_LIMIT).create());
            }
        };
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (spOrderBy == null) {
            spOrderBy = new HashMap<String, String>();
            spOrderBy.put(ResultElementType.DATASET.name(), "DataSetName,DataSetMemberName");
            spOrderBy.put(ResultElementType.JCL_JOB.name(), "JobName");
            spOrderBy.put(ResultElementType.JCL_STEP.name(), "StepName");
            spOrderBy.put(ResultElementType.DDNAME.name(), "DDName");
        }
        return spOrderBy;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DSInJob";
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DATASET, DATASET_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_JOB, JOB_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.JCL_STEP, STEP_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.DDNAME, DD_NAME_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.IDCAMS_AMS_STMT, AMS_DESC_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, AMS_STMT_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public boolean hasReorderResultsAction() {
        return false;
    }

    @Override
    public IBaseLabelProvider getResultsLabelProvider(ImageRegistry imgRegistry) {
        return new DSInJobLabelProvider(imgRegistry);
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.DATASET.name(), new DatasetFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

