/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl.dictionary;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class DDCLDictionaryTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final ResultElementType[] rsElemsDDCL = new ResultElementType[]{ResultElementType.DDCL_PROPERTY_NAME, ResultElementType.DDCL_PROPERTY_SOURCE_INFO};
    private static final ResultElementType[] rsElemsPrg = new ResultElementType[]{ResultElementType.STMT_TYPE, ResultElementType.STMT_SOURCE_INFO};

    public DDCLDictionaryTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        DDCLCallback callback = new DDCLCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.DDCL_ELEMENT_NAME);
        ret.add(ResultElementType.DDCL_ELEMENT);
        ret.add(ResultElementType.PROGRAM);
        return ret;
    }

    class DDCLCallback
    extends AbstractProcessRowCallback {
        public DDCLCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                block11: {
                    block7: {
                        String key;
                        String name;
                        ResultElementType levelElementType;
                        block9: {
                            block10: {
                                String elemTypeName;
                                block8: {
                                    if (levelIndex >= this.levelsOrder.size()) break block7;
                                    levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                                    key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                                    if (!levelElementType.equals((Object)ResultElementType.DDCL_ELEMENT_NAME)) break block8;
                                    elemTypeName = (String)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_DESCR_USED.getName());
                                    parent = Utils.getCategory(levelElementType, parent, elemTypeName);
                                    break block9;
                                }
                                if (!levelElementType.equals((Object)ResultElementType.DDCL_ELEMENT)) break block10;
                                elemTypeName = (String)r.getColumnValue(DatabaseMetadata.USED_IN_DDCL_ELEMENT_DESCR.getName());
                                if (elemTypeName == null) break block11;
                                parent = Utils.getCategory(levelElementType, parent, elemTypeName);
                                break block9;
                            }
                            if (!levelElementType.equals((Object)ResultElementType.PROGRAM)) break block9;
                            Integer progrTypeID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                            if (progrTypeID == null) break block11;
                            parent = ProgramUtils.getOrCreateCategoryForProgram(r, parent, name);
                        }
                        ResultElement resultElement = parent.getChild(key);
                        if (resultElement == null) {
                            resultElement = new ResultElement(name, levelElementType, parent);
                            this.addElementInfo(resultElement, r);
                            Utils.completeProjectInfo(resultElement, projectInfo);
                            parent.addChild(key, resultElement);
                        }
                        DDCLDictionaryTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                        break block11;
                    }
                    if (levelIndex == this.levelsOrder.size()) {
                        ResultElementType[] rsElems = null;
                        if (parent.getType().equals((Object)ResultElementType.DDCL_ELEMENT) || parent.getParent().getParent() != null && parent.getParent().getParent().getType().equals((Object)ResultElementType.DDCL_ELEMENT)) {
                            rsElems = rsElemsDDCL;
                        } else if (parent.getType().equals((Object)ResultElementType.PROGRAM) || parent.getParent().getParent() != null && parent.getParent().getParent().getType().equals((Object)ResultElementType.PROGRAM)) {
                            rsElems = rsElemsPrg;
                        }
                        ResultElementType[] resultElementTypeArray = rsElems;
                        int n = rsElems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ResultElementType rs = resultElementTypeArray[n2];
                            String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(rs);
                            String name = Utils.null2empty(r.getColumnValue(elemNameColumn));
                            ResultElement resultElement = new ResultElement(name, rs, parent);
                            this.addElementInfo(resultElement, r);
                            parent.addChild(resultElement.getDisplayName(), resultElement);
                            parent = resultElement;
                            ++n2;
                        }
                    }
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            String DDCLPROGRAMTYPE = String.valueOf(14);
            switch (resultElement.getType()) {
                case DDCL_ELEMENT_NAME: {
                    AMBaseNode ddclNode;
                    String ddclPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_USED_SI_FILE.getName()));
                    if (ddclPath != null && !ddclPath.isEmpty()) {
                        Integer ddclStartRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_ROW.getName());
                        Integer ddclStartCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_COL.getName());
                        Integer ddclEndRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_ROW.getName());
                        Integer ddclEndCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_COL.getName());
                        Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, ddclPath, ddclStartRow, ddclStartCol, ddclEndRow, ddclEndCol);
                    }
                    Integer typeID = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_TYPE_USED.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), typeID);
                    GenericProgramRelatedNode prgNodeElem = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DDCL_ELEMENT_NAME.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeElem);
                    Integer elemID = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_ID_USED.getName());
                    if (elemID != null) {
                        resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), elemID);
                    }
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), r.getColumnValue(DatabaseMetadata.DDCL_ELEMENT_NAME_USED.getName()));
                    Integer isIDMSXInt = (Integer)r.getColumnValue(DatabaseMetadata.USED_DDCL_ELEM_IS_IDMSX.getName());
                    if (isIDMSXInt != null && isIDMSXInt.equals(1)) {
                        resultElement.addProperty("Is IDMSX Key", Boolean.TRUE);
                    }
                    if ((ddclNode = AMNodesFactory.createNode((Integer)typeID, (String)resultElement.getName(), (Integer)elemID)) == null) break;
                    resultElement.addProperty("Application_Master_Node", ddclNode);
                    break;
                }
                case DDCL_ELEMENT: {
                    AMBaseNode ddclNode;
                    Integer elemID = (Integer)r.getColumnValue(DatabaseMetadata.USED_IN_DDCL_ELEMENT_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), elemID);
                    Integer typeID = (Integer)r.getColumnValue(DatabaseMetadata.USED_IN_DDCL_ELEMENT_TYPE.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), typeID);
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), r.getColumnValue(DatabaseMetadata.USED_IN_ELEMENT_NAME.getName()));
                    GenericProgramRelatedNode prgNodeDDCL = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DDCL_ELEMENT.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeDDCL);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_FILE_PATH.getName()));
                    Integer eStartRow = (Integer)r.getColumnValue(DatabaseMetadata.USED_ID_DDCL_ELEMENT_ROW.getName());
                    Integer eStartCol = (Integer)r.getColumnValue(DatabaseMetadata.USED_ID_DDCL_ELEMENT_START_COL.getName());
                    Integer eEndRow = (Integer)r.getColumnValue(DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_ROW.getName());
                    Integer eEndCol = (Integer)r.getColumnValue(DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, pPath, eStartRow, eStartCol, eEndRow, eEndCol);
                    Integer isIDMSXInt = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName());
                    if (isIDMSXInt != null && isIDMSXInt.equals(1)) {
                        resultElement.addProperty("Is IDMSX Key", Boolean.TRUE);
                    }
                    if ((ddclNode = AMNodesFactory.createNode((Integer)typeID, (String)resultElement.getName(), (Integer)elemID)) == null) break;
                    resultElement.addProperty("Application_Master_Node", ddclNode);
                    break;
                }
                case PROGRAM: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    if (programTypeId != 14) {
                        String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                        resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                        Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                        Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                        Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                        Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                        String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                        String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                        ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                        Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                    }
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case STMT_SOURCE_INFO: {
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    String programTypeStmt = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
                    String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_TYPE_NAME.getName());
                    resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, programTypeStmt));
                    Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                    resultElement.addProperty("Stmt Start Row", startRow);
                    Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                    Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                    Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                    break;
                }
                case DDCL_PROPERTY_SOURCE_INFO: {
                    String alias = (String)r.getColumnValue(DatabaseMetadata.DDCL_ALIAS.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ALIAS.getName(), alias);
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_FILE_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.DDCL_FILE_PATH.getName(), pPath);
                    MainframeSourceNode prgNode = new MainframeSourceNode(resultElement.getName(), pPath);
                    resultElement.addProperty("Node_Mainframe", prgNode);
                    Integer pStartRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName(), pStartRow);
                    Integer pEndRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName());
                    Integer pStartCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_START_COL.getName());
                    Integer pEndCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_END_COL.getName());
                    Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, pPath, pStartRow, pStartCol, pEndRow, pEndCol);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

