/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl.dictionary;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.GroupFilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class DDCLDictionaryFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String USED_BY = Messages.getString(DDCLDictionaryFilter.class, "context.usageType.used");
    private static final String USING = Messages.getString(DDCLDictionaryFilter.class, "context.usageType.using");
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public DDCLDictionaryFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.canSkipFilterEntry = true;
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "ElemUsedLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.DDCL_ELEMENT_NAME, defaultPatterns, limit);
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", "@usedDdclElemName");
        e.put(DatabaseMetadata.DDCL_ELEMENT_ID_USED.getName(), DatabaseMetadata.DDCL_ELEMENT_ID_USED.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_TYPE_USED.getName(), DatabaseMetadata.DDCL_ELEMENT_TYPE_USED.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_DESCR_USED.getName(), DatabaseMetadata.DDCL_ELEMENT_DESCR_USED.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_NAME_USED.getName(), DatabaseMetadata.DDCL_ELEMENT_NAME_USED.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_ROW.getName(), DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_ROW.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_ROW.getName(), DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_ROW.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_COL.getName(), DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_COL.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_COL.getName(), DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_COL.getName());
        e.put(DatabaseMetadata.DDCL_ELEMENT_USED_SI_FILE.getName(), DatabaseMetadata.DDCL_ELEMENT_USED_SI_FILE.getName());
        e.put(DatabaseMetadata.USED_DDCL_ELEM_IS_IDMSX.getName(), DatabaseMetadata.USED_DDCL_ELEM_IS_IDMSX.getName());
        e.put("incontext_prefix", USED_BY);
        e.put("in context value when is first used entry", " ");
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.entries.add(e);
        GroupFilterEntry programOrDDCLGroupFilterEntry = new GroupFilterEntry();
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DictionaryDDCLElemLimit", 0);
        e = this.makeFilterEntry(ResultElementType.DDCL_ELEMENT, defaultPatterns, limit);
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", "@ddclElemName");
        e.put(DatabaseMetadata.DDCL_ALIAS.getName(), DatabaseMetadata.DDCL_ALIAS.getName());
        e.put(DatabaseMetadata.USED_IN_DDCL_ELEMENT_TYPE.getName(), DatabaseMetadata.USED_IN_DDCL_ELEMENT_TYPE.getName());
        e.put(DatabaseMetadata.USED_IN_DDCL_ELEMENT_DESCR.getName(), DatabaseMetadata.USED_IN_DDCL_ELEMENT_DESCR.getName());
        e.put(DatabaseMetadata.USED_IN_ELEMENT_NAME.getName(), DatabaseMetadata.USED_IN_ELEMENT_NAME.getName());
        e.put(DatabaseMetadata.USED_IN_DDCL_ELEMENT_ID.getName(), DatabaseMetadata.USED_IN_DDCL_ELEMENT_ID.getName());
        e.put(DatabaseMetadata.USED_ID_DDCL_ELEMENT_ROW.getName(), DatabaseMetadata.USED_ID_DDCL_ELEMENT_ROW.getName());
        e.put(DatabaseMetadata.USED_ID_DDCL_ELEMENT_START_COL.getName(), DatabaseMetadata.USED_ID_DDCL_ELEMENT_START_COL.getName());
        e.put(DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_ROW.getName(), DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_ROW.getName());
        e.put(DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_COL.getName(), DatabaseMetadata.USED_ID_DDCL_ELEMENT_END_COL.getName());
        e.put(DatabaseMetadata.DDCL_FILE_PATH.getName(), DatabaseMetadata.DDCL_FILE_PATH.getName());
        e.put(DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName(), DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName());
        e.put(DatabaseMetadata.USED_IN_DDCL_PROPERTY_NAME.getName(), DatabaseMetadata.USED_IN_DDCL_PROPERTY_NAME.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName(), DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName(), DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_START_COL.getName(), DatabaseMetadata.DDCL_PROPERTY_START_COL.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_END_COL.getName(), DatabaseMetadata.DDCL_PROPERTY_END_COL.getName());
        e.put("incontext_prefix", USING);
        e.put("in context value when is first used entry", " ");
        this.entries.add(e);
        programOrDDCLGroupFilterEntry.addFilterEntry(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DictionaryPrgLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        e.put(DatabaseMetadata.PRG_TYPE_ID.getName(), DatabaseMetadata.PRG_TYPE_ID.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        e.put(DatabaseMetadata.STMT_TYPE_NAME.getName(), DatabaseMetadata.STMT_TYPE_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), DatabaseMetadata.STMT_START_ROW.getName());
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), DatabaseMetadata.STMT_END_ROW.getName());
        e.put(DatabaseMetadata.STMT_START_COL.getName(), DatabaseMetadata.STMT_START_COL.getName());
        e.put(DatabaseMetadata.STMT_END_COL.getName(), DatabaseMetadata.STMT_END_COL.getName());
        e.put("incontext_prefix", USING);
        e.put("in context value when is first used entry", " ");
        this.entries.add(e);
        programOrDDCLGroupFilterEntry.addFilterEntry(e);
    }
}

