/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl.dictionary;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.ddcl.dictionary.DDCLDictionaryFilter;
import com.ez.analysis.mainframe.usage.ddcl.dictionary.DDCLDictionaryTreeProvider;
import com.ez.analysis.mainframe.usage.ddcl.dictionary.DDCLDictionaryUsageAnalysis;
import com.ez.analysis.mainframe.usage.ddcl.dictionary.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDCLDictionaryDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String MAINFRAME_DDCL_DICTIONARY_USAGE = "com.ez.analysis.mainframe.usage.dictionary.usage.ddcl";
    private static final String DDCL_DICTIONARY_USAGE_FILTERS_FILE_NAME = "DDCLDictionaryUsageFilters.properties";
    private static final String DDCL_ELEM_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDCL_ELEMENT, new String[0]);
    private static final String DDCL_ELEM_NAME_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DDCL_ELEMENT_NAME, new String[0]);
    private static final String DDCL_CACHE_TABLE = "#temporaryDdcls";
    private static final String PROGRAM_CACHE_TABLE = "#temporaryPrograms";
    private static final String DDCL_ELEMENT_CONDITIONS = " usedInElementName " + DDCL_ELEM_LIKE_OR_IN_MARKER;
    private static final String PROGRAM_CONDITIONS = " ProgramName " + PROGRAM_LIKE_OR_IN_MARKER;
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    public static final Map<String, List<ColumnInfo>> DDCL_DICTIONARY_TABLE_CSV_HEADER;

    static {
        DDCL_DICTIONARY_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.DDCL_ELEMENT_NAME.name(), list);
                list.add(DatabaseMetadata.DDCL_ELEMENT_ID_USED);
                list.add(DatabaseMetadata.DDCL_ELEMENT_NAME_USED);
                list.add(DatabaseMetadata.DDCL_ELEMENT_DESCR_USED);
                list.add(DatabaseMetadata.DDCL_ALIAS);
                list.add(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_ROW);
                list.add(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_ROW);
                list.add(DatabaseMetadata.DDCL_ELEMENT_USED_SI_START_COL);
                list.add(DatabaseMetadata.DDCL_ELEMENT_USED_SI_END_COL);
                list.add(DatabaseMetadata.DDCL_ELEMENT_USED_SI_FILE);
                list = new ArrayList();
                this.put(ResultElementType.DDCL_ELEMENT.name(), list);
                list.add(DatabaseMetadata.DDCL_ELEM_ID);
                list.add(DatabaseMetadata.USED_IN_ELEMENT_NAME);
                list.add(DatabaseMetadata.USED_IN_DDCL_ELEMENT_DESCR);
                list.add(DatabaseMetadata.DDCL_START_ROW);
                list.add(DatabaseMetadata.DDCL_END_ROW);
                list.add(DatabaseMetadata.DDCL_START_COL);
                list.add(DatabaseMetadata.DDCL_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.DDCL_PROPERTY_NAME.name(), list);
                list.add(DatabaseMetadata.USED_IN_DDCL_PROPERTY_NAME);
                list.add(DatabaseMetadata.DDCL_ELEM_FILE_NAME);
                list.add(DatabaseMetadata.DDCL_FILE_PATH);
                list.add(DatabaseMetadata.DDCL_PROPERTY_START_ROW);
                list.add(DatabaseMetadata.DDCL_PROPERTY_END_ROW);
                list.add(DatabaseMetadata.DDCL_PROPERTY_START_COL);
                list.add(DatabaseMetadata.DDCL_PROPERTY_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list.add(DatabaseMetadata.PRG_START_ROW);
                list.add(DatabaseMetadata.PRG_START_COL);
                list.add(DatabaseMetadata.PRG_END_ROW);
                list.add(DatabaseMetadata.PRG_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
            }
        };
    }

    public DDCLDictionaryDescriptor(DDCLDictionaryUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_DDCL_DICTIONARY_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.state.getData().put("allow multiple project selection in project list", false);
        this.state.getData().put("show project selection list", false);
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DDCLDictionaryTreeProvider(this);
    }

    public String getId() {
        return MAINFRAME_DDCL_DICTIONARY_USAGE;
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new DDCLDictionaryFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.DDCL_DICTIONARY_HEADER_INFO;
        return res;
    }

    @Override
    public String getFileName() {
        return DDCL_DICTIONARY_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    public boolean hasReorderResultsAction() {
        return true;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_ELEMENT_NAME, DatabaseMetadata.DDCL_ELEMENT_NAME_USED.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_ELEMENT, DatabaseMetadata.USED_IN_ELEMENT_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_PROPERTY_NAME, DatabaseMetadata.USED_IN_DDCL_PROPERTY_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_TYPE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_PROPERTY_SOURCE_INFO, DatabaseMetadata.USED_IN_DDCL_PROPERTY_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DDCL_DICTIONARY_TABLE_CSV_HEADER;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                String ddclElementCountTest = " AND (@ddclElemName =''%'' OR EXISTS (SELECT * FROM #temporaryDdcls WHERE " + DDCL_ELEMENT_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                String programCountTest = " AND (@Program=''%'' OR EXISTS (SELECT * FROM #temporaryPrograms WHERE " + PROGRAM_CONDITIONS + "@@@@ADDITIONAL_DENSE_RANK_EQUALITY_CONDITIONS@@@@" + "))";
                this.put(ResultElementType.DDCL_ELEMENT_NAME.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.DDCL_ELEMENT_NAME_USED.getName()).limitParamName(" @ddclElemLimit ").create());
                DenseRankDescriptorAdapter.DenseRankStatement denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.PRG_NAME.getName()).tempTableName(DDCLDictionaryDescriptor.PROGRAM_CACHE_TABLE).additionalCacheTableCondition(" usedInElementName is null ").additionalCondition(" usedInElementName is null ").limitParamName("@ProgramLimit").additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(ddclElementCountTest){
                    {
                        this.put(ResultElementType.DDCL_ELEMENT.name(), string);
                    }
                }).create();
                this.put(ResultElementType.PROGRAM.name(), denseRankStatement);
                denseRankStatement = new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.USED_IN_ELEMENT_NAME.getName()).tempTableName(DDCLDictionaryDescriptor.DDCL_CACHE_TABLE).additionalCacheTableCondition(" ProgramName is null ").additionalCondition(" ProgramName is null ").limitParamName("@ddclElemLimit1").additionalGroupDependencies((Map<String, String>)new HashMap<String, String>(programCountTest){
                    {
                        this.put(ResultElementType.PROGRAM.name(), string);
                    }
                }).create();
                this.put(ResultElementType.DDCL_ELEMENT.name(), denseRankStatement);
            }
        };
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DDCL_ELEMENT_NAME.name(), " (@usedDdclElemName = ''%'' or usedName " + DDCL_ELEM_NAME_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), "((@Program = ''%'' or " + PROGRAM_CONDITIONS + ") and usedInElementName is null " + "@@@@GROUP_CONDITIONS@@@@" + ")");
            spWhereClause.put(ResultElementType.DDCL_ELEMENT.name(), "((@ddclElemName = ''%'' or " + DDCL_ELEMENT_CONDITIONS + ") and ProgramName is null " + "@@@@GROUP_CONDITIONS@@@@" + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DDCL_ELEMENT_NAME.name(), " @ddclElemLimit INT, @usedDdclElemName VARCHAR(64)");
            spParam.put(ResultElementType.DDCL_ELEMENT.name(), " @ddclElemLimit1 INT, @ddclElemName VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), "@ProgramLimit INT, @Program VARCHAR(255)");
        }
        return spParam;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DDCL_Dictionary";
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DDCL_Dictionary_Usage";
    }

    @Override
    public boolean hasAnnotationsFilterAction() {
        return true;
    }
}

