/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.ddcl.callgraph.nodes.AMBaseNode;
import com.ez.ddcl.callgraph.nodes.AMNodesFactory;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class DDCLTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DDCLTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        ArrayList<ResultElementType> levelsOrderWithProp = new ArrayList<ResultElementType>(levelsOrder);
        levelsOrderWithProp.add(ResultElementType.DDCL_PROPERTY_NAME);
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        DDCLCallback callback = new DDCLCallback(root, levelsOrderWithProp, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return true;
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        HashSet<ResultElementType> ret = new HashSet<ResultElementType>();
        ret.add(ResultElementType.DDCL_ELEMENT_NAME);
        return ret;
    }

    class DDCLCallback
    extends AbstractProcessRowCallback {
        public DDCLCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex < this.levelsOrder.size()) {
                ResultElement resultElement;
                ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                if (levelElementType.equals((Object)ResultElementType.DDCL_PROPERTY_NAME) && name.isEmpty()) break;
                parent.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), r.getColumnValue(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName()));
                String key = name;
                if (levelElementType.equals((Object)ResultElementType.DDCL_ELEMENT_NAME)) {
                    Integer ddclElemId = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEM_ID.getName());
                    key = String.valueOf(name) + ddclElemId;
                }
                ResultElement resultElement2 = resultElement = levelElementType.equals((Object)ResultElementType.DDCL_PROPERTY_NAME) ? null : parent.getChild(key);
                if (resultElement == null) {
                    resultElement = new ResultElement(name, levelElementType, parent);
                    this.addElementInfo(resultElement, r);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    parent.addChild(key, resultElement);
                }
                DDCLTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                parent = resultElement;
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            String DDCLPROGRAMTYPE = String.valueOf(14);
            switch (resultElement.getType()) {
                case DDCL_ELEMENT_NAME: {
                    AMBaseNode ddclNode;
                    String ddclPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_PATH.getName()));
                    Integer ddclStartRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_START_ROW.getName());
                    Integer ddclStartCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_START_COL.getName());
                    Integer ddclEndRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_END_ROW.getName());
                    Integer ddclEndCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_END_COL.getName());
                    Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, ddclPath, ddclStartRow, ddclStartCol, ddclEndRow, ddclEndCol);
                    Integer typeID = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), typeID);
                    Integer elemID = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEM_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_ID.getName(), elemID);
                    resultElement.addProperty(DatabaseMetadata.DDCL_ELEM_NAME.getName(), r.getColumnValue(DatabaseMetadata.DDCL_ELEM_NAME.getName()));
                    GenericProgramRelatedNode prgNodeElem = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DDCL_ELEMENT_NAME.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeElem);
                    Integer isIDMSXInt = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName());
                    if (isIDMSXInt != null && isIDMSXInt.equals(1)) {
                        resultElement.addProperty("Is IDMSX Key", Boolean.TRUE);
                    }
                    if ((ddclNode = AMNodesFactory.createNode((Integer)typeID, (String)resultElement.getName(), (Integer)elemID)) == null) break;
                    ddclNode.addProperty("create date", r.getColumnValue(DatabaseMetadata.DDCL_CREATE_DATE.getName()));
                    ddclNode.addProperty("update date", r.getColumnValue(DatabaseMetadata.DDCL_UPDATE_DATE.getName()));
                    resultElement.addProperty("Application_Master_Node", ddclNode);
                    break;
                }
                case DDCL_PROPERTY_NAME: {
                    String pPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_PATH.getName()));
                    GenericProgramRelatedNode prgNodeProp = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DDCL_PROPERTY_NAME.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeProp);
                    Integer pStartRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName());
                    Integer pStartCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_START_COL.getName());
                    Integer pEndRow = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName());
                    Integer pEndCol = (Integer)r.getColumnValue(DatabaseMetadata.DDCL_PROPERTY_END_COL.getName());
                    Utils.setFileAttribute(resultElement, DDCLPROGRAMTYPE, pPath, pStartRow, pStartCol, pEndRow, pEndCol);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

