/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class DDCLFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public DDCLFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.canSkipFilterEntry = false;
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "DDCLInventoryElemLimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY, defaultPatterns, limit);
        e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
        e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
        e.put("incontext", "  ");
        e.put("entry has button and a drop-down list of values", Boolean.toString(true));
        String defComboValue = e.get(FilterEntry.ATTR_FILTER);
        if (defComboValue.isEmpty()) {
            e.put("value from combo", "any");
            e.put(FilterEntry.ATTR_FILTER, Messages.getString(DDCLFilter.class, "any.text"));
        } else {
            e.put("value from combo", defaultPatterns.get(ResultElementType.DDCL_ELEMENT_TYPE_ID).toString());
        }
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.DDCL_ELEMENT_NAME, defaultPatterns, limit);
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamName", "@ddclElemName");
        e.put(DatabaseMetadata.DDCL_ELEM_NAME.getName(), DatabaseMetadata.DDCL_ELEM_NAME.getName());
        e.put(DatabaseMetadata.DDCL_ELEM_ID.getName(), DatabaseMetadata.DDCL_ELEM_ID.getName());
        e.put(DatabaseMetadata.DDCL_CREATE_DATE.getName(), DatabaseMetadata.DDCL_CREATE_DATE.getName());
        e.put(DatabaseMetadata.DDCL_UPDATE_DATE.getName(), DatabaseMetadata.DDCL_UPDATE_DATE.getName());
        e.put(DatabaseMetadata.DDCL_PATH.getName(), DatabaseMetadata.DDCL_PATH.getName());
        e.put(DatabaseMetadata.DDCL_START_ROW.getName(), DatabaseMetadata.DDCL_START_ROW.getName());
        e.put(DatabaseMetadata.DDCL_END_ROW.getName(), DatabaseMetadata.DDCL_END_ROW.getName());
        e.put(DatabaseMetadata.DDCL_START_COL.getName(), DatabaseMetadata.DDCL_START_COL.getName());
        e.put(DatabaseMetadata.DDCL_END_COL.getName(), DatabaseMetadata.DDCL_END_COL.getName());
        e.put(DatabaseMetadata.DDCL_ELEM_TYPE_DESCRIPTION.getName(), DatabaseMetadata.DDCL_ELEM_TYPE_DESCRIPTION.getName());
        e.put(DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName(), DatabaseMetadata.DDCL_ELEM_TYPE_ID.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_NAME.getName(), DatabaseMetadata.DDCL_PROPERTY_NAME.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_ID.getName(), DatabaseMetadata.DDCL_PROPERTY_ID.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_PATH.getName(), DatabaseMetadata.DDCL_PROPERTY_PATH.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName(), DatabaseMetadata.DDCL_PROPERTY_START_ROW.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName(), DatabaseMetadata.DDCL_PROPERTY_END_ROW.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_START_COL.getName(), DatabaseMetadata.DDCL_PROPERTY_START_COL.getName());
        e.put(DatabaseMetadata.DDCL_PROPERTY_END_COL.getName(), DatabaseMetadata.DDCL_PROPERTY_END_COL.getName());
        e.put(DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName(), DatabaseMetadata.DDCL_ELEM_IS_IDMSX.getName());
        e.put("incontext", Messages.getString(DDCLFilter.class, "inContext.project.label"));
        this.entries.add(e);
    }
}

