/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.ddcl.DDCLFilter;
import com.ez.analysis.mainframe.usage.ddcl.DDCLTreeProvider;
import com.ez.analysis.mainframe.usage.ddcl.DDCLUsageAnalysis;
import com.ez.analysis.mainframe.usage.ddcl.State;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZAMNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSRecord;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSSet;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCLDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DDCLDescriptor.class);
    public static final String MAINFRAME_DDCL_USAGE = "com.ez.analysis.mainframe.usage.ddcl";
    private static final String DDCL_USAGE_FILTERS_FILE_NAME = "DDCLUsageFilters.properties";
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;
    protected LinkedHashMap<String, String> typesMap;
    public static final String ALL_TYPES = "any";
    public static final Map<String, List<ColumnInfo>> DDCL_TABLE_CSV_HEADER;

    static {
        DDCL_TABLE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.DDCL_ELEMENT_NAME.name(), list);
                list.add(DatabaseMetadata.DDCL_ELEM_NAME);
                list.add(DatabaseMetadata.DDCL_ELEM_ID);
                list.add(DatabaseMetadata.DDCL_CREATE_DATE);
                list.add(DatabaseMetadata.DDCL_UPDATE_DATE);
                list.add(DatabaseMetadata.DDCL_PATH);
                list.add(DatabaseMetadata.DDCL_START_ROW);
                list.add(DatabaseMetadata.DDCL_ELEM_TYPE_DESCRIPTION);
                list.add(DatabaseMetadata.DDCL_PROPERTY_NAME);
                list.add(DatabaseMetadata.DDCL_PROPERTY_ID);
                list.add(DatabaseMetadata.DDCL_PROPERTY_PATH);
                list.add(DatabaseMetadata.DDCL_PROPERTY_START_ROW);
                ArrayList arrayList = new ArrayList();
            }
        };
    }

    public DDCLDescriptor(DDCLUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_DDCL_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.typesMap == null) {
            List inputProjects = (List)this.state.getData().get("PROJECT_LIST");
            this.setAllTypesRestrictionList(inputProjects);
        }
        this.state.getData().put("all types that restrict the search", this.typesMap);
        this.state.getData().put("allow multiple project selection in project list", false);
        this.state.getData().put("show project selection list", false);
    }

    private void setAllTypesRestrictionList(List<ProjectInfo> prjsList) {
        this.typesMap = new LinkedHashMap();
        this.typesMap.put(ALL_TYPES, Messages.getString(DDCLDescriptor.class, "any.type"));
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        for (ProjectInfo pi : prjsList) {
            IMFProjectHandler ph = service.getProjectHandler(pi.getName(), null);
            try {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                        try {
                            String[][] types = conn.executeSQL("select id, Name from dDCLDDsType where id > 0 order by Name");
                            if (types != null) {
                                String[][] stringArray = types;
                                int n = types.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String[] cols = stringArray[n2];
                                    DDCLDescriptor.this.typesMap.put(cols[0], cols[1]);
                                    ++n2;
                                }
                            }
                        }
                        catch (Throwable t) {
                            L.error("could not get element types", t);
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                L.error("", (Throwable)e);
            }
            catch (Exception e) {
                L.error("error at executing of report", (Throwable)e);
            }
        }
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DDCLTreeProvider(this);
    }

    public String getId() {
        return MAINFRAME_DDCL_USAGE;
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        if (objTypes != null) {
            HashSet<Integer> types = new HashSet<Integer>();
            for (EZObjectType objType : objTypes) {
                if (objType instanceof EZAMNode) {
                    EZEntityID entity = objType.getEntID();
                    if (entity == null || entity.getSegment(EZSourceDDCLElementIDSg.class) == null) continue;
                    EZSourceDDCLElementIDSg sg = (EZSourceDDCLElementIDSg)entity.getSegment(EZSourceDDCLElementIDSg.class);
                    types.add(sg.getType());
                    continue;
                }
                if (objType instanceof EZSourceIDMSRecord) {
                    types.add(3);
                    continue;
                }
                if (!(objType instanceof EZSourceIDMSSet)) continue;
                types.add(10);
            }
            if (types.size() == 1) {
                ArrayList<ProjectInfo> inputProjects = (ArrayList<ProjectInfo>)this.state.getData().get("PROJECT_LIST");
                if (inputProjects == null) {
                    inputProjects = new ArrayList<ProjectInfo>();
                    for (EZObjectType objType : objTypes) {
                        ProjectInfo pi = (ProjectInfo)objType.getProperty("PROJECT_INFO");
                        if (pi == null) {
                            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)objType.getEntID().getSegment(EZSourceProjectIDSg.class);
                            pi = prjSg.getProjectInfo();
                        }
                        if (pi == null || inputProjects.contains(pi)) continue;
                        inputProjects.add(pi);
                    }
                }
                this.setAllTypesRestrictionList((List<ProjectInfo>)inputProjects);
                String ddclElemType = String.valueOf(types.iterator().next());
                String typeName = this.typesMap.get(ddclElemType);
                defaultPatterns.put(ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY, new StringBuilder(typeName));
                defaultPatterns.put(ResultElementType.DDCL_ELEMENT_TYPE_ID, new StringBuilder(ddclElemType));
            }
        }
        return new DDCLFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.DDCL_HEADER_INFO;
        return res;
    }

    @Override
    public String getFileName() {
        return DDCL_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    public boolean hasReorderResultsAction() {
        return true;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_ELEMENT_NAME, DatabaseMetadata.DDCL_ELEM_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY, DatabaseMetadata.DDCL_ELEM_TYPE_DESCRIPTION.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.DDCL_PROPERTY_NAME, DatabaseMetadata.DDCL_PROPERTY_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DDCL_TABLE_CSV_HEADER;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.DDCL_ELEMENT_NAME.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DatabaseMetadata.DDCL_ELEM_NAME.getName().concat(",").concat(DatabaseMetadata.DDCL_ELEM_ID.getName())).limitParamName(" @ddclElemLimit ").create());
            }
        };
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DDCL_ELEMENT_NAME.name(), " (@ddclElemName = ''%'' or DDCLElemName " + DDCL_ELEM_NAME_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY.name(), " ((@ddclElemType = ''any'') OR (DdsTypeId like @ddclElemType)) ");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DDCL_ELEMENT_NAME.name(), " @ddclElemLimit INT, @ddclElemName VARCHAR(64)");
            spParam.put(ResultElementType.DDCL_ELEMENT_TYPE_CATEGORY.name(), " @ddclElemType VARCHAR(64)");
        }
        return spParam;
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DDCL";
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DDCL_Dictionary_Elements";
    }

    @Override
    public boolean hasAnnotationsFilterAction() {
        return false;
    }
}

