/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.ddcl;

import com.ez.analysis.mainframe.usage.UsageAnalysisFilter;
import com.ez.internal.analysis.config.inputs.EZAMNode;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSRecord;
import com.ez.internal.analysis.config.inputs.EZSourceIDMSSet;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.Collection;
import java.util.HashSet;

public class DDCLAnalysisFilter
extends UsageAnalysisFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public boolean checkProjectCount(Collection inputs) {
        boolean ret = false;
        HashSet<String> projects = new HashSet<String>();
        for (Object inpObj : inputs) {
            EZObjectType objType = (EZObjectType)inpObj;
            EZEntityID entity = objType.getEntID();
            EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class);
            projects.add(prjIdSg.getProjectName());
        }
        ret = projects.size() == 1;
        return ret;
    }

    @Override
    protected boolean isAcceptedInput(Object inpObj, Collection<Object> inputs) {
        return inpObj instanceof EZAMNode || inpObj instanceof EZSourceIDMSRecord || inpObj instanceof EZSourceIDMSSet;
    }
}

