/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dbi;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class DBITreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DBITreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return null;
    }

    class MyCallback
    extends AbstractProcessRowCallback {
        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElement resultElement;
                    Integer id;
                    String name;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String key = name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (levelElementType.equals((Object)ResultElementType.PROGRAM) && (id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName())) != null) {
                        key = id.toString().concat(name);
                    }
                    if ((resultElement = parent.getChild(key)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    DBITreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case PROGRAM: {
                    Integer id = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                    resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    resultElement.addProperty("Ancestor Name", r.getColumnValue(DatabaseMetadata.PRG_ANCESTOR.getName()));
                    String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_PATH.getName()));
                    resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
                    Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_ROW.getName());
                    Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_START_COL.getName());
                    Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_ROW.getName());
                    Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.PRG_END_COL.getName());
                    String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                    String programName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
                    ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case STMT_SOURCE_INFO: {
                    Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
                    resultElement.addProperty("Program Type Id", programTypeId);
                    String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
                    resultElement.addProperty(DatabaseMetadata.STMT_PATH_STR.getName(), stmtPath);
                    String stmtDescr = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_DESC.getName()));
                    String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
                    resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtDescr, prgType));
                    Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
                    resultElement.addProperty("Stmt Start Row", startRow);
                    String dbiPattern = (String)r.getColumnValue(DatabaseMetadata.DBI_PATTERN.getName());
                    resultElement.addProperty("Stmt DBI Access", dbiPattern);
                    Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
                    Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_ROW.getName());
                    Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.STMT_END_COL.getName());
                    Utils.setFileAttribute(resultElement, programTypeId.toString(), stmtPath, startRow, startCol, endRow, endCol);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    break;
                }
                case DBI_TABLE: {
                    resultElement.addProperty(DatabaseMetadata.RESOURCE_ID.getName(), r.getColumnValue(DatabaseMetadata.RESOURCE_ID.getName()));
                    GenericProgramRelatedNode prgNodeIDMS = new GenericProgramRelatedNode(resultElement.getName(), ResultElementType.DBI_TABLE.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", prgNodeIDMS);
                }
            }
        }
    }
}

