/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dbi;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class DBIFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;

    public DBIFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "DBIUsageDBILimit", 0);
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.DBI_TABLE, defaultPatterns, limit);
        this.addColumnsForDBI(e);
        e.put("DynamicProcParamName", "@DBI");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DBIUsageProgramLimit", 0);
        e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, limit);
        e.put("must search aliases", Boolean.toString(true));
        this.addColumnsForProgram(e);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        e.put("DynamicProcParamNameSecond", "@Ancestor");
        this.entries.add(e);
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "DBIUsageStmtTypeLimit", 0);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, limit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        e.setValidator(3, limitValidator);
        this.addColumnsForStmt(e);
        this.entries.add(e);
    }

    private void addColumnsForProgram(FilterEntry e) {
        e.put(DatabaseMetadata.PRG_ID.getName(), DatabaseMetadata.PRG_ID.getName());
        e.put(DatabaseMetadata.PRG_NAME.getName(), DatabaseMetadata.PRG_NAME.getName());
        e.put(DatabaseMetadata.PRG_PATH.getName(), DatabaseMetadata.PRG_PATH.getName());
        e.put(DatabaseMetadata.PRG_START_ROW.getName(), DatabaseMetadata.PRG_START_ROW.getName());
        e.put(DatabaseMetadata.PRG_START_COL.getName(), DatabaseMetadata.PRG_START_COL.getName());
        e.put(DatabaseMetadata.PRG_END_ROW.getName(), DatabaseMetadata.PRG_END_ROW.getName());
        e.put(DatabaseMetadata.PRG_END_COL.getName(), DatabaseMetadata.PRG_END_COL.getName());
        this.addMandatoryColumns(e);
        e.put(DatabaseMetadata.PRG_ANCESTOR.getName(), DatabaseMetadata.PRG_ANCESTOR.getName());
    }

    private void addColumnsForDBI(FilterEntry e) {
        e.put(DatabaseMetadata.RESOURCE_ID.getName(), DatabaseMetadata.RESOURCE_ID.getName());
        e.put(DatabaseMetadata.RESOURCE_NAME.getName(), DatabaseMetadata.RESOURCE_NAME.getName());
        e.put(DatabaseMetadata.RESOURCE_OCCURID.getName(), DatabaseMetadata.RESOURCE_OCCURID.getName());
        this.addMandatoryColumns(e);
    }
}

