/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dbi;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.dbi.DBIFilter;
import com.ez.analysis.mainframe.usage.dbi.DBITreeProvider;
import com.ez.analysis.mainframe.usage.dbi.DBIUsageAnalysis;
import com.ez.analysis.mainframe.usage.dbi.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBIDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DBI_PARAM_LIMIT = "@DBILimit";
    private static final String DBI_COLUMN = DatabaseMetadata.RESOURCE_NAME.getName();
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM = "@StatementType";
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    public static final String MAINFRAME_DBI_USAGE = "com.ez.analysis.mainframe.usage.dbi";
    private static final String DBI_USAGE_FILTERS_FILE_NAME = "DBIUsageFilters.properties";
    private static final String DBI_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DBI_TABLE, new String[0]);
    public static final Map<String, List<ColumnInfo>> DBI_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.DBI_TABLE.name(), list);
            list.add(DatabaseMetadata.RESOURCE_ID);
            list.add(DatabaseMetadata.RESOURCE_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_PATH_STR);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public DBIDescriptor(DBIUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_DBI_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DBITreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new DBIFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.DBI_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DBI";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DBI_TABLE.name(), " @DBILimit INT, @DBI VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DBI_TABLE.name(), " (@DBI = ''%'' or " + DBI_COLUMN + " " + DBI_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " ((@Program = ''%'' or " + PROGRAM_COLUMN + " " + PROGRAM_LIKE_OR_IN_MARKER + ")" + " AND (" + "@Ancestor" + " = ''%'' or " + ANCESTOR_NAME_COLUMN + " " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or Description like @StatementType)");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.DBI_TABLE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DBI_COLUMN).limitParamName(" @DBILimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_TYPE_COLUMN).limitParamName(" @StatementTypeLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return DBI_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DBI_TABLE, DBI_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_TYPE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DBI_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DBI";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

