/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.dal;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.all.ProgramWithAncestorFilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.dal.DALFilter;
import com.ez.analysis.mainframe.usage.dal.DALTreeProvider;
import com.ez.analysis.mainframe.usage.dal.DALUsageAnalysis;
import com.ez.analysis.mainframe.usage.dal.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DALDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DAL_PARAM_LIMIT = "@DALLimit";
    private static final String DAL_COLUMN = DatabaseMetadata.RESOURCE_NAME.getName();
    private static final String PROGRAM_PARAM = "@Program";
    private static final String PROGRAM_PARAM_LIMIT = "@ProgramLimit";
    private static final String PROGRAM_COLUMN = DatabaseMetadata.PRG_NAME.getName();
    private static final String ANCESTOR_NAME_COLUMN = DatabaseMetadata.PRG_ANCESTOR.getName();
    private static final String STATEMENT_TYPE_PARAM_LIMIT = "@StatementTypeLimit";
    private static final String STATEMENT_TYPE_COLUMN = DatabaseMetadata.STMT_DESC.getName();
    public static final String MAINFRAME_DAL_USAGE = "com.ez.analysis.mainframe.usage.dal";
    private static final String DAL_USAGE_FILTERS_FILE_NAME = "DALUsageFilters.properties";
    private static final String DAL_LIKE_OR_IN_MARKER = FilterData.getResElemTypeMarker(ResultElementType.DAL, new String[0]);
    public static final Map<String, List<ColumnInfo>> DAL_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.DAL.name(), list);
            list.add(DatabaseMetadata.RESOURCE_ID);
            list.add(DatabaseMetadata.RESOURCE_NAME);
            list = new ArrayList();
            this.put(ResultElementType.STMT_TYPE.name(), list);
            list.add(DatabaseMetadata.STMT_DESC);
            list.add(DatabaseMetadata.STMT_PATH_STR);
            list.add(DatabaseMetadata.STMT_START_ROW);
            list.add(DatabaseMetadata.STMT_START_COL);
            list.add(DatabaseMetadata.STMT_END_ROW);
            list.add(DatabaseMetadata.STMT_END_COL);
            list = new ArrayList();
            this.put(ResultElementType.PROGRAM.name(), list);
            list.add(DatabaseMetadata.PRG_ID);
            list.add(DatabaseMetadata.PRG_NAME);
            list.add(DatabaseMetadata.PRG_TYPE_ID);
            list.add(DatabaseMetadata.PRG_PATH);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public DALDescriptor(DALUsageAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_DAL_USAGE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new DALTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new DALFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.DAL_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_DAL";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.DAL.name(), " @DALLimit INT, @DAL VARCHAR(64)");
            spParam.put(ResultElementType.PROGRAM.name(), " @ProgramLimit INT, @Program VARCHAR(255), @Ancestor VARCHAR(255)");
            spParam.put(ResultElementType.STMT_TYPE.name(), " @StatementTypeLimit INT, @StatementType VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.DAL.name(), " (@DAL = ''%'' or UPPER(" + DAL_COLUMN + ") " + DAL_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.PROGRAM.name(), " ((@Program = ''%'' or UPPER(" + PROGRAM_COLUMN + ") " + PROGRAM_LIKE_OR_IN_MARKER + ")" + " AND (" + "@Ancestor" + " = ''%'' or " + "UPPER(" + ANCESTOR_NAME_COLUMN + ") " + ANCESTOR_LIKE_OR_IN_MARKER + "))");
            spWhereClause.put(ResultElementType.STMT_TYPE.name(), " (@StatementType = ''%'' or UPPER(Description) " + STATEMENT_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.DAL.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(DAL_COLUMN).limitParamName(" @DALLimit ").create());
                this.put(ResultElementType.PROGRAM.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(PROGRAM_COLUMN).limitParamName(" @ProgramLimit ").create());
                this.put(ResultElementType.STMT_TYPE.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(STATEMENT_TYPE_COLUMN).limitParamName(" @StatementTypeLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return DAL_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.DAL, DAL_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, STATEMENT_TYPE_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, PROGRAM_COLUMN);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return DAL_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "DAL";
    }

    @Override
    protected Map<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap() {
        HashMap<String, FilterEntryParameterGenerator> getFilterEntryParameterGeneratorMap = new HashMap<String, FilterEntryParameterGenerator>();
        getFilterEntryParameterGeneratorMap.put(ResultElementType.PROGRAM.name(), new ProgramWithAncestorFilterEntryParameterGenerator());
        return getFilterEntryParameterGeneratorMap;
    }
}

