/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.controlm;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.UsageDescriptorAdapter;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.ResultsTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ControlMTreeProvider
extends ResultsTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ControlMTreeProvider(UsageDescriptorAdapter descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        ControlMCallback callback = new ControlMCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isTreeLevelOrderSameAsFiltersOrder() {
        return this.defaultIsTreeLevelOrderSameAsFiltersOrder();
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    class ControlMCallback
    extends AbstractProcessRowCallback {
        Map<Integer, ResultElement> segmentsMap;

        public ControlMCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.segmentsMap = new HashMap<Integer, ResultElement>();
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex < this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    String key;
                    ResultElement resultElement;
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (elemNameColumn.equals(DatabaseMetadata.CTRLM_APPLICATION.getName()) && ((String)r.getColumnValue(elemNameColumn)).isEmpty()) {
                        name = "N/A";
                    }
                    if ((resultElement = parent.getChild(key = name)) == null) {
                        resultElement = new ResultElement(name, levelElementType, parent);
                        this.addElementInfo(resultElement, r);
                        Utils.completeProjectInfo(resultElement, projectInfo);
                        parent.addChild(key, resultElement);
                    }
                    ControlMTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                    parent = resultElement;
                } else if (levelIndex == this.levelsOrder.size()) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.CTRLM_JOB);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.CTRLM_JOB, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }

        private ResultElement getOrCretateChild(Row r, ResultElement parent, ProjectInfo projectInfo, ResultElementType levelElementType, String name) {
            ResultElement resultElement = parent.getChild(name);
            if (resultElement == null) {
                resultElement = new ResultElement(name, levelElementType, parent);
                this.addElementInfo(resultElement, r);
                Utils.completeProjectInfo(resultElement, projectInfo);
                parent.addChild(name, resultElement);
            }
            return resultElement;
        }

        private void addElementInfo(ResultElement resultElement, Row r) {
            switch (resultElement.getType()) {
                case CTRLM_APPLICATION: {
                    String application = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_APPLICATION.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_APPLICATION.getName(), application);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    GenericProgramRelatedNode nodeApp = new GenericProgramRelatedNode(application, ResultElementType.CTRLM_APPLICATION.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", nodeApp);
                    break;
                }
                case CTRLM_FOLDER: {
                    String folder = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_FOLDER.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_FOLDER.getName(), folder);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    GenericProgramRelatedNode nodeFolder = new GenericProgramRelatedNode(folder, ResultElementType.CTRLM_FOLDER.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", nodeFolder);
                    break;
                }
                case CTRLM_JOB: {
                    String job = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_JOB.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_JOB.getName(), job);
                    String jobId = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_JOB_ID.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_JOB_ID.getName(), jobId);
                    String jclJobId = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JCL_JOB_ID.getName()));
                    if (jclJobId != null && !jclJobId.isEmpty()) {
                        resultElement.addProperty(DatabaseMetadata.JCL_JOB_ID.getName(), jclJobId);
                        String jclJobName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.JCL_JOB_NAME.getName()));
                        resultElement.addProperty(DatabaseMetadata.JCL_JOB_NAME.getName(), jclJobName);
                        String ctrlmJobMemberName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_JOB_MEMBER_NAME.getName()));
                        resultElement.addProperty(DatabaseMetadata.CTRLM_JOB_MEMBER_NAME.getName(), ctrlmJobMemberName);
                    }
                    String f = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_FOLDER.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_FOLDER.getName(), f);
                    String applicationName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CTRLM_APPLICATION.getName()));
                    resultElement.addProperty(DatabaseMetadata.CTRLM_APPLICATION.getName(), applicationName);
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                    GenericProgramRelatedNode node = new GenericProgramRelatedNode(job, ResultElementType.CTRLM_JOB.getDisplayName());
                    resultElement.addProperty("Node_Mainframe", node);
                    break;
                }
                case PROJECT_INFO: {
                    resultElement.addProperty("ProjectInfo", r.getProjectInfo());
                }
            }
        }
    }
}

