/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.controlm;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.Map;

public class ControlMFilter
extends FilterData {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final int DEFAULT_LIMIT_VALUE = 50;
    private static final String MATCHING_ALL_FILTERS_BELOW = Messages.getString(ControlMFilter.class, "matchingAllFilters.label");

    public ControlMFilter(Map<ResultElementType, StringBuilder> defaultPatterns) {
        this.addFilterEntries(defaultPatterns);
    }

    private void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns) {
        int limit = 50;
        this.entries = new ArrayList();
        FilterEntry e = this.makeFilterEntry(ResultElementType.CTRLM_APPLICATION, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@CtrlmApplication");
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(50, null, 0, "ControlmUsageApplicationLimit", 0);
        e.setValidator(3, limitValidator);
        this.addColumnsForControlM(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.CTRLM_FOLDER, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@CtrlmFolder");
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "ControlmUsageFolderLimit", 0);
        e.setValidator(3, limitValidator);
        this.addColumnsForControlM(e);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.CTRLM_JOB, defaultPatterns, limit);
        e.put("DynamicProcParamName", "@CtrlmJob");
        limitValidator = new IntRangePreferenceValidator(50, null, 0, "ControlmUsageJobLimit", 0);
        e.setValidator(3, limitValidator);
        this.addColumnsForControlM(e);
        this.entries.add(e);
    }

    private void addColumnsForControlM(FilterEntry e) {
        e.put(DatabaseMetadata.CTRLM_APPLICATION.getName(), DatabaseMetadata.CTRLM_APPLICATION.getName());
        e.put(DatabaseMetadata.CTRLM_FOLDER.getName(), DatabaseMetadata.CTRLM_FOLDER.getName());
        e.put(DatabaseMetadata.CTRLM_JOB.getName(), DatabaseMetadata.CTRLM_JOB.getName());
        e.put(DatabaseMetadata.CTRLM_JOB_ID.getName(), DatabaseMetadata.CTRLM_JOB_ID.getName());
        e.put(DatabaseMetadata.JCL_JOB_ID.getName(), DatabaseMetadata.JCL_JOB_ID.getName());
        e.put(DatabaseMetadata.JCL_JOB_NAME.getName(), DatabaseMetadata.JCL_JOB_NAME.getName());
        e.put(DatabaseMetadata.CTRLM_JOB_MEMBER_NAME.getName(), DatabaseMetadata.CTRLM_JOB_MEMBER_NAME.getName());
    }
}

