/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.controlm;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.controlm.ControlMAnalysis;
import com.ez.analysis.mainframe.usage.controlm.ControlMFilter;
import com.ez.analysis.mainframe.usage.controlm.ControlMTreeProvider;
import com.ez.analysis.mainframe.usage.controlm.State;
import com.ez.analysis.mainframe.usage.queries.AbstractQueryBuilder;
import com.ez.analysis.mainframe.usage.rank.DenseRankDescriptorAdapter;
import com.ez.analysis.mainframe.usage.rank.DenseRankQueryBuilder;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlMDescriptor
extends DenseRankDescriptorAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ControlMDescriptor.class);
    private static final String JOB_NAME = DatabaseMetadata.CTRLM_JOB.getName();
    private static final String APPLICATION_NAME = DatabaseMetadata.CTRLM_APPLICATION.getName();
    private static final String FOLDER_NAME = DatabaseMetadata.CTRLM_FOLDER.getName();
    protected static final String CTRLM_PARAMETER_NAME = "@Ctrlm";
    protected static final String JOB_PARAMETER_NAME = "@CtrlmJob";
    protected static final String APPLICATION_PARAMETER_NAME = "@CtrlmApplication";
    protected static final String FOLDER_PARAMETER_NAME = "@CtrlmFolder";
    public static final String MAINFRAME_CTRLM_STRUCTURE = "com.ez.analysis.mainframe.usage.controlm";
    private static final String CTRLM_USAGE_FILTERS_FILE_NAME = "CtrlMStructureFilters.properties";
    public static final Map<String, List<ColumnInfo>> CTRLM_STRUCTURE_CSV_HEADER = new HashMap<String, List<ColumnInfo>>(){
        {
            ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
            this.put(ResultElementType.PROJECT_INFO.name(), list);
            list.add(DatabaseMetadata.PROJECT_NAME);
            list = new ArrayList();
            this.put(ResultElementType.CTRLM_APPLICATION.name(), list);
            list.add(DatabaseMetadata.CTRLM_APPLICATION);
            list.add(DatabaseMetadata.CTRLM_FOLDER);
            list.add(DatabaseMetadata.CTRLM_JOB);
        }
    };
    private static Map<String, String> spParam;
    private static Map<String, String> spWhereClause;

    public ControlMDescriptor(ControlMAnalysis analysis) {
        super(analysis.getType());
        this.id = MAINFRAME_CTRLM_STRUCTURE;
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new ControlMTreeProvider(this);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, new ResultElementType[0]);
        return new ControlMFilter(defaultPatterns.isEmpty() ? null : defaultPatterns);
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        return DatabaseMetadata.CTRLM_HEADER_INFO;
    }

    @Override
    public String getDatabaseViewName() {
        return "EZViewer_Usage_CTM";
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (spParam == null) {
            L.debug("adding filter parameters");
            spParam = new HashMap<String, String>();
            spParam.put(ResultElementType.CTRLM_JOB.name(), " @JobLimit INT, @CtrlmJob VARCHAR(64)");
            spParam.put(ResultElementType.CTRLM_APPLICATION.name(), " @ApplicationLimit INT, @CtrlmApplication VARCHAR(64)");
            spParam.put(ResultElementType.CTRLM_FOLDER.name(), " @FolderLimit INT, @CtrlmFolder VARCHAR(64) ");
        }
        return spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (spWhereClause == null) {
            spWhereClause = new HashMap<String, String>();
            spWhereClause.put(ResultElementType.CTRLM_JOB.name(), " (@CtrlmJob = ''%'' or UPPER(" + JOB_NAME + ") " + CTRLM_JOB_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.CTRLM_APPLICATION.name(), " (@CtrlmApplication = ''%'' or UPPER(" + APPLICATION_NAME + ") " + CTRLM_APPLICATION_LIKE_OR_IN_MARKER + ")");
            spWhereClause.put(ResultElementType.CTRLM_FOLDER.name(), " (@CtrlmFolder = ''%'' or UPPER(" + FOLDER_NAME + ") " + CTRLM_FOLDER_LIKE_OR_IN_MARKER + ")");
        }
        return spWhereClause;
    }

    @Override
    public Map<String, DenseRankDescriptorAdapter.DenseRankStatement> getStoredProcedureDenseRankStatements() {
        return new HashMap<String, DenseRankDescriptorAdapter.DenseRankStatement>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ResultElementType.CTRLM_JOB.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(JOB_NAME).limitParamName(" @JobLimit ").create());
                this.put(ResultElementType.CTRLM_APPLICATION.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(APPLICATION_NAME).limitParamName(" @ApplicationLimit ").create());
                this.put(ResultElementType.CTRLM_FOLDER.name(), new DenseRankDescriptorAdapter.DenseRankStatement.Builder().tableColumnName(FOLDER_NAME).limitParamName(" @FolderLimit ").create());
            }
        };
    }

    @Override
    public String getFileName() {
        return CTRLM_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.CTRLM_JOB, JOB_NAME);
        this.elemTypeToElemNameColumns.put(ResultElementType.CTRLM_APPLICATION, APPLICATION_NAME);
        this.elemTypeToElemNameColumns.put(ResultElementType.CTRLM_FOLDER, FOLDER_NAME);
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    protected AbstractQueryBuilder getQueryBuilder() {
        return new DenseRankQueryBuilder();
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        return CTRLM_STRUCTURE_CSV_HEADER;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "ControlM_Structure";
    }

    @Override
    public boolean hasReorderResultsAction() {
        return false;
    }

    @Override
    public boolean hasAnnotationsFilterAction() {
        return false;
    }
}

