/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assemblervar;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.AbstractProcessRowCallback;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.assemblervar.AssemblerVarDescriptor;
import com.ez.analysis.mainframe.usage.internal.Messages;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.ProgramVarTreeProvider;
import com.ez.analysis.mainframe.usage.ui.RecordsetProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.cobol.callgraph.nodes.VariableUsageNode;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.mainframe.model.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class AssemblerVarTreeProvider
extends ProgramVarTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String VAR_TYPE_ID_DSECT = "20";

    public AssemblerVarTreeProvider(AssemblerVarDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public void buildResultsTree(ResultElement root, RecordsetProvider rsProvider, IProgressMonitor monitor) {
        Map<ResultElementType, String> elemTypeToElemNameColumnsMap = this.descriptor.getElemTypeToElemNameColumnsMap();
        List<ResultElementType> levelsOrder = this.getLevelsOrder();
        MyCallback callback = new MyCallback(root, levelsOrder, elemTypeToElemNameColumnsMap);
        rsProvider.load(callback, monitor);
    }

    @Override
    protected boolean isElementValidForCreation(String elementName, ResultElementType levelElementType, Row r) {
        Integer programTypeId;
        boolean result;
        boolean bl = result = !elementName.isEmpty();
        if (levelElementType.equals((Object)ResultElementType.ASSEMBLER_CSECT) && (programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName())) == 16) {
            result = false;
        }
        if (levelElementType.equals((Object)ResultElementType.ASSEMBLER_ENTRY) && (programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName())) == 15) {
            result = false;
        }
        return result;
    }

    @Override
    protected ResultElement processVariable(Map<String, ResultElement> variablesMap, Row r, ResultElement parent, String name, ProjectInfo projectInfo) {
        Integer varID;
        String projectName = projectInfo.getName();
        String varKey = Utils.getKeyForVariable(projectName, varID = (Integer)r.getColumnValue(DatabaseMetadata.VAR_ID.getName()));
        ResultElement resultElement = variablesMap.get(varKey);
        if (resultElement == null) {
            Integer varLevel = (Integer)r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName());
            Integer headFather = (Integer)r.getColumnValue(DatabaseMetadata.VAR_Father.getName());
            ResultElement varParent = variablesMap.get(Utils.getKeyForVariable(projectName, headFather));
            if (varParent != null && headFather != 0) {
                parent = varParent;
            } else {
                String varTypeId = (String)r.getColumnValue(DatabaseMetadata.VAR_TYPE_ID.getName());
                parent = this.getVarSubcategory(varTypeId, parent);
            }
            resultElement = new ResultElement(name, ResultElementType.VARIABLE, parent);
            variablesMap.put(varKey, resultElement);
            resultElement.addProperty(DatabaseMetadata.VAR_iLevel.getName(), varLevel);
            resultElement.addProperty(DatabaseMetadata.VAR_ID.getName(), varID);
            String key = varID.toString().toString().concat(name);
            parent.addChild(key, resultElement);
            this.addElementInfo(resultElement, r);
            Utils.completeProjectInfo(resultElement, projectInfo);
        }
        return resultElement;
    }

    @Override
    protected boolean hasLevelCategory(ResultElementType levelElementType) {
        return levelElementType.equals((Object)ResultElementType.STMT_TYPE) || levelElementType.equals((Object)ResultElementType.VARIABLE) || levelElementType.equals((Object)ResultElementType.ASSEMBLER_CSECT) || levelElementType.equals((Object)ResultElementType.ASSEMBLER_ENTRY);
    }

    @Override
    protected void addElementInfo(ResultElement resultElement, Row r) {
        if (resultElement.getProperty("FILE") != null || resultElement.getProperty("ProjectInfo") != null) {
            return;
        }
        super.addElementInfo(resultElement, r);
        ResultElementType type = resultElement.getType();
        if (ResultElementType.ASSEMBLER_CSECT.equals((Object)type) || ResultElementType.ASSEMBLER_ENTRY.equals((Object)type)) {
            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_ID.getName());
            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName());
            resultElement.addProperty("Program Type Id", programTypeId);
            String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CHILD_PRG_PATH.getName()));
            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
            String programName = (String)r.getColumnValue(DatabaseMetadata.CHILD_PRG_NAME.getName());
            Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_ROW.getName());
            Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_COL.getName());
            Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_ROW.getName());
            Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_COL.getName());
            String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
            resultElement.addProperty("Ancestor Name", ancestorName);
            Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
            resultElement.addProperty("Ancestor Id", ancestorId);
            String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
            ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
            Utils.setFileAttribute(resultElement, String.valueOf(programTypeId), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.VARIABLE.equals((Object)type)) {
            String varName = (String)r.getColumnValue(DatabaseMetadata.VAR_NAME.getName());
            String varPic = (String)r.getColumnValue(DatabaseMetadata.VAR_PIC.getName());
            Integer varLevel = (Integer)r.getColumnValue(DatabaseMetadata.VAR_iLevel.getName());
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.VAR_START_ROW.getName());
            String ancestor = (String)r.getColumnValue(DatabaseMetadata.VAR_Ancestor_Name.getName());
            String father = (String)r.getColumnValue(DatabaseMetadata.VAR_Father_Name.getName());
            String isFiller = (String)r.getColumnValue(DatabaseMetadata.VAR_IsFiller.getName());
            resultElement.addProperty("Node_Mainframe", new VariableUsageNode(varName, (Object)varPic, (Object)varLevel, (Object)startRow, (Object)ancestor, (Object)father, (Object)isFiller));
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)type)) {
            String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
            String stmtTypeName = (String)r.getColumnValue(DatabaseMetadata.STMT_DESC.getName());
            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
            String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
            resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtTypeName, prgType));
        }
    }

    private ResultElement getVarSubcategory(String varTypeId, ResultElement parent) {
        ResultElement subcategoryResultElement;
        ResultElementType subcategoryType = ResultElementType.LOCAL_SUBCATEGORY;
        if (VAR_TYPE_ID_DSECT.equalsIgnoreCase(varTypeId)) {
            subcategoryType = ResultElementType.DSECT_SUBCATEGORY;
        }
        if ((subcategoryResultElement = parent.getChild(subcategoryType.name())) == null) {
            subcategoryResultElement = new ResultElement(subcategoryType.getDisplayName(), subcategoryType, parent);
            parent.addChild(subcategoryType.name(), subcategoryResultElement);
        }
        return subcategoryResultElement;
    }

    @Override
    protected void addSpecificElementInfo(ResultElement resultElement, Row r) {
    }

    @Override
    protected Set<ResultElementType> getLevelsWithCategoriesAndLimit() {
        return new HashSet<ResultElementType>();
    }

    protected class MyCallback
    extends AbstractProcessRowCallback {
        Map<String, ResultElement> variablesMap;
        private boolean displayStmt;

        public MyCallback(ResultElement root, List<ResultElementType> levelsOrder, Map<ResultElementType, String> elemTypeToElemNameColumnsMap) {
            super(root, levelsOrder, elemTypeToElemNameColumnsMap);
            this.variablesMap = new HashMap<String, ResultElement>();
            this.displayStmt = true;
        }

        public void setDisplayStmt(boolean displayStmt) {
            this.displayStmt = displayStmt;
        }

        @Override
        public boolean processRow(Row r, int rowIndex, IProgressMonitor monitor) {
            ResultElement parent = this.root;
            ProjectInfo projectInfo = r.getProjectInfo();
            int levelIndex = 0;
            while (levelIndex <= this.levelsOrder.size()) {
                if (levelIndex < this.levelsOrder.size()) {
                    ResultElementType levelElementType = (ResultElementType)this.levelsOrder.get(levelIndex);
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(levelElementType);
                    String name = Utils.null2empty(ResultElementType.PROJECT_INFO.name().equals(elemNameColumn) ? projectInfo.getName() : r.getColumnValue(elemNameColumn));
                    if (AssemblerVarTreeProvider.this.isElementValidForCreation(name, levelElementType, r)) {
                        String key = name;
                        if (levelElementType.equals((Object)ResultElementType.PROGRAM)) {
                            String projectName = projectInfo.getName();
                            Integer prgID = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
                            key = String.valueOf(key) + "|" + projectName + "|" + prgID;
                        }
                        if (AssemblerVarTreeProvider.this.hasLevelCategory(levelElementType)) {
                            String categoryName = null;
                            if (levelElementType.equals((Object)ResultElementType.STMT_TYPE)) {
                                Integer bRead = (Integer)r.getColumnValue(DatabaseMetadata.STMT_bREAD.getName());
                                categoryName = Messages.getString(AssemblerVarTreeProvider.class, "read.category.name");
                                if (bRead == 0 || bRead == 2) {
                                    categoryName = Messages.getString(AssemblerVarTreeProvider.class, "write.category.name");
                                }
                            }
                            if (!levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                                parent = Utils.getCategory(levelElementType, parent, categoryName);
                            }
                        }
                        ResultElement resultElement = null;
                        if (levelElementType.equals((Object)ResultElementType.VARIABLE)) {
                            resultElement = AssemblerVarTreeProvider.this.processVariable(this.variablesMap, r, parent, name, projectInfo);
                        } else {
                            resultElement = parent.getChild(key);
                            if (resultElement == null) {
                                resultElement = new ResultElement(name, levelElementType, parent);
                                AssemblerVarTreeProvider.this.addElementInfo(resultElement, r);
                                parent.addChild(key, resultElement);
                                Utils.completeProjectInfo(resultElement, projectInfo);
                            }
                        }
                        AssemblerVarTreeProvider.this.checkLimitReached(levelElementType, this.root, parent);
                        parent = resultElement;
                    }
                } else if (this.displayStmt && levelIndex == this.levelsOrder.size() && r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName()) != null) {
                    String elemNameColumn = (String)this.elemTypeToElemNameColumnsMap.get(ResultElementType.STMT_SOURCE_INFO);
                    String prgName = Utils.null2empty(r.getColumnValue(elemNameColumn));
                    ResultElement resultElement = new ResultElement(prgName, ResultElementType.STMT_SOURCE_INFO, parent);
                    Utils.completeProjectInfo(resultElement, projectInfo);
                    AssemblerVarTreeProvider.this.addElementInfo(resultElement, r);
                    parent.addChild(resultElement.getDisplayName(), resultElement);
                }
                ++levelIndex;
            }
            return true;
        }
    }
}

