/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assemblervar;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.programs.ProgramVarFilter;
import com.ez.analysis.mainframe.usage.ui.StmtDialogTextCellEditor;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.Map;

public class AssemblerVarFilter
extends ProgramVarFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public AssemblerVarFilter(Map<ResultElementType, StringBuilder> defaultPatterns, int programTypeId) {
        super(defaultPatterns, programTypeId);
    }

    @Override
    protected String getProgramLimitPrefStoreKey() {
        return "AssemblerVarUsageProgramLimit";
    }

    @Override
    protected void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns, Integer defaultLimit) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(10, null, 0, this.getProgramLimitPrefStoreKey(), 0);
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.addFilterEntryInfoProgram(e);
        e = this.makeFilterEntry(ResultElementType.ASSEMBLER_CSECT, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@CSECTName");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.ASSEMBLER_ENTRY, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@ENTRYName");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.VARIABLE, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@VarName");
        this.addFilterEntryInfoVariable(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.STMT_TYPE, defaultPatterns, defaultLimit);
        e.put("entry is a text field and opens a dialog for the list of values", Boolean.toString(true));
        e.put("DynamicProcParamName", "@StatementType");
        this.addColumnsForStmt(e);
        e.put(FilterEntry.ENTRY_ATTRIBUTES[2], StmtDialogTextCellEditor.DEFAULT_ALLSTMT);
        this.entries.add(e);
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        super.makeFilterEntrySettings(e, type);
        if (ResultElementType.ASSEMBLER_CSECT.equals((Object)type) || ResultElementType.ASSEMBLER_ENTRY.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            e.put("incontext", "  ");
        }
    }

    @Override
    protected void addFilterEntryInfoProgram(FilterEntry e) {
        super.addFilterEntryInfoProgram(e);
        e.put(DatabaseMetadata.CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.CHILD_PRG_NAME.getName(), "Programs_Children.ProgramName");
        e.put(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName(), "Programs_Children.ProgramTypeID");
        e.put(DatabaseMetadata.CHILD_PRG_START_ROW.getName(), "Occurrences_PrgChildren.StartRow");
        e.put(DatabaseMetadata.CHILD_PRG_START_COL.getName(), "Occurrences_PrgChildren.StartCol");
        e.put(DatabaseMetadata.CHILD_PRG_END_ROW.getName(), "Occurrences_PrgChildren.EndRow");
        e.put(DatabaseMetadata.CHILD_PRG_END_COL.getName(), "Occurrences_PrgChildren.EndCol");
        e.put(DatabaseMetadata.CHILD_PRG_PATH.getName(), "Paths_PrgChildren.PathStr");
    }

    @Override
    protected void addFilterEntryInfoSpecificUsageElem(FilterEntry e) {
    }

    @Override
    protected void addFilterEntryInfoVariable(FilterEntry e) {
        e.put(DatabaseMetadata.ASSM_CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "StatementReference.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "StatementReference.StartCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "Paths_Stmt.PathStr");
        e.put(DatabaseMetadata.VAR_ID.getName(), "Variables.VarID");
        e.put(DatabaseMetadata.VAR_NAME.getName(), "Variables.VarName");
        e.put(DatabaseMetadata.VAR_iLevel.getName(), "Variables.iLevel");
        e.put(DatabaseMetadata.VAR_PIC.getName(), "Variables.PIC");
        e.put(DatabaseMetadata.VAR_IsField.getName(), "Variables.IsField");
        e.put(DatabaseMetadata.VAR_IsFiller.getName(), "Variables.IsFiller");
        e.put(DatabaseMetadata.VAR_TYPE_ID.getName(), "Variables.type");
        e.put(DatabaseMetadata.VAR_PRG_REF_ID.getName(), "Variables.ProgIDReference");
        e.put(DatabaseMetadata.VAR_TYPE_DESCRIPTION.getName(), "VarTypes.Description");
        e.put(DatabaseMetadata.VAR_Father.getName(), "Variables.Father");
        e.put(DatabaseMetadata.VAR_ANCESTOR.getName(), "Variables.Ancestor");
        e.put(DatabaseMetadata.VAR_Father_Name.getName(), "father.VarName");
        e.put(DatabaseMetadata.VAR_Ancestor_Name.getName(), "ancestor.VarName");
        e.put(DatabaseMetadata.VAR_IS_COPY.getName(), "Variables.IsCopy");
        e.put(DatabaseMetadata.VAR_START_ROW.getName(), "Occurrences_Var.StartRow");
        e.put(DatabaseMetadata.VAR_START_COL.getName(), "Occurrences_Var.StartCol");
        e.put(DatabaseMetadata.VAR_END_ROW.getName(), "Occurrences_Var.EndRow");
        e.put(DatabaseMetadata.VAR_END_COL.getName(), "Occurrences_Var.EndCol");
        e.put(DatabaseMetadata.VAR_PATH_STR.getName(), "Paths_Var.PathStr");
        e.put(DatabaseMetadata.STMT_bREAD.getName(), "StatementReference.bRead");
        e.put(DatabaseMetadata.STMT_DESC.getName(), "Statements.Description");
    }
}

