/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assemblervar;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.assembler.AssemblerDescriptor;
import com.ez.analysis.mainframe.usage.assemblervar.AssemblerVarFilter;
import com.ez.analysis.mainframe.usage.assemblervar.AssemblerVarTreeProvider;
import com.ez.analysis.mainframe.usage.assemblervar.State;
import com.ez.analysis.mainframe.usage.programs.ProgramVarDescriptor;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssemblerVarDescriptor
extends ProgramVarDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String MAINFRAME_ASSEMBLER_VAR_USAGE = "com.ez.analysis.mainframe.usage.assemblervar";
    private static final String ASSEMBLER_VAR_USAGE_FILTERS_FILE_NAME = "AssemblerVariableUsageFilters.properties";
    private Map<String, String> spParam;
    private Map<String, String> spSelectProgramIds;
    private Map<String, String> spWhereClause;
    private Map<String, String> spDetails;
    private Map<String, String> spOrderBy;

    public AssemblerVarDescriptor(AbstractAnalysis analysis) {
        super(analysis);
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new AssemblerVarTreeProvider(this);
    }

    @Override
    protected void initializeCSVSuffixes() {
        this.csvFileSuffixMap = new HashMap();
        ArrayList<ResultElementType> list = new ArrayList<ResultElementType>();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.ASSEMBLER_CSECT);
        list.add(ResultElementType.ASSEMBLER_ENTRY);
        list.add(ResultElementType.VARIABLE);
        list.add(ResultElementType.STMT_TYPE);
        this.csvFileSuffixMap.put(ResultElementType.VARIABLE, new Pair((Object)"", list));
    }

    public String getId() {
        return MAINFRAME_ASSEMBLER_VAR_USAGE;
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, true, new ResultElementType[0]);
        AssemblerVarFilter af = new AssemblerVarFilter(defaultPatterns.isEmpty() ? null : defaultPatterns, this.getProgramTypeId());
        return af;
    }

    @Override
    protected int getProgramTypeId() {
        return 8;
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.ASSEMBLER_VAR_HEADER_INFO;
        return res;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.spParam == null) {
            this.spParam = new HashMap<String, String>();
            this.spParam.put(ResultElementType.VARIABLE.name(), " @_VarName VARCHAR(64)");
            this.spParam.put(ResultElementType.PROGRAM.name(), "@_PrgTypeID INT, @_PrgLimit INT, @_Program VARCHAR(255)");
            this.spParam.put(ResultElementType.ASSEMBLER_CSECT.name(), " @_CSECTName VARCHAR(255)");
            this.spParam.put(ResultElementType.ASSEMBLER_ENTRY.name(), " @_ENTRYName VARCHAR(255)");
            this.spParam.put(ResultElementType.STMT_TYPE.name(), "@_StatementType VARCHAR(64) ");
        }
        return this.spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureSelectProgramIDs() {
        this.spSelectProgramIds = new HashMap<String, String>();
        String from_where = "@@@@@EZLEGACY@@@@\nWHERE ENTRY1.ProgramId = ENTRY2.ProgramId \n\tAND ENTRY2.ProgramId = ENTRY3.ProgramID \n\tAND ENTRY3.ProgramId = ENTRY4.ProgramID \n\tAND ENTRY4.ProgramId = ENTRY5.ProgramID \nORDER BY ENTRY1.ProgramName ";
        this.spSelectProgramIds.put(ResultElementType.PROGRAM.name(), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID, row_number() over(ORDER BY ENTRY1.ProgramID) as row_num  \nFROM " + from_where + "\n ) q where row_num <= @PrgLimit");
        this.spSelectProgramIds.put("query_unlimited".concat(ResultElementType.PROGRAM.name()), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID \nFROM " + from_where + "\n ) q");
        this.spSelectProgramIds.put(ResultElementType.ASSEMBLER_CSECT.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #tempcsect \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #nocsect\n\t) AS ENTRY");
        this.spSelectProgramIds.put(ResultElementType.ASSEMBLER_ENTRY.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #tempentry \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #noentry\n\t) AS ENTRY");
        this.spSelectProgramIds.put(ResultElementType.VARIABLE.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #varUsage \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #novars\n\t) AS ENTRY");
        return this.spSelectProgramIds;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.spWhereClause == null) {
            this.spWhereClause = new HashMap<String, String>();
            this.spWhereClause.put(ResultElementType.VARIABLE.name(), "SELECT_OR_INSERT_INTO #varUsageALLByProgramParam \tSELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName, Variables.VarName " + AssemblerDescriptor.PROG_INNER + "\n\t\t\t\tAND Programs_Children.ProgramTypeID IN (15,16) " + "\n\t\tINNER JOIN Variables ON Programs_Children.ProgramID = Variables.ProgIDReference " + "\n\tWHERE (p.OccurID <> 0)\t " + "\n\t\tAND (p.ProgramTypeID = @PrgTypeID) " + "\n\t\tAND (UPPER(p.ProgramName) " + PROGRAM_LIKE_OR_IN_MARKER + ")" + "\n) as varsALL " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#varUsage " + "SELECT_MARKER" + "\nFROM ( " + "\nSELECT distinct ProgramID, ProgramName " + "\n\tFROM #varUsageALLByProgramParam " + "\n\tWHERE (UPPER(VarName) " + VARIABLE_LIKE_OR_IN_MARKER + ") " + "\n) as varsUsg " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#novars " + "SELECT_MARKER" + "\n\tFROM ( " + "\n\t\tSELECT p.ProgramID, p.ProgramName " + AssemblerDescriptor.PROG_ANCESTOR + "\n\t\t\tWHERE p.ProgramID NOT IN ( SELECT DISTINCT ProgramID " + "\n\t\t\t\t\tFROM #varUsageALLByProgramParam ) " + "\n\t\t\tAND (p.OccurID <> 0) " + "\n\t\t\tAND (p.ProgramTypeID = @PrgTypeID) " + "\n\t\t\tAND (UPPER(p.ProgramName) " + PROGRAM_LIKE_OR_IN_MARKER + ")" + "\n\t\t\tAND (@VarName = ''%'') " + "\n) AS vars " + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.ASSEMBLER_CSECT.name(), "SELECT_OR_INSERT_INTO #tempcsect SELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + AssemblerDescriptor.PROG_INNER + "\n\tWHERE (Programs_Children.ProgramTypeID = 15) " + "\n\t\tAND (UPPER(Programs_Children.ProgramName) " + CSECT_LIKE_OR_IN_MARKER + ") " + "\n) AS tq4 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #nocsect " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, p.ProgramName " + AssemblerDescriptor.PROG_INNER + "\n\tWHERE p.ProgramID NOT IN (" + "\n\t\tSELECT DISTINCT p.ProgramID " + AssemblerDescriptor.PROG_INNER + "\n\t\tWHERE (Programs_Children.ProgramTypeID = 15) " + "\n\t) " + "\n\tAND (Programs_Children.ProgramTypeID = 16) " + "\n\tAND @CSECTName = ''%'' " + "\n) AS csect " + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.ASSEMBLER_ENTRY.name(), "SELECT_OR_INSERT_INTO #tempentry SELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + AssemblerDescriptor.PROG_INNER + "\n\tWHERE (Programs_Children.ProgramTypeID = 16) " + "\n\t\tAND (UPPER(Programs_Children.ProgramName) " + ENTRY_LIKE_OR_IN_MARKER + ") " + "\n) AS tq5 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #noentry " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, p.ProgramName " + AssemblerDescriptor.PROG_INNER + "\n\tWHERE p.ProgramID NOT IN (" + "\n\t\tSELECT DISTINCT p.ProgramID " + AssemblerDescriptor.PROG_INNER + "\n\t\tWHERE (Programs_Children.ProgramTypeID = 16) " + "\n\t) " + "\n\tAND (Programs_Children.ProgramTypeID = 15) " + "\n\tAND @ENTRYName = ''%'' " + "\n) AS entry " + "@@@@@EZLEGACY@@@@");
        }
        return this.spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureDetailsSelect() {
        if (this.spDetails == null) {
            this.spDetails = new HashMap<String, String>();
            this.spDetails.put(ResultElementType.PROGRAM.name(), "\n SELECT @@@@@EZLEGACY@@@@" + AssemblerDescriptor.PROG_INNER + "\n\t\t\tAND Programs_Children.ProgramTypeID IN (15,16) " + "\n\t\tINNER JOIN Occurrences AS Occurrences_Prg ON Occurrences_Prg.OccurID = p.OccurID " + "\n\t\tINNER JOIN Paths AS Paths_Prg ON Occurrences_Prg.PathID = Paths_Prg.PathID " + "\n\t\tINNER JOIN Occurrences AS Occurrences_PrgChildren ON Occurrences_PrgChildren.OccurID = Programs_Children.OccurID " + "\n\t\tINNER JOIN Paths AS Paths_PrgChildren ON Occurrences_PrgChildren.PathID = Paths_PrgChildren.PathID " + " left join (\n" + " select * from ( " + "@@@@@EZLEGACY@@@@" + " ) AS det\n" + " ) as m ON m.AssmChildProgramId = Programs_Children.ProgramID " + "\n WHERE p.ProgramID in (select * from #tempids) ");
            this.spDetails.put(ResultElementType.VARIABLE.name(), "\n \tFROM StatementReference \n\t\tINNER JOIN OccurrencesStmt ON StatementReference.OccurID = OccurrencesStmt.OccurID \n\t\tINNER JOIN Statements ON OccurrencesStmt.StatementType = Statements.StatementType \n\t\tINNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID \n\t\tRIGHT JOIN Variables ON StatementReference.ResourceID = Variables.VarID \n\t\t\tAND StatementReference.ResourceType = 4 \n\t\tLEFT JOIN VarTypes ON Variables.Type = VarTypes.VarType \n\t\tINNER JOIN Occurrences AS Occurrences_Var ON Variables.OccurID = Occurrences_Var.OccurID \n\t\tINNER JOIN Paths AS Paths_Var ON Occurrences_Var.PathID = Paths_Var.PathID \n       INNER JOIN Variables AS father ON father.VarID = Variables.Father\n       INNER JOIN Variables AS ancestor ON ancestor.VarID = Variables.Ancestor\n\t\tINNER JOIN (SELECT tp.ProgramId, ProgramTypeID, AliasName as ProgramName, Ancestor FROM Programs tp \t\t\t\t\t\t\tINNER JOIN ProgramAliases tpa on tpa.ProgramId = tp.ProgramId and tpa.AliasType = 0) AS Programs_Children ON Variables.ProgIDReference = Programs_Children.ProgramID \n\t\t\tAND Programs_Children.ProgramTypeID IN (15,16) \n\t\tINNER JOIN (SELECT tp.ProgramId, ProgramTypeID, AliasName as ProgramName, Ancestor FROM Programs tp \t\t\t\t\t\tINNER JOIN ProgramAliases tpa on tpa.ProgramId = tp.ProgramId) p ON Programs_Children.Ancestor = p.ProgramName \n\tWHERE p.ProgramID IN (SELECT * FROM #tempids)  \n AND (@VarName = ''%''  OR  UPPER(Variables.VarName) " + VARIABLE_LIKE_OR_IN_MARKER + ")");
        }
        return this.spDetails;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.spOrderBy == null) {
            this.spOrderBy = super.getStoredProcedureOrderBy();
            this.spOrderBy.put(ResultElementType.ASSEMBLER_CSECT.name(), "ChildProgramName");
        }
        return this.spOrderBy;
    }

    @Override
    public String getFileName() {
        return ASSEMBLER_VAR_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.ASSEMBLER_CSECT, DatabaseMetadata.CHILD_PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.ASSEMBLER_ENTRY, DatabaseMetadata.CHILD_PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.VARIABLE, DatabaseMetadata.VAR_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        HashMap<String, List<ColumnInfo>> csvHeader = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_NAME);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.ASSEMBLER_CSECT.name(), list);
                list.add(DatabaseMetadata.CHILD_PRG_ID);
                list.add(DatabaseMetadata.CHILD_PRG_NAME);
                list.add(DatabaseMetadata.CHILD_PRG_TYPE_ID);
                list.add(DatabaseMetadata.CHILD_PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.VARIABLE.name(), list);
                list.add(DatabaseMetadata.VAR_ID);
                list.add(DatabaseMetadata.VAR_NAME);
                list.add(DatabaseMetadata.VAR_TYPE_ID);
                list.add(DatabaseMetadata.VAR_TYPE_DESCRIPTION);
                list.add(DatabaseMetadata.VAR_IsField);
                list.add(DatabaseMetadata.VAR_IsFiller);
                list.add(DatabaseMetadata.VAR_PATH_STR);
                list.add(DatabaseMetadata.VAR_START_ROW);
                list.add(DatabaseMetadata.VAR_START_COL);
                list.add(DatabaseMetadata.VAR_END_ROW);
                list.add(DatabaseMetadata.VAR_END_COL);
            }
        };
        return csvHeader;
    }

    @Override
    public int getDefaultExpandLevel() {
        int level = 5;
        if (this.hasManyProjects()) {
            level = 6;
        }
        return level;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "AssemblerVar";
    }

    @Override
    public Map<String, ColumnInfo[]> getStoreProceduresTempTables() {
        HashMap<String, ColumnInfo[]> tempTables = new HashMap<String, ColumnInfo[]>();
        tempTables.put("#tempcsect", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#nocsect", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempentry", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#noentry", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#novars", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#varUsage", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#varUsageALLByProgramParam", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME, DatabaseMetadata.VAR_NAME});
        tempTables.put("#tempids", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        return tempTables;
    }
}

