/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assembler;

import com.ez.analysis.mainframe.db.Row;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.assembler.AssemblerDescriptor;
import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.programs.ProgramDescriptor;
import com.ez.analysis.mainframe.usage.programs.ProgramTreeProvider;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.analysis.mainframe.utils.ProgramUtils;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;

public class AssemblerTreeProvider
extends ProgramTreeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String VAR_TYPE_ID_DSECT = "20";

    public AssemblerTreeProvider(AssemblerDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected boolean isElementValidForCreation(String elementName, ResultElementType levelElementType, Row r) {
        Integer programTypeId;
        boolean result = super.isElementValidForCreation(elementName, levelElementType, r);
        if (levelElementType.equals((Object)ResultElementType.ASSEMBLER_CSECT) && (programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName())) == 16) {
            result = false;
        }
        if (levelElementType.equals((Object)ResultElementType.ASSEMBLER_ENTRY) && (programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName())) == 15) {
            result = false;
        }
        return result;
    }

    @Override
    protected boolean hasLevelCategory(ResultElementType levelElementType) {
        return levelElementType.equals((Object)ResultElementType.STMT_TYPE) || levelElementType.equals((Object)ResultElementType.INCLUDE) || levelElementType.equals((Object)((ProgramDescriptor)this.descriptor).getSpecificElementType()) || levelElementType.equals((Object)ResultElementType.ASSEMBLER_CSECT) || levelElementType.equals((Object)ResultElementType.ASSEMBLER_ENTRY);
    }

    @Override
    protected void addElementInfo(ResultElement resultElement, Row r) {
        if (resultElement.getProperty("FILE") != null || resultElement.getProperty("ProjectInfo") != null) {
            return;
        }
        super.addElementInfo(resultElement, r);
        ResultElementType type = resultElement.getType();
        if (ResultElementType.ASSEMBLER_CSECT.equals((Object)type) || ResultElementType.ASSEMBLER_ENTRY.equals((Object)type)) {
            Integer id = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_ID.getName());
            resultElement.addProperty(DatabaseMetadata.PRG_ID.getName(), id);
            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName());
            resultElement.addProperty("Program Type Id", programTypeId);
            String programPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.CHILD_PRG_PATH.getName()));
            resultElement.addProperty(DatabaseMetadata.PRG_PATH.getName(), programPath);
            String programName = (String)r.getColumnValue(DatabaseMetadata.CHILD_PRG_NAME.getName());
            Integer prgStartRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_ROW.getName());
            Integer prgStartCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_START_COL.getName());
            Integer prgEndRow = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_ROW.getName());
            Integer prgEndCol = (Integer)r.getColumnValue(DatabaseMetadata.CHILD_PRG_END_COL.getName());
            String ancestorName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.PRG_NAME.getName()));
            resultElement.addProperty("Ancestor Name", ancestorName);
            Integer ancestorId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_ID.getName());
            resultElement.addProperty("Ancestor Id", ancestorId);
            String programType = com.ez.mainframe.data.utils.Utils.getPrgType((String)String.valueOf(programTypeId));
            ProgramUtils.setPropertiesViewer(resultElement, programName, programPath, programType);
            Utils.setFileAttribute(resultElement, String.valueOf(programTypeId), programPath, prgStartRow, prgStartCol, prgEndRow, prgEndCol);
            resultElement.addProperty("ProjectInfo", r.getProjectInfo());
        } else if (ResultElementType.STMT_SOURCE_INFO.equals((Object)type)) {
            Integer programTypeId = (Integer)r.getColumnValue(DatabaseMetadata.PRG_TYPE_ID.getName());
            String stmtPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_PATH_STR.getName()));
            String stmtDescr = Utils.null2empty(r.getColumnValue(DatabaseMetadata.STMT_DESC.getName()));
            String prgType = com.ez.mainframe.data.utils.Utils.getPrgType((String)programTypeId.toString());
            Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_ROW.getName());
            resultElement.addProperty("Stmt Start Row", startRow);
            Integer cfr_ignored_0 = (Integer)r.getColumnValue(DatabaseMetadata.STMT_START_COL.getName());
            resultElement.addProperty("Node_Mainframe", new StmtSourceInfoNode(stmtPath, stmtDescr, prgType));
        } else if (ResultElementType.MACRO.equals((Object)type)) {
            String macroName = Utils.null2empty(r.getColumnValue(DatabaseMetadata.MACRO_NAME.getName()));
            resultElement.addProperty("Node_Mainframe", new GenericProgramRelatedNode(macroName, ResultElementType.MACRO.getDisplayName()));
        }
    }

    @Override
    protected void addSpecificElementInfo(ResultElement resultElement, Row r) {
        resultElement.addProperty("Program Type Id", this.programTypeId);
        String macroPath = Utils.null2empty(r.getColumnValue(DatabaseMetadata.MACRO_PATH.getName()));
        Integer startRow = (Integer)r.getColumnValue(DatabaseMetadata.MACRO_START_ROW.getName());
        Integer startCol = (Integer)r.getColumnValue(DatabaseMetadata.MACRO_START_COL.getName());
        Integer endRow = (Integer)r.getColumnValue(DatabaseMetadata.MACRO_END_ROW.getName());
        Integer endCol = (Integer)r.getColumnValue(DatabaseMetadata.MACRO_END_COL.getName());
        if (!macroPath.equalsIgnoreCase("")) {
            Utils.setFileAttribute(resultElement, String.valueOf(this.programTypeId), macroPath, startRow, startCol, endRow, endCol);
        }
    }
}

