/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assembler;

import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.analysis.mainframe.usage.model.validation.IntRangePreferenceValidator;
import com.ez.analysis.mainframe.usage.programs.ProgramFilter;
import com.ez.mainframe.data.results.ResultElementType;
import java.util.Map;

public class AssemblerFilter
extends ProgramFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public AssemblerFilter(Map<ResultElementType, StringBuilder> defaultPatterns, ResultElementType specificElementType) {
        super(defaultPatterns, specificElementType);
    }

    @Override
    protected void addFilterEntries(Map<ResultElementType, StringBuilder> defaultPatterns, Integer defaultLimit) {
        IntRangePreferenceValidator limitValidator = new IntRangePreferenceValidator(10, null, 0, this.getProgramLimitPrefStoreKey(), 0);
        FilterEntry e = this.makeFilterEntry(ResultElementType.PROGRAM, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@Program");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e.put("incontext", MATCHING_ALL_FILTERS_BELOW);
        e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
        this.addFilterEntryInfoProgram(e);
        e = this.makeFilterEntry(ResultElementType.ASSEMBLER_CSECT, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@CSECTName");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.ASSEMBLER_ENTRY, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@ENTRYName");
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(this.specificElementType, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@ParaName");
        this.addFilterEntryInfoSpecificUsageElem(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
        e = this.makeFilterEntry(ResultElementType.INCLUDE, defaultPatterns, defaultLimit);
        e.put("DynamicProcParamName", "@InclName");
        this.addFilterEntryInfoInclude(e);
        e.setValidator(3, limitValidator);
        this.entries.add(e);
    }

    @Override
    protected void makeFilterEntrySettings(FilterEntry e, ResultElementType type) {
        super.makeFilterEntrySettings(e, type);
        if (ResultElementType.ASSEMBLER_CSECT.equals((Object)type) || ResultElementType.ASSEMBLER_ENTRY.equals((Object)type)) {
            e.put("canModify".concat(FilterEntry.ATTR_LIMIT), Boolean.toString(false));
            e.put("canModify".concat(FilterEntry.ATTR_USE), Boolean.toString(false));
            e.put(FilterEntry.ENTRY_ATTRIBUTES[3], null);
            e.put("incontext", "  ");
        }
    }

    @Override
    protected void addFilterEntryInfoProgram(FilterEntry e) {
        super.addFilterEntryInfoProgram(e);
        e.put(DatabaseMetadata.CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.CHILD_PRG_NAME.getName(), "Programs_Children.ProgramName");
        e.put(DatabaseMetadata.CHILD_PRG_TYPE_ID.getName(), "Programs_Children.ProgramTypeID");
        e.put(DatabaseMetadata.CHILD_PRG_START_ROW.getName(), "Occurrences_PrgChildren.StartRow");
        e.put(DatabaseMetadata.CHILD_PRG_START_COL.getName(), "Occurrences_PrgChildren.StartCol");
        e.put(DatabaseMetadata.CHILD_PRG_END_ROW.getName(), "Occurrences_PrgChildren.EndRow");
        e.put(DatabaseMetadata.CHILD_PRG_END_COL.getName(), "Occurrences_PrgChildren.EndCol");
        e.put(DatabaseMetadata.CHILD_PRG_PATH.getName(), "Paths_PrgChildren.PathStr");
    }

    @Override
    protected void addFilterEntryInfoSpecificUsageElem(FilterEntry e) {
        e.put(DatabaseMetadata.ASSM_CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.MACRO_ID.getName(), "AssemblerMacros.ID");
        e.put(DatabaseMetadata.MACRO_NAME.getName(), "AssemblerMacros.MacroName");
        e.put(DatabaseMetadata.MACRO_START_ROW.getName(), "Occurrences_Macro.StartRow");
        e.put(DatabaseMetadata.MACRO_START_COL.getName(), "Occurrences_Macro.StartCol");
        e.put(DatabaseMetadata.MACRO_END_ROW.getName(), "Occurrences_Macro.EndRow");
        e.put(DatabaseMetadata.MACRO_END_COL.getName(), "Occurrences_Macro.EndCol");
        e.put(DatabaseMetadata.MACRO_PATH.getName(), "Paths_Macro.PathStr");
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "OccurrencesStmt.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "OccurrencesStmt.StartCol");
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), "OccurrencesStmt.EndRow");
        e.put(DatabaseMetadata.STMT_END_COL.getName(), "OccurrencesStmt.EndCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "Paths_Stmt.PathStr");
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        e.put(DatabaseMetadata.STMT_bREAD.getName(), DatabaseMetadata.STMT_bREAD.getName());
    }

    @Override
    protected void addFilterEntryInfoInclude(FilterEntry e) {
        e.put(DatabaseMetadata.ASSM_CHILD_PRG_ID.getName(), "Programs_Children.ProgramID");
        e.put(DatabaseMetadata.STMT_START_ROW.getName(), "OccurrencesStmt.StartRow");
        e.put(DatabaseMetadata.STMT_START_COL.getName(), "OccurrencesStmt.StartCol");
        e.put(DatabaseMetadata.STMT_END_ROW.getName(), "OccurrencesStmt.EndRow");
        e.put(DatabaseMetadata.STMT_END_COL.getName(), "OccurrencesStmt.EndCol");
        e.put(DatabaseMetadata.STMT_PATH_STR.getName(), "Paths_Stmt.PathStr");
        e.put(DatabaseMetadata.INCLUDE_NAME.getName(), "Resources.Name");
        e.put(DatabaseMetadata.INCLUDE_START_ROW.getName(), "Occurrences_Incl.StartRow");
        e.put(DatabaseMetadata.INCLUDE_START_COL.getName(), "Occurrences_Incl.StartCol");
        e.put(DatabaseMetadata.INCLUDE_END_ROW.getName(), "Occurrences_Incl.EndRow");
        e.put(DatabaseMetadata.INCLUDE_END_COL.getName(), "Occurrences_Incl.EndCol");
        e.put(DatabaseMetadata.INCLUDE_RESOURCE_PATH_ID.getName(), "Occurrences_Incl.PathID");
        e.put(DatabaseMetadata.INCLUDE_PATH.getName(), "CASE Paths_Incl.PathStr\tWHEN Resources.Name THEN NULL ELSE Paths_Incl.PathStr END");
        e.put(DatabaseMetadata.STMT_DESC.getName(), DatabaseMetadata.STMT_DESC.getName());
        e.put(DatabaseMetadata.STMT_bREAD.getName(), DatabaseMetadata.STMT_bREAD.getName());
    }

    @Override
    protected int getProgramTypeId() {
        return 8;
    }

    @Override
    protected String getProgramLimitPrefStoreKey() {
        return "AssemblerUsageProgramLimit";
    }
}

