/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.assembler;

import com.ez.analysis.mainframe.db.ColumnInfo;
import com.ez.analysis.mainframe.db.RowHeaderInfo;
import com.ez.analysis.mainframe.usage.UsageAction;
import com.ez.analysis.mainframe.usage.adapters.CsvExportDescriptor;
import com.ez.analysis.mainframe.usage.adapters.DatabaseMetadata;
import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.UsageStateAdapter;
import com.ez.analysis.mainframe.usage.assembler.AssemblerFilter;
import com.ez.analysis.mainframe.usage.assembler.AssemblerTreeProvider;
import com.ez.analysis.mainframe.usage.assembler.State;
import com.ez.analysis.mainframe.usage.programs.ProgramDescriptor;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.MapFilter;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssemblerDescriptor
extends ProgramDescriptor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String MAINFRAME_ASSEMBLER_USAGE = "com.ez.analysis.mainframe.usage.assembler";
    private static final String ASSEMBLER_USAGE_FILTERS_FILE_NAME = "AssemblerUsageFilters.properties";
    private Map<String, String> spDetails;
    private Map<String, String> spOrderBy;
    private Map<String, String> spParam;
    private Map<String, String> spSelectProgramIds;
    private Map<String, String> spWhereClause;
    public static final String PROG_ANCESTOR = "\n \tFROM (SELECT OccurId, tp.ProgramId, AliasName as ProgramName, ProgramTypeID FROM Programs tp \n INNER JOIN ProgramAliases tp1 ON tp.ProgramId = tp1.ProgramId \n and tp1.AliasType = 0 AND tp.OccurID <> 0 AND tp.ProgramTypeID = @PrgTypeID\n\tWHERE (UPPER(AliasName) " + PROGRAM_LIKE_OR_IN_MARKER + ")" + ") p ";
    public static final String PROG_INNER = String.valueOf(PROG_ANCESTOR) + "\n\t\tINNER JOIN (SELECT DISTINCT OccurId, tp.ProgramId, AliasName as ProgramName, ProgramTypeID, Ancestor FROM Programs tp " + "\t\t\t\tINNER JOIN ProgramAliases tp1 ON tp1.ProgramId = tp.ProgramId and tp1.AliasType = 0" + "\n \t\t\tWHERE tp.ProgramTypeID IN (15,16) " + "\n ) AS Programs_Children ON p.ProgramName = Programs_Children.Ancestor ";

    public AssemblerDescriptor(AbstractAnalysis analysis) {
        super(analysis);
        this.action = new UsageAction(this);
        this.state = new State();
    }

    @Override
    protected void initTreeProvider() {
        this.resultsTreeProvider = new AssemblerTreeProvider(this);
    }

    public String getId() {
        return MAINFRAME_ASSEMBLER_USAGE;
    }

    @Override
    protected void initializeCsvExportDescriptor() {
        HashMap<ResultElementType, MapFilter<ColumnInfo, Object>> csvFilterMap = new HashMap<ResultElementType, MapFilter<ColumnInfo, Object>>();
        MapFilter includeFilter = MapFilter.AndMapFilter.createFilter((MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.INCLUDE_NAME), (MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.INCLUDE_PATH));
        csvFilterMap.put(ResultElementType.INCLUDE, includeFilter);
        MapFilter specificElementTypeFilter = MapFilter.AndMapFilter.createFilter((MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.MACRO_NAME), (MapFilter)MapFilter.EmptyStringMapFilter.createFilter((Object)DatabaseMetadata.MACRO_PATH));
        csvFilterMap.put(ResultElementType.MACRO, specificElementTypeFilter);
        this.csvExportDescriptor = new CsvExportDescriptor(csvFilterMap, null);
    }

    @Override
    protected void initializeCSVSuffixes() {
        this.csvFileSuffixMap = new HashMap();
        ArrayList<ResultElementType> list = new ArrayList<ResultElementType>();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.ASSEMBLER_CSECT);
        list.add(ResultElementType.INCLUDE);
        this.csvFileSuffixMap.put(ResultElementType.INCLUDE, new Pair((Object)" - Includes", list));
        list = new ArrayList();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.ASSEMBLER_CSECT);
        ResultElementType tabSpecificElementType = this.getSpecificElementType();
        list.add(tabSpecificElementType);
        this.csvFileSuffixMap.put(tabSpecificElementType, new Pair((Object)" - ".concat(tabSpecificElementType.getDisplayName()).concat("s"), list));
        list = new ArrayList();
        list.add(ResultElementType.PROGRAM);
        list.add(ResultElementType.ASSEMBLER_CSECT);
    }

    @Override
    protected UsageStateAdapter createNewState() {
        return new State();
    }

    @Override
    protected FilterData getFilter(List<EZObjectType> objTypes) {
        Map<ResultElementType, StringBuilder> defaultPatterns = Utils.processInputs(objTypes, true, new ResultElementType[0]);
        AssemblerFilter af = new AssemblerFilter(defaultPatterns.isEmpty() ? null : defaultPatterns, this.getSpecificElementType());
        return af;
    }

    @Override
    public RowHeaderInfo getRowHeaderInfo() {
        RowHeaderInfo res = DatabaseMetadata.ASSEMBLER_HEADER_INFO;
        return res;
    }

    @Override
    public Map<String, String> getStoredProcedureParam() {
        if (this.spParam == null || !this.spParam.containsKey(this.getSpecificElementType().name())) {
            this.spParam = new HashMap<String, String>();
            this.spParam.put(ResultElementType.PROGRAM.name(), "@_PrgTypeID INT, @_PrgLimit INT, @_Program VARCHAR(255)");
            this.spParam.put(this.getSpecificElementType().name(), " @_ParaName VARCHAR(64)");
            this.spParam.put(ResultElementType.INCLUDE.name(), " @_InclName VARCHAR(64)");
            this.spParam.put(ResultElementType.ASSEMBLER_CSECT.name(), " @_CSECTName VARCHAR(255)");
            this.spParam.put(ResultElementType.ASSEMBLER_ENTRY.name(), " @_ENTRYName VARCHAR(255)");
        }
        return this.spParam;
    }

    @Override
    public Map<String, String> getStoredProcedureSelectProgramIDs() {
        this.spSelectProgramIds = new HashMap<String, String>();
        String from_where = "@@@@@EZLEGACY@@@@\nWHERE ENTRY1.ProgramId = ENTRY2.ProgramId \n\tAND ENTRY2.ProgramId = ENTRY3.ProgramID \n\tAND ENTRY3.ProgramId = ENTRY4.ProgramID \n\tAND ENTRY4.ProgramId = ENTRY5.ProgramID \nORDER BY ENTRY1.ProgramName ";
        this.spSelectProgramIds.put(ResultElementType.PROGRAM.name(), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID, row_number() over(ORDER BY ENTRY1.ProgramID) as row_num  \nFROM " + from_where + "\n ) q where row_num <= @PrgLimit");
        this.spSelectProgramIds.put("query_unlimited".concat(ResultElementType.PROGRAM.name()), "SELECT_OR_INSERT_INTO#tempidsSELECT_MARKER\nFROM (\nSELECT ENTRY1.ProgramID \nFROM " + from_where + "\n ) q");
        this.spSelectProgramIds.put(ResultElementType.ASSEMBLER_CSECT.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #tempcsect \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #nocsect\n\t) AS ENTRY");
        this.spSelectProgramIds.put(ResultElementType.ASSEMBLER_ENTRY.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #tempentry \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #noentry\n\t) AS ENTRY");
        this.spSelectProgramIds.put(this.getSpecificElementType().name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #temppara \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #nopara\n\t) AS ENTRY");
        this.spSelectProgramIds.put(ResultElementType.INCLUDE.name(), "\n\t(SELECT DISTINCT ProgramID, ProgramName FROM #tempincl \n\tUNION \n\tSELECT DISTINCT ProgramID, ProgramName FROM #noincl\n\t) AS ENTRY");
        return this.spSelectProgramIds;
    }

    @Override
    public Map<String, String> getStoredProcedureWhereClause() {
        if (this.spWhereClause == null || !this.spWhereClause.containsKey(this.getSpecificElementType().name())) {
            this.spWhereClause = new HashMap<String, String>();
            this.spWhereClause.put(this.getSpecificElementType().name(), "SELECT_OR_INSERT_INTO#temppara SELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\t\tINNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t\tINNER JOIN #sr StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n\t\tINNER JOIN AssemblerMacros ON StatementReference.ResourceID = AssemblerMacros.ID " + "\n\tWHERE (AssemblerMacros.MacroType = 2) " + "\n\t\tAND (UPPER(AssemblerMacros.MacroName) " + MACRO_LIKE_OR_IN_MARKER + ") " + "\n) AS s " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#nopara_notin " + "SELECT_MARKER" + "\nFROM ( " + "\nSELECT distinct p.ProgramID " + PROG_INNER + "\n\t    INNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t    INNER JOIN #sr StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n\t    INNER JOIN AssemblerMacros ON StatementReference.ResourceID\t= AssemblerMacros.ID " + "\n\tWHERE (AssemblerMacros.MacroType = 2) " + "\n) as qq " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#nopara " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, ProgramName " + PROG_ANCESTOR + "\n \t\tleft join #nopara_notin ni on ni.ProgramID = p.ProgramID " + "\n\tWHERE ni.ProgramID is null " + "\n\t\tAND @ParaName = ''%'' " + "\n) as q1 " + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.INCLUDE.name(), "SELECT_OR_INSERT_INTO#tempincl SELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\t\tINNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t\tINNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n\t\tINNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID " + "\n\tWHERE (StatementReference.ResourceType IN (13,57,60,67,99)) " + "\n\t\tAND (UPPER(Resources.Name) " + INCLUDE_LIKE_OR_IN_MARKER + ") " + "\n) AS tq3 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#noincl_notin " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT DISTINCT p.ProgramID " + PROG_INNER + "\n\t   INNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t   INNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n\t   INNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID " + "\n\tWHERE (StatementReference.ResourceType IN (13,57,60,67,99)) " + "\n) AS tqq " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#noincl " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, ProgramName " + PROG_ANCESTOR + "\n\t\tleft join #noincl_notin noincl_notin on noincl_notin.ProgramId = p.Programid " + "\n\twhere noincl_notin.ProgramId is null " + "\n\tAND (@InclName = ''%'') " + "\n) AS incl " + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.ASSEMBLER_CSECT.name(), "SELECT_OR_INSERT_INTO#tempcsect SELECT_MARKER\n FROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\tWHERE (Programs_Children.ProgramTypeID = 15) " + "\n\t\tAND (UPPER(Programs_Children.ProgramName) " + CSECT_LIKE_OR_IN_MARKER + ") " + "\n) AS tq4 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + "#nocsect " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\tWHERE p.ProgramID NOT IN (" + "\n\t\tSELECT DISTINCT p.ProgramID " + PROG_INNER + "\n\t\tWHERE (Programs_Children.ProgramTypeID = 15) " + "\n\t) " + "\n\tAND (Programs_Children.ProgramTypeID = 16) " + "\n\tAND @CSECTName = ''%'' " + "\n) AS csect " + "@@@@@EZLEGACY@@@@");
            this.spWhereClause.put(ResultElementType.ASSEMBLER_ENTRY.name(), "SELECT_OR_INSERT_INTO #tempentry SELECT_MARKER\nFROM ( \n\tSELECT DISTINCT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\t\tWHERE (Programs_Children.ProgramTypeID = 16) " + "\n\t\tAND (UPPER(Programs_Children.ProgramName) " + ENTRY_LIKE_OR_IN_MARKER + ") " + "\n) AS tq5 " + "@@@@@EZLEGACY@@@@" + "SELECT_OR_INSERT_INTO" + " #noentry " + "SELECT_MARKER" + "\nFROM ( " + "\n\tSELECT p.ProgramID, p.ProgramName " + PROG_INNER + "\n\tWHERE p.ProgramID NOT IN (" + "\n\t\tSELECT DISTINCT p.ProgramID " + PROG_INNER + "\n\t\tWHERE (Programs_Children.ProgramTypeID = 16) " + "\n\t) " + "\n\tAND (Programs_Children.ProgramTypeID = 15) " + "\n\tAND @ENTRYName = ''%'' " + "\n) AS entry " + "@@@@@EZLEGACY@@@@");
        }
        return this.spWhereClause;
    }

    @Override
    public Map<String, String> getStoredProcedureDetailsSelect() {
        if (this.spDetails == null || !this.spDetails.containsKey(this.getSpecificElementType().name())) {
            this.spDetails = new HashMap<String, String>();
            this.spDetails.put(ResultElementType.PROGRAM.name(), "\n SELECT @@@@@EZLEGACY@@@@" + PROG_INNER + "\n\t\tINNER JOIN Occurrences AS Occurrences_Prg ON Occurrences_Prg.OccurID = p.OccurID " + "\n\t\tINNER JOIN Paths AS Paths_Prg ON Occurrences_Prg.PathID = Paths_Prg.PathID " + "\n\t\tINNER JOIN Occurrences AS Occurrences_PrgChildren ON Occurrences_PrgChildren.OccurID = Programs_Children.OccurID " + "\n\t\tINNER JOIN Paths AS Paths_PrgChildren ON Occurrences_PrgChildren.PathID = Paths_PrgChildren.PathID " + " left join (\n" + " select * from ( " + "@@@@@EZLEGACY@@@@" + " ) AS det\n" + " ) as m ON m.AssmChildProgramId = Programs_Children.ProgramID " + "\n WHERE p.ProgramID in (select * from #tempids) ");
            this.spDetails.put(ResultElementType.INCLUDE.name(), String.valueOf(PROG_INNER) + "\n\t\tINNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t\tINNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n\t\tINNER JOIN Statements ON StatementReference.StatementType = Statements.StatementType " + "\n\t\tINNER JOIN Resources ON StatementReference.ResourceID = Resources.ResourceID " + "\n\t\tINNER JOIN Occurrences AS Occurrences_Incl ON Resources.OccurID = Occurrences_Incl.OccurID " + "\n\t\tINNER JOIN Paths AS Paths_Incl ON Occurrences_Incl.PathID = Paths_Incl.PathID " + "\n\t\tINNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID " + "\n\tWHERE (StatementReference.ResourceType IN (13,57,60,67,99)) " + "\n \tAND p.ProgramID  IN (SELECT * FROM #tempids) ");
            this.spDetails.put(this.getSpecificElementType().name(), String.valueOf(PROG_INNER) + "\n\t\tINNER JOIN OccurrencesStmt ON Programs_Children.ProgramID = OccurrencesStmt.ProgID " + "\n\t\tINNER JOIN StatementReference ON OccurrencesStmt.OccurID = StatementReference.OccurID " + "\n \t\tINNER JOIN Statements ON StatementReference.StatementType = Statements.StatementType " + "\n\t\tINNER JOIN AssemblerMacros ON StatementReference.ResourceID = AssemblerMacros.ID " + "\n\t\tLEFT JOIN Occurrences AS Occurrences_Macro ON AssemblerMacros.ID = Occurrences_Macro.ResourceID " + "\n\t\t\tAND Occurrences_Macro.ResourceType = 98 " + "\n\t\tLEFT JOIN Paths AS Paths_Macro ON Occurrences_Macro.PathID = Paths_Macro.PathID " + "\n\t\tINNER JOIN Paths AS Paths_Stmt ON OccurrencesStmt.PathID = Paths_Stmt.PathID " + "\n\tWHERE (StatementReference.StatementType = 819) " + "\n\t\tAND (StatementReference.ResourceType = 98) " + "\n\t\tAND (AssemblerMacros.MacroType = 2) " + "\n\t\tAND p.ProgramID IN (SELECT * FROM #tempids) ");
        }
        return this.spDetails;
    }

    @Override
    public Map<String, String> getStoredProcedureOrderBy() {
        if (this.spOrderBy == null || !this.spOrderBy.containsKey(this.getSpecificElementType().name())) {
            this.spOrderBy = new HashMap<String, String>();
            this.spOrderBy.put(ResultElementType.PROGRAM.name(), "ProgramName");
            this.spOrderBy.put(ResultElementType.ASSEMBLER_CSECT.name(), "ChildProgramName");
            this.spOrderBy.put(this.getSpecificElementType().name(), "MacroName");
            this.spOrderBy.put(ResultElementType.INCLUDE.name(), "IncludeName");
        }
        return this.spOrderBy;
    }

    @Override
    public String getFileName() {
        return ASSEMBLER_USAGE_FILTERS_FILE_NAME;
    }

    @Override
    protected void initElemTypeToElemNameColumnsMap() {
        this.elemTypeToElemNameColumns.put(ResultElementType.PROGRAM, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.ASSEMBLER_CSECT, DatabaseMetadata.CHILD_PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.ASSEMBLER_ENTRY, DatabaseMetadata.CHILD_PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(this.getSpecificElementType(), DatabaseMetadata.MACRO_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.INCLUDE, DatabaseMetadata.INCLUDE_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_TYPE, DatabaseMetadata.STMT_DESC.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.STMT_SOURCE_INFO, DatabaseMetadata.PRG_NAME.getName());
        this.elemTypeToElemNameColumns.put(ResultElementType.PROJECT_INFO, ResultElementType.PROJECT_INFO.name());
    }

    @Override
    public Map<String, List<ColumnInfo>> getCSVColumnInfo() {
        HashMap<String, List<ColumnInfo>> csvHeader = new HashMap<String, List<ColumnInfo>>(){
            {
                ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                this.put(ResultElementType.PROJECT_INFO.name(), list);
                list.add(DatabaseMetadata.PROJECT_NAME);
                list = new ArrayList();
                this.put(ResultElementType.STMT_TYPE.name(), list);
                list.add(DatabaseMetadata.STMT_DESC);
                list.add(DatabaseMetadata.STMT_START_ROW);
                list.add(DatabaseMetadata.STMT_START_COL);
                list.add(DatabaseMetadata.STMT_END_ROW);
                list.add(DatabaseMetadata.STMT_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.PROGRAM.name(), list);
                list.add(DatabaseMetadata.PRG_ID);
                list.add(DatabaseMetadata.PRG_NAME);
                list.add(DatabaseMetadata.PRG_TYPE_ID);
                list.add(DatabaseMetadata.PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.ASSEMBLER_CSECT.name(), list);
                list.add(DatabaseMetadata.CHILD_PRG_ID);
                list.add(DatabaseMetadata.CHILD_PRG_NAME);
                list.add(DatabaseMetadata.CHILD_PRG_TYPE_ID);
                list.add(DatabaseMetadata.CHILD_PRG_PATH);
                list = new ArrayList();
                this.put(ResultElementType.MACRO.name(), list);
                list.add(DatabaseMetadata.MACRO_NAME);
                list.add(DatabaseMetadata.MACRO_PATH);
                list.add(DatabaseMetadata.MACRO_START_ROW);
                list.add(DatabaseMetadata.MACRO_START_COL);
                list.add(DatabaseMetadata.MACRO_END_ROW);
                list.add(DatabaseMetadata.MACRO_END_COL);
                list = new ArrayList();
                this.put(ResultElementType.INCLUDE.name(), list);
                list.add(DatabaseMetadata.INCLUDE_NAME);
                list.add(DatabaseMetadata.INCLUDE_PATH);
            }
        };
        return csvHeader;
    }

    @Override
    public ResultElementType getSpecificElementType() {
        return ResultElementType.MACRO;
    }

    @Override
    public int getDefaultExpandLevel() {
        int level = 5;
        if (this.hasManyProjects()) {
            level = 6;
        }
        return level;
    }

    @Override
    public String getProcedurePrefix() {
        return String.valueOf(super.getProcedurePrefix()) + "AssemblerProgram";
    }

    @Override
    public Map<String, ColumnInfo[]> getStoreProceduresTempTables() {
        HashMap<String, ColumnInfo[]> tempTables = new HashMap<String, ColumnInfo[]>();
        tempTables.put("#tempcsect", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#nocsect", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempentry", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#noentry", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#temppara", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#nopara_notin", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        tempTables.put("#nopara", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempincl", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#noincl_notin", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        tempTables.put("#noincl", new ColumnInfo[]{DatabaseMetadata.PRG_ID, DatabaseMetadata.PRG_NAME});
        tempTables.put("#tempids", new ColumnInfo[]{DatabaseMetadata.PRG_ID});
        tempTables.put("#sr", new ColumnInfo[]{DatabaseMetadata.RESOURCE_OCCURID, DatabaseMetadata.RESOURCE_ID});
        return tempTables;
    }

    @Override
    public Map<String, String> getStoreProceduresAditionalTempTable() {
        HashMap<String, String> tablesMap = new HashMap<String, String>();
        String performanceQ = "SELECT_OR_INSERT_INTO #sr SELECT_MARKER\nFROM( \n     SELECT OccurID, ResourceID\n                ,ROW_NUMBER() OVER(PARTITION BY OccurID, ResourceID ORDER BY OccurID) AS RN \n\t FROM  StatementReference \n\t WHERE ResourceType = 98 \n\t        AND StatementType = 819 \n      )src WHERE RN = 1 @@@@@EZLEGACY@@@@";
        performanceQ = String.valueOf(performanceQ) + "\n CREATE UNIQUE INDEX sr_unq_idx ON #sr (OccurID ASC, ResourceID ASC)@@@@@EZLEGACY@@@@";
        tablesMap.put("#sr", performanceQ);
        return tablesMap;
    }
}

