/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.annotations;

import com.ez.analysis.mainframe.usage.model.ResultElement;
import com.ez.analysis.mainframe.usage.ui.UsageViewer;
import com.ez.analysis.mainframe.usage.ui.Utils;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotatedViewer;
import com.ez.mainframe.gui.annotatedresults.AnnotationPartStateManager;
import com.ez.mainframe.model.ProjectInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsagesAnnotationPartStateManager
extends AnnotationPartStateManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UsagesAnnotationPartStateManager.class);
    private UsageViewer viewer;

    public UsagesAnnotationPartStateManager(UsageViewer usageViewer) {
        this.viewer = usageViewer;
    }

    public boolean considerElement(AbstractResultElement elem) {
        ResultElementType type = elem.getType();
        boolean ret = ResultElementType.JCL_JOB.equals((Object)type) || ResultElementType.PROGRAM.equals((Object)type) || ResultElementType.JCL_STEP.equals((Object)type) || ResultElementType.COBOL_OR_DDCL.equals((Object)type) || ResultElementType.SCL_PROCEDURE.equals((Object)type) || ResultElementType.ASSEMBLER_CSECT.equals((Object)type) || ResultElementType.ASSEMBLER_ENTRY.equals((Object)type) || ResultElementType.CATALOG_TARGET.equals((Object)type);
        return ret;
    }

    public EZObjectType buildInputType(AbstractResultElement resultElem) {
        EZObjectType inputType = null;
        List projectList = (List)resultElem.getProperty("ProjectInfo List");
        if (projectList != null) {
            for (ProjectInfo pi : projectList) {
                try {
                    inputType = Utils.createApplicableInputType((ResultElement)resultElem, pi);
                }
                catch (Exception ex) {
                    L.warn("error creating inputType for element: " + resultElem, (Throwable)ex);
                }
            }
        }
        return inputType;
    }

    public void dispose() {
        this.viewer = null;
        super.dispose();
    }

    protected AnnotatedViewer getViewer() {
        return this.viewer;
    }
}

