/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.all;

import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ProgramWithAncestorFilterEntryParameterGenerator
implements FilterEntryParameterGenerator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public List<String> addParameters(FilterData filterData, List<String> procParamsList, FilterEntry e) {
        String value = null;
        if (e.canModify(3)) {
            value = e.getValidAttribute(3);
        }
        if (value != null) {
            procParamsList.add(String.valueOf(Integer.valueOf(value)));
        }
        String validAttribute = e.getValidAttribute(2);
        StringBuilder programs = new StringBuilder();
        StringBuilder ancestors = new StringBuilder();
        HashSet<String> entries = new HashSet<String>(Arrays.asList(validAttribute.split(",")));
        boolean useAncestorInformation = false;
        for (String entry : entries) {
            String ancestor = "";
            if (programs.length() > 0) {
                programs.append(",");
            }
            if (useAncestorInformation) {
                String[] split = entry.split(":");
                String program = "";
                if (split.length == 2) {
                    ancestor = split[0];
                    program = split[1];
                } else if (entry.endsWith(":") && split.length <= 1) {
                    if (split.length == 1) {
                        ancestor = split[0];
                    }
                } else {
                    program = entry;
                }
                programs.append(program);
            } else {
                programs.append(entry);
            }
            if (useAncestorInformation && ancestor.isEmpty()) {
                useAncestorInformation = false;
                ancestors = new StringBuilder();
            }
            if (!useAncestorInformation) continue;
            if (ancestors.length() > 0) {
                ancestors.append(",");
            }
            ancestors.append(ancestor);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(programs.toString());
        list.add(ancestors.toString());
        return list;
    }
}

