/*
 * Decompiled with CFR 0.152.
 */
package com.ez.analysis.mainframe.usage.all;

import com.ez.analysis.mainframe.usage.adapters.FilterData;
import com.ez.analysis.mainframe.usage.adapters.FilterEntryParameterGenerator;
import com.ez.analysis.mainframe.usage.model.FilterEntry;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;

public class DatasetFilterEntryParameterGenerator
implements FilterEntryParameterGenerator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    @Override
    public List<String> addParameters(FilterData filterData, List<String> procParamsList, FilterEntry e) {
        IPreferenceStore store = PreferenceUtils.getPreferenceStore();
        boolean displayTemptDatasets = store.getBoolean("displayTemporaryDatasets");
        procParamsList.add(displayTemptDatasets ? "1" : "0");
        String value = null;
        if (e.canModify(3)) {
            value = e.getValidAttribute(3);
        }
        if (value != null) {
            procParamsList.add(String.valueOf(Integer.valueOf(value)));
        }
        ArrayList<String> list = new ArrayList<String>();
        String values = e.getValidAttribute(2);
        HashSet<String> entries = new HashSet<String>(Arrays.asList(values.split(",")));
        StringBuilder datasetNames = new StringBuilder();
        HashSet<String> datasetMemberNames = new HashSet<String>();
        boolean appendComa = false;
        boolean useMemberName = false;
        Pattern pattern = Pattern.compile("(.*)\\((.*)\\)");
        for (String val : entries) {
            String datasetMemberName;
            String datasetName;
            if (appendComa) {
                datasetNames.append(',');
            } else {
                appendComa = true;
            }
            val = val.trim();
            Matcher matcher = pattern.matcher(val);
            if (matcher.matches()) {
                datasetName = val.replaceAll("(.*)\\((.*)\\)", "$1").trim();
                datasetMemberName = val.replaceAll("(.*)\\((.*)\\)", "$2").trim();
                useMemberName = true;
            } else {
                datasetName = val;
                datasetMemberName = " ";
            }
            datasetNames.append(datasetName);
            datasetMemberNames.add(datasetMemberName);
        }
        list.add(datasetNames.toString());
        StringBuilder sb = new StringBuilder();
        if (useMemberName && !datasetMemberNames.isEmpty()) {
            for (String m : datasetMemberNames) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(m);
            }
        }
        list.add(sb.toString());
        return list;
    }
}

